/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.security.InvalidParameterException;
import java.util.Iterator;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralTableNodeIterator;

public class StructuralTableNode
implements StructuralNode {
    private RecordStructure rs;
    private StructuralNode parent = null;
    private static ExtensionHistory extHistory = null;

    public StructuralTableNode(RecordStructure recordStructure) {
        if (recordStructure == null) {
            throw new InvalidParameterException("RecordStructure must not be null");
        }
        this.rs = recordStructure;
    }

    @Override
    public StructuralNode getParent() throws DatabaseException {
        if (this.parent == null && !this.isRoot()) {
            RecordStructure recordStructure = Model.getSingleton().getDb().getTableStructure().read(this.rs.getSessionId(), this.rs.getStructureId());
            if (recordStructure == null) {
                throw new InvalidParameterException("Failed to find parent sessionId=" + this.rs.getSessionId() + " parentId=" + this.rs.getParentId());
            }
            this.parent = new StructuralTableNode(recordStructure);
        }
        return this.parent;
    }

    @Override
    public Iterator<StructuralNode> getChildIterator() {
        return new StructuralTableNodeIterator(this);
    }

    @Override
    public long getChildNodeCount() throws DatabaseException {
        return Model.getSingleton().getDb().getTableStructure().getChildCount(this.rs.getSessionId(), this.rs.getParentId());
    }

    @Override
    public HistoryReference getHistoryReference() {
        return StructuralTableNode.getExtensionHistory().getHistoryReference(this.rs.getHistoryId());
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.rs.getUrl(), true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.rs.getName();
    }

    @Override
    public boolean isRoot() {
        return "Root".equals(this.rs.getUrl());
    }

    @Override
    public boolean isLeaf() {
        return !this.getChildIterator().hasNext();
    }

    protected RecordStructure getRecordStructure() {
        return this.rs;
    }

    @Override
    public boolean isSameAs(StructuralNode structuralNode) {
        if (structuralNode instanceof StructuralTableNode) {
            return this.rs.getStructureId() == ((StructuralTableNode)structuralNode).rs.getStructureId();
        }
        return false;
    }

    private static ExtensionHistory getExtensionHistory() {
        if (extHistory == null) {
            extHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        }
        return extHistory;
    }
}

