/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, long l) {
        super(cArray, n, l);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
        int n2 = typeReferenceArray.length;
        for (int i = 0; i < n2; ++i) {
            if ((typeReferenceArray[i].bits & 0x100000) == 0) continue;
            this.bits |= 0x100000;
            break;
        }
    }

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, Annotation[][] annotationArray, long l) {
        this(cArray, typeReferenceArray, n, l);
        this.setAnnotationsOnDimensions(annotationArray);
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
    }

    @Override
    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
        this.checkNullConstraints(scope, this.typeArguments);
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ParameterizedSingleTypeReference parameterizedSingleTypeReference = new ParameterizedSingleTypeReference(this.token, this.typeArguments, n2, annotationArray2, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        parameterizedSingleTypeReference.annotations = this.annotations;
        parameterizedSingleTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            parameterizedSingleTypeReference.extendedDimensions = n;
        }
        return parameterizedSingleTypeReference;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n2 = this.typeArguments.length;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n].getParameterizedTypeName(), '.'));
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n3 = this.dimensions;
        if (n3 > 0) {
            char[] cArray2 = new char[n3 * 2];
            for (int i = 0; i < n3; ++i) {
                int n4 = i * 2;
                cArray2[n4] = 91;
                cArray2[n4 + 1] = 93;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    @Override
    public TypeReference[][] getTypeArguments() {
        return new TypeReference[][]{this.typeArguments};
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    @Override
    public boolean isParameterizedTypeReference() {
        return true;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, boolean bl, int n) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding typeBinding = this.internalResolveLeafType(scope, referenceBinding, bl);
        if (typeBinding == null) {
            this.resolvedType = this.createArrayType(scope, this.resolvedType);
            this.resolveAnnotations(scope, 0);
            if (bl) {
                this.checkNullConstraints(scope, this.typeArguments);
            }
            return null;
        }
        typeBinding = this.createArrayType(scope, typeBinding);
        if (!this.resolvedType.isValidBinding() && this.resolvedType.dimensions() == typeBinding.dimensions()) {
            this.resolveAnnotations(scope, 0);
            if (bl) {
                this.checkNullConstraints(scope, this.typeArguments);
            }
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        this.resolveAnnotations(scope, n);
        if (bl) {
            this.checkNullConstraints(scope, this.typeArguments);
        }
        return this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, ReferenceBinding typeBinding, boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        Object object;
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        if (typeBinding == null) {
            this.resolvedType = scope.getType(this.token);
            if (this.resolvedType.isValidBinding()) {
                referenceBinding = (ReferenceBinding)this.resolvedType;
            } else {
                this.reportInvalidType(scope);
                switch (this.resolvedType.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        typeBinding2 = this.resolvedType.closestMatch();
                        if (typeBinding2 instanceof ReferenceBinding) {
                            referenceBinding = (ReferenceBinding)typeBinding2;
                            break;
                        }
                    }
                    default: {
                        boolean bl2 = scope.kind == 3;
                        for (TypeReference typeReference : this.typeArguments) {
                            if (bl2) {
                                typeReference.resolveType((ClassScope)scope);
                                continue;
                            }
                            typeReference.resolveType((BlockScope)scope, bl);
                        }
                        return null;
                    }
                }
            }
            typeBinding = referenceBinding.enclosingType();
            if (typeBinding != null) {
                typeBinding = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(typeBinding, false) : scope.environment().convertToParameterizedType((ReferenceBinding)typeBinding);
                referenceBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding);
            }
        } else {
            referenceBinding = scope.getMemberType(this.token, (ReferenceBinding)typeBinding);
            this.resolvedType = referenceBinding;
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, referenceBinding, (ReferenceBinding)typeBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(referenceBinding, scope)) {
                scope.problemReporter().deprecatedType(referenceBinding, this);
            }
            if ((typeBinding2 = referenceBinding.enclosingType()) != null && TypeBinding.notEquals(typeBinding2.erasure(), typeBinding.erasure())) {
                typeBinding = typeBinding2;
            }
        }
        boolean bl3 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl3) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        boolean bl4 = (this.bits & 0x80000) != 0;
        int n = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        boolean bl5 = false;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
        for (int i = 0; i < n; ++i) {
            object = this.typeArguments[i];
            TypeBinding typeBinding3 = bl3 ? ((TypeReference)object).resolveTypeArgument((ClassScope)scope, referenceBinding2, i) : ((TypeReference)object).resolveTypeArgument((BlockScope)scope, referenceBinding2, i);
            this.bits |= ((TypeReference)object).bits & 0x100000;
            if (typeBinding3 == null) {
                bl5 = true;
                continue;
            }
            typeBindingArray[i] = typeBinding3;
        }
        if (bl5) {
            return null;
        }
        if (bl3) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                return null;
            }
        }
        if ((typeVariableBindingArray = referenceBinding2.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
            boolean bl6;
            boolean bl7 = bl6 = scope.compilerOptions().originalSourceLevel >= 0x310000L;
            if ((referenceBinding2.tagBits & 0x80L) == 0L && bl6) {
                this.resolvedType = referenceBinding;
                scope.problemReporter().nonGenericTypeCannotBeParameterized(0, this, referenceBinding, typeBindingArray);
                return null;
            }
            if (!bl6) {
                if (!this.resolvedType.isValidBinding()) {
                    return referenceBinding;
                }
                this.resolvedType = referenceBinding;
                return this.resolvedType;
            }
        } else if (n != typeVariableBindingArray.length) {
            if (!bl4) {
                scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray);
                return null;
            }
        } else if (!referenceBinding.isStatic() && (object = referenceBinding.enclosingType()) != null && ((TypeBinding)object).isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)object), typeBindingArray);
            return null;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)typeBinding);
        if (!bl4) {
            if (bl) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            } else {
                scope.deferBoundCheck(this);
            }
        }
        if (this.isTypeUseDeprecated(parameterizedTypeBinding, scope)) {
            this.reportDeprecatedType(parameterizedTypeBinding, scope);
        }
        if (!this.resolvedType.isValidBinding()) {
            return parameterizedTypeBinding;
        }
        this.resolvedType = parameterizedTypeBinding;
        return this.resolvedType;
    }

    private TypeBinding createArrayType(Scope scope, TypeBinding typeBinding) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            return scope.createArrayType(typeBinding, this.dimensions);
        }
        return typeBinding;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.annotations != null && this.annotations[0] != null) {
            ParameterizedSingleTypeReference.printAnnotations(this.annotations[0], stringBuffer);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n3 = this.typeArguments.length;
        if (n3 > 0) {
            int n4 = n3 - 1;
            for (n2 = 0; n2 < n4; ++n2) {
                this.typeArguments[n2].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n4].print(0, stringBuffer);
        }
        stringBuffer.append(">");
        Annotation[][] annotationArray = this.getAnnotationsOnDimensions();
        if ((this.bits & 0x4000) != 0) {
            for (n2 = 0; n2 < this.dimensions - 1; ++n2) {
                if (annotationArray != null && annotationArray[n2] != null) {
                    stringBuffer.append(" ");
                    ParameterizedSingleTypeReference.printAnnotations(annotationArray[n2], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
            }
            if (annotationArray != null && annotationArray[this.dimensions - 1] != null) {
                stringBuffer.append(" ");
                ParameterizedSingleTypeReference.printAnnotations(annotationArray[this.dimensions - 1], stringBuffer);
                stringBuffer.append(" ");
            }
            stringBuffer.append("...");
        } else {
            for (n2 = 0; n2 < this.dimensions; ++n2) {
                if (annotationArray != null && annotationArray[n2] != null) {
                    stringBuffer.append(" ");
                    ParameterizedSingleTypeReference.printAnnotations(annotationArray[n2], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        return this.internalResolveType(blockScope, null, bl, n);
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope, int n) {
        return this.internalResolveType(classScope, null, false, n);
    }

    @Override
    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true, 0);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            Annotation[][] annotationArray;
            if (this.annotations != null) {
                annotationArray = this.annotations[0];
                int n3 = n2 = annotationArray == null ? 0 : annotationArray.length;
                for (n = 0; n < n2; ++n) {
                    annotationArray[n].traverse(aSTVisitor, blockScope);
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                for (Annotation[] annotationArray2 : annotationArray) {
                    if (annotationArray2 == null) continue;
                    int n4 = annotationArray2.length;
                    for (int i = 0; i < n4; ++i) {
                        Annotation annotation = annotationArray2[i];
                        annotation.traverse(aSTVisitor, blockScope);
                    }
                }
            }
            n2 = this.typeArguments.length;
            for (n = 0; n < n2; ++n) {
                this.typeArguments[n].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            Annotation[][] annotationArray;
            if (this.annotations != null) {
                annotationArray = this.annotations[0];
                int n3 = n2 = annotationArray == null ? 0 : annotationArray.length;
                for (n = 0; n < n2; ++n) {
                    annotationArray[n].traverse(aSTVisitor, classScope);
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                for (Annotation[] annotationArray2 : annotationArray) {
                    for (Annotation annotation : annotationArray2) {
                        annotation.traverse(aSTVisitor, classScope);
                    }
                }
            }
            n2 = this.typeArguments.length;
            for (n = 0; n < n2; ++n) {
                this.typeArguments[n].traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

