/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.utils.GBCBuilder;

public abstract class AbstractButtonsDialog
extends JDialog {
    public static final int CLOSE_ID = 0;
    public static final int SAVE_ID = 1;
    public static final int CANCEL_ID = 2;
    public static final int CLIENT_ID = 1024;
    private Dimension _size;
    private String _caption;
    private int _buttonNextPlace = 0;
    private int _buttonClickedId;

    protected abstract void createDialogArea(JPanel var1);

    protected void buttonPressed(int buttonId) {
        this.dispose();
    }

    protected AbstractButtonsDialog(String caption) {
        this((Dimension)null, caption);
    }

    protected AbstractButtonsDialog(Dimension size, String caption) {
        this._size = size;
        this._caption = caption;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public void create() {
        this.createContents();
        this.setTitle(this._caption);
        if (this._size != null) {
            this.setSize(this._size);
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createContents() {
        JPanel main = new JPanel();
        BorderLayout mainLayout = new BorderLayout(5, 5);
        main.setLayout(mainLayout);
        this.getContentPane().add(main);
        JPanel content = new JPanel();
        main.add((Component)content, "Center");
        JPanel buttonBar = new JPanel();
        main.add((Component)buttonBar, "Last");
        this.createDialogArea(content);
        this.createButtonsForButtonBar(buttonBar);
    }

    protected void createButtonsForButtonBar(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        this.createButton(panel, 2, Messages.NLS("Cancel"));
        this.createButton(panel, 1, Messages.NLS("Save"));
    }

    protected void createButton(JPanel panel, final int id, String label) {
        JButton button = new JButton(label);
        panel.add((Component)button, new GBCBuilder().gridx(this._buttonNextPlace++).gridy(0).insets(new Insets(5, 5, 5, 5)).build());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractButtonsDialog.this._buttonClickedId = id;
                AbstractButtonsDialog.this.buttonPressed(id);
            }
        });
    }

    public int getButtonClickedId() {
        return this._buttonClickedId;
    }
}

