/* libide-1.0.vapi generated by vapigen-0.30, do not modify. */

[CCode (cprefix = "Ide", gir_namespace = "Ide", gir_version = "1.0", lower_case_cprefix = "ide_")]
namespace Ide {
	[CCode (cheader_filename = "ide.h", type_id = "ide_back_forward_item_get_type ()")]
	public class BackForwardItem : Ide.Object {
		[CCode (has_construct_function = false)]
		public BackForwardItem (Ide.Context context, Ide.SourceLocation location);
		public bool chain (Ide.BackForwardItem other);
		public Ide.SourceLocation get_location ();
		public Ide.SourceLocation location { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_back_forward_list_get_type ()")]
	public class BackForwardList : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BackForwardList ();
		public Ide.BackForwardList branch ();
		public bool get_can_go_backward ();
		public bool get_can_go_forward ();
		public unowned Ide.BackForwardItem? get_current_item ();
		public void go_backward ();
		public void go_forward ();
		public void merge (Ide.BackForwardList branch);
		public void push (Ide.BackForwardItem item);
		public bool can_go_backward { get; }
		public bool can_go_forward { get; }
		public Ide.BackForwardItem current_item { get; }
		public signal void navigate_to (Ide.BackForwardItem object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_get_type ()")]
	public class Buffer : Gtk.SourceBuffer {
		[CCode (has_construct_function = false)]
		protected Buffer ();
		public void check_for_volume_change ();
		public bool get_busy ();
		public size_t get_change_count ();
		public bool get_changed_on_volume ();
		public GLib.Bytes get_content ();
		public unowned Ide.Context get_context ();
		public unowned Ide.Diagnostic? get_diagnostic_at_iter (Gtk.TextIter iter);
		public unowned Ide.File get_file ();
		public bool get_highlight_diagnostics ();
		public void get_iter_at_source_location (Gtk.TextIter iter, Ide.SourceLocation location);
		public Ide.BufferLineFlags get_line_flags (uint line);
		public bool get_read_only ();
		public void get_selection_bounds (Gtk.TextIter insert, Gtk.TextIter selection);
		public unowned string get_style_scheme_name ();
		public async Ide.Symbol get_symbol_at_location_async (Gtk.TextIter location, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.SymbolResolver? get_symbol_resolver ();
		public unowned string get_title ();
		public string get_word_at_iter (Gtk.TextIter iter);
		public void hold ();
		public void rehighlight ();
		public void release ();
		public void set_file (Ide.File file);
		public void set_highlight_diagnostics (bool highlight_diagnostics);
		public void set_style_scheme_name (string style_scheme_name);
		public void sync_to_unsaved_files ();
		public void trim_trailing_whitespace ();
		public bool busy { get; }
		public bool changed_on_volume { get; }
		public Ide.Context context { get; construct; }
		public Ide.File file { get; set; }
		[NoAccessorMethod]
		public bool has_diagnostics { get; }
		public bool highlight_diagnostics { get; set; }
		public bool read_only { get; }
		public string style_scheme_name { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		public virtual signal void cursor_moved (Gtk.TextIter location);
		public signal void line_flags_changed ();
		public signal void loaded ();
		public signal void saved ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_change_monitor_get_type ()")]
	public class BufferChangeMonitor : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BufferChangeMonitor ();
		public void emit_changed ();
		public virtual Ide.BufferLineChange get_change (Gtk.TextIter iter);
		[NoWrapper]
		public virtual void set_buffer (Ide.Buffer buffer);
		public Ide.Buffer buffer { construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_manager_get_type ()")]
	public class BufferManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected BufferManager ();
		public Ide.Buffer create_temporary_buffer ();
		public unowned Ide.Buffer? find_buffer (GLib.File file);
		public GLib.GenericArray<weak Ide.Buffer> get_buffers ();
		public unowned Ide.Buffer get_focus_buffer ();
		public size_t get_max_file_size ();
		public uint get_n_buffers ();
		public unowned Gtk.SourceCompletionWords get_word_completion ();
		public bool has_file (GLib.File file);
		public async Ide.Buffer load_file_async (Ide.File file, bool force_reload, out Ide.Progress? progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_file_async (Ide.Buffer buffer, Ide.File file, Ide.Progress progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_focus_buffer (Ide.Buffer buffer);
		public void set_max_file_size (size_t max_file_size);
		[NoAccessorMethod]
		public bool auto_save { get; set; }
		[NoAccessorMethod]
		public uint auto_save_timeout { get; set; }
		public Ide.Buffer focus_buffer { get; set; }
		public signal void buffer_focus_enter (Ide.Buffer buffer);
		public signal void buffer_focus_leave (Ide.Buffer buffer);
		public signal void buffer_loaded (Ide.Buffer buffer);
		public signal void buffer_saved (Ide.Buffer buffer);
		public signal Ide.Buffer? create_buffer (Ide.File file);
		public signal void load_buffer (Ide.Buffer buffer);
		public signal void save_buffer (Ide.Buffer buffer);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_result_get_type ()")]
	public class BuildResult : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BuildResult ();
		public unowned GLib.InputStream get_stderr_stream ();
		public unowned GLib.InputStream? get_stdout_stream ();
		public void log_subprocess (GLib.Subprocess subprocess);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_builder_get_type ()")]
	public abstract class Builder : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Builder ();
		public virtual async Ide.BuildResult build_async (Ide.BuilderBuildFlags flags, Ide.BuildResult result, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_item_get_type ()")]
	public abstract class CompletionItem : GLib.Object {
		[CCode (has_construct_function = false)]
		public CompletionItem ();
		public static string fuzzy_highlight (string haystack, string casefold_query);
		public static bool fuzzy_match (string haystack, string casefold_needle, out uint priority);
		public virtual bool match (string query, string casefold);
		public void set_priority (uint priority);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_results_get_type ()")]
	public class CompletionResults : GLib.Object {
		[CCode (has_construct_function = false)]
		public CompletionResults (string query);
		[NoWrapper]
		public virtual int compare (Ide.CompletionItem left, Ide.CompletionItem right);
		public unowned string get_query ();
		public void invalidate_sort ();
		public void present (Gtk.SourceCompletionProvider provider, Gtk.SourceCompletionContext context);
		public bool replay (string query);
		public void take_proposal (owned Ide.CompletionItem proposal);
		public string query { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_context_get_type ()")]
	public class Context : GLib.Object, GLib.AsyncInitable {
		[CCode (cname = "ide_context_new_async", has_construct_function = false)]
		public async Context (GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.BackForwardList get_back_forward_list ();
		public unowned Ide.BufferManager get_buffer_manager ();
		public unowned Ide.BuildSystem get_build_system ();
		public unowned Ide.DeviceManager get_device_manager ();
		public unowned Ide.Project get_project ();
		public unowned GLib.File get_project_file ();
		public unowned Gtk.RecentManager get_recent_manager ();
		public unowned string get_root_build_dir ();
		public unowned Ide.ScriptManager get_script_manager ();
		public unowned Ide.SearchEngine get_search_engine ();
		public void* get_service_typed (GLib.Type service_type);
		public Ide.Settings get_settings (string schema_id, string relative_path);
		public unowned Ide.SourceSnippetsManager get_snippets_manager ();
		public unowned Ide.UnsavedFiles get_unsaved_files ();
		public unowned Ide.Vcs get_vcs ();
		public void hold ();
		public void release ();
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_root_build_dir (string root_build_dir);
		public async bool unload_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public Ide.BackForwardList back_forward_list { get; }
		public Ide.BufferManager buffer_manager { get; }
		public Ide.BuildSystem build_system { get; }
		public Ide.DeviceManager device_manager { get; }
		public Ide.Project project { get; }
		public GLib.File project_file { get; construct; }
		public string root_build_dir { get; set; }
		public Ide.ScriptManager script_manager { get; }
		public Ide.SearchEngine search_engine { get; }
		[NoAccessorMethod]
		public Ide.SourceSnippetsManager snippets_manager { owned get; set; }
		public Ide.UnsavedFiles unsaved_files { get; }
		public Ide.Vcs vcs { get; }
		public signal void loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_deployer_get_type ()")]
	public abstract class Deployer : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Deployer ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_get_type ()")]
	public abstract class Device : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Device ();
		public virtual unowned GLib.KeyFile? get_config ();
		public unowned string? get_display_name ();
		public unowned string get_id ();
		public virtual unowned string get_system_type ();
		public void set_display_name (string display_name);
		public void set_id (string id);
		public string display_name { get; set; }
		public string id { get; set; }
		public string system_type { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_manager_get_type ()")]
	public class DeviceManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		public void add_provider (Ide.DeviceProvider provider);
		public unowned Ide.Device get_device (string device_id);
		public GLib.GenericArray<weak Ide.Device> get_devices ();
		public bool get_settled ();
		public void remove_provider (Ide.DeviceProvider provider);
		public bool settled { get; }
		public signal void device_added (Ide.DeviceProvider object, Ide.Device p0);
		public signal void device_removed (Ide.DeviceProvider object, Ide.Device p0);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_diagnostic_ref", type_id = "ide_diagnostic_get_type ()", unref_function = "ide_diagnostic_unref")]
	[Compact]
	public class Diagnostic {
		[CCode (has_construct_function = false)]
		public Diagnostic (Ide.DiagnosticSeverity severity, string text, Ide.SourceLocation location);
		public void add_range (Ide.SourceRange range);
		public unowned Ide.Fixit get_fixit (uint index);
		public unowned Ide.SourceLocation get_location ();
		public uint get_num_fixits ();
		public uint get_num_ranges ();
		public unowned Ide.SourceRange? get_range (uint index);
		public Ide.DiagnosticSeverity get_severity ();
		public unowned string get_text ();
		public string get_text_for_display ();
		public Ide.Diagnostic @ref ();
		public void take_fixit (owned Ide.Fixit fixit);
		public void take_range (owned Ide.SourceRange range);
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_diagnostician_get_type ()")]
	public class Diagnostician : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Diagnostician ();
		public async Ide.Diagnostics diagnose_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Gtk.SourceLanguage get_language ();
		public void set_language (Gtk.SourceLanguage language);
		public Gtk.SourceLanguage language { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_diagnostics_ref", type_id = "ide_diagnostics_get_type ()", unref_function = "ide_diagnostics_unref")]
	[Compact]
	public class Diagnostics {
		[CCode (has_construct_function = false)]
		public Diagnostics (owned GLib.GenericArray<Ide.Diagnostic>? ar);
		public size_t get_size ();
		public unowned Ide.Diagnostic index (size_t index);
		public void merge (Ide.Diagnostics other);
		public Ide.Diagnostics @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_directory_vcs_get_type ()")]
	public class DirectoryVcs : Ide.Vcs, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		protected DirectoryVcs ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_doap_get_type ()")]
	public class Doap : GLib.Object {
		[CCode (has_construct_function = false)]
		public Doap ();
		public unowned string get_bug_database ();
		public unowned string get_category ();
		public unowned string get_description ();
		public unowned string get_download_page ();
		public unowned string get_homepage ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.List<Ide.DoapPerson> get_maintainers ();
		public unowned string get_name ();
		public unowned string get_shortdesc ();
		public bool load_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public string bug_database { owned get; set; }
		[NoAccessorMethod]
		public string category { owned get; set; }
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string download_page { owned get; set; }
		[NoAccessorMethod]
		public string homepage { owned get; set; }
		[NoAccessorMethod]
		public string languages { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string shortdesc { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_doap_person_get_type ()")]
	public class DoapPerson : GLib.Object {
		[CCode (has_construct_function = false)]
		public DoapPerson ();
		public unowned string get_email ();
		public unowned string get_name ();
		public void set_email (string email);
		public void set_name (string name);
		public string email { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_extension_adapter_get_type ()")]
	public class ExtensionAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionAdapter (Ide.Context context, Peas.Engine? engine, GLib.Type interface_type, string key, string? value);
		public unowned Peas.Engine get_engine ();
		public unowned GLib.Object get_extension ();
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Object extension { get; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_extension_set_adapter_get_type ()")]
	public class ExtensionSetAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionSetAdapter (Ide.Context context, Peas.Engine engine, GLib.Type interface_type, string key, string value);
		public void @foreach (Ide.ExtensionSetAdapterForeachFunc foreach_func);
		public unowned Peas.Engine get_engine ();
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public uint get_n_extensions ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
		public signal void extension_added (Peas.PluginInfo object, GLib.Object p0);
		public signal void extension_removed (Peas.PluginInfo object, GLib.Object p0);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_file_get_type ()")]
	public class File : Ide.Object {
		[CCode (has_construct_function = false)]
		public File (Ide.Context? context, GLib.File file);
		public bool equal (Ide.File other);
		public async Ide.File? find_other_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned GLib.File get_file ();
		public bool get_is_temporary ();
		public unowned Gtk.SourceLanguage? get_language ();
		public unowned string get_path ();
		public unowned string get_project_path ();
		public uint get_temporary_id ();
		public uint hash ();
		public async Ide.FileSettings load_settings_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.File file { get; construct; }
		public bool is_temporary { get; }
		public Gtk.SourceLanguage language { get; }
		public string path { get; construct; }
		public uint temporary_id { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_file_settings_get_type ()")]
	public class FileSettings : Ide.Object {
		[CCode (has_construct_function = false)]
		public FileSettings (Ide.File file);
		public unowned Ide.File get_file ();
		public bool get_settled ();
		[NoAccessorMethod]
		public string encoding { owned get; set; }
		[NoAccessorMethod]
		public bool encoding_set { get; set; }
		public Ide.File file { get; construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { get; set; }
		[NoAccessorMethod]
		public bool indent_style_set { get; set; }
		[NoAccessorMethod]
		public int indent_width { get; set; }
		[NoAccessorMethod]
		public bool indent_width_set { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline_set { get; set; }
		[NoAccessorMethod]
		public Gtk.SourceNewlineType newline_type { get; set; }
		[NoAccessorMethod]
		public bool newline_type_set { get; set; }
		[NoAccessorMethod]
		public uint right_margin_position { get; set; }
		[NoAccessorMethod]
		public bool right_margin_position_set { get; set; }
		[NoAccessorMethod]
		public bool settled { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin_set { get; set; }
		[NoAccessorMethod]
		public uint tab_width { get; set; }
		[NoAccessorMethod]
		public bool tab_width_set { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace_set { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_fixit_ref", type_id = "ide_fixit_get_type ()", unref_function = "ide_fixit_unref")]
	[Compact]
	public class Fixit {
		public void apply ();
		public unowned Ide.SourceRange get_range ();
		public unowned string get_text ();
		public Ide.Fixit @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_git_remote_callbacks_get_type ()")]
	public class GitRemoteCallbacks : Ggit.RemoteCallbacks {
		[CCode (has_construct_function = false, type = "GgitRemoteCallbacks*")]
		public GitRemoteCallbacks ();
		public double get_fraction ();
		public unowned Ide.Progress get_progress ();
		public double fraction { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_git_vcs_get_type ()")]
	public class GitVcs : Ide.Vcs, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		protected GitVcs ();
		public unowned Ggit.Repository get_repository ();
		public Ggit.Repository repository { get; }
		public signal void reloaded (Ggit.Repository repository);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_highlight_engine_get_type ()")]
	public class HighlightEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		public HighlightEngine (Ide.Buffer buffer);
		public unowned Ide.Buffer get_buffer ();
		public unowned Ide.Highlighter get_highlighter ();
		public unowned Gtk.TextTag get_style (string style_name);
		public void invalidate (Gtk.TextIter begin, Gtk.TextIter end);
		public void rebuild ();
		public Ide.Buffer buffer { get; construct; }
		public Ide.Highlighter highlighter { get; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_highlight_index_ref", type_id = "ide_highlight_index_get_type ()", unref_function = "ide_highlight_index_unref")]
	[Compact]
	public class HighlightIndex {
		[CCode (has_construct_function = false)]
		public HighlightIndex ();
		public void dump ();
		public void insert (string word, void* tag);
		public void* lookup (string word);
		public Ide.HighlightIndex @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h")]
	[Compact]
	public class Language {
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_local_device_get_type ()")]
	public class LocalDevice : Ide.Device {
		[CCode (has_construct_function = false)]
		protected LocalDevice ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_object_get_type ()")]
	public class Object : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Object ();
		[CCode (has_construct_function = false)]
		public Object.finish (GLib.AsyncResult result) throws GLib.Error;
		public unowned Ide.Context get_context ();
		public bool hold ();
		public void release ();
		public virtual void set_context (Ide.Context context);
		public Ide.Context context { get; construct; }
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_pattern_spec_ref", type_id = "ide_pattern_spec_get_type ()", unref_function = "ide_pattern_spec_unref")]
	[Compact]
	public class PatternSpec {
		[CCode (has_construct_function = false)]
		public PatternSpec (string keywords);
		public unowned string get_text ();
		public bool match (string haystack);
		public Ide.PatternSpec @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_progress_get_type ()")]
	public class Progress : GLib.Object {
		[CCode (has_construct_function = false)]
		public Progress ();
		public static void file_progress_callback (int64 current_num_bytes, int64 total_num_bytes, void* user_data);
		public double get_fraction ();
		public unowned string get_message ();
		public void set_fraction (double fraction);
		public void set_message (string message);
		[NoAccessorMethod]
		public bool completed { get; }
		public double fraction { get; set; }
		public string message { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_get_type ()")]
	public class Project : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Project ();
		public void add_file (Ide.ProjectFile file);
		public Ide.File? get_file_for_path (string path);
		public unowned Ide.ProjectFiles? get_files ();
		public unowned string get_id ();
		public unowned string get_name ();
		public Ide.File get_project_file (GLib.File gfile);
		public unowned Ide.ProjectItem get_root ();
		public void reader_lock ();
		public void reader_unlock ();
		public async bool rename_file_async (GLib.File orig_file, GLib.File new_file, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool trash_file_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public void writer_lock ();
		public void writer_unlock ();
		public string id { get; }
		public string name { get; }
		public Ide.ProjectItem root { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_file_get_type ()")]
	public class ProjectFile : Ide.ProjectItem {
		[CCode (has_construct_function = false)]
		protected ProjectFile ();
		public unowned GLib.File get_file ();
		public unowned GLib.FileInfo get_file_info ();
		public bool get_is_directory ();
		public unowned string get_name ();
		public unowned string get_path ();
		[NoAccessorMethod]
		public GLib.File file { owned get; set; }
		[NoAccessorMethod]
		public GLib.FileInfo file_info { owned get; set; }
		public bool is_directory { get; }
		public string name { get; }
		[NoAccessorMethod]
		public string path { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_files_get_type ()")]
	public class ProjectFiles : Ide.ProjectItem {
		[CCode (has_construct_function = false)]
		protected ProjectFiles ();
		public void add_file (Ide.ProjectFile file);
		public unowned Ide.ProjectItem? find_file (GLib.File file);
		public Ide.File? get_file_for_path (string path);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_info_get_type ()")]
	public class ProjectInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ProjectInfo ();
		public int compare (Ide.ProjectInfo info2);
		public unowned string get_description ();
		public unowned GLib.File? get_directory ();
		public unowned Ide.Doap? get_doap ();
		public unowned GLib.File? get_file ();
		public bool get_is_recent ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.DateTime? get_last_modified_at ();
		public unowned string get_name ();
		public int get_priority ();
		public void set_description (string description);
		public void set_directory (GLib.File directory);
		public void set_file (GLib.File file);
		public void set_is_recent (bool is_recent);
		public void set_languages (string languages);
		public void set_name (string name);
		public void set_priority (int priority);
		public string description { get; set; }
		public GLib.File directory { get; set; }
		[NoAccessorMethod]
		public Ide.Doap doap { owned get; set; }
		public GLib.File file { get; set; }
		public bool is_recent { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] languages { get; set; }
		[NoAccessorMethod]
		public GLib.DateTime last_modified_at { owned get; set; }
		public string name { get; set; }
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_item_get_type ()")]
	public class ProjectItem : Ide.Object {
		[CCode (has_construct_function = false)]
		protected ProjectItem ();
		public void append (Ide.ProjectItem child);
		public unowned GLib.Sequence get_children ();
		public unowned Ide.ProjectItem? get_parent ();
		public void remove (Ide.ProjectItem child);
		[NoAccessorMethod]
		public Ide.ProjectItem parent { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_recent_projects_get_type ()")]
	public class RecentProjects : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public RecentProjects ();
		public async bool discover_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_busy ();
		public GLib.GenericArray<weak Ide.ProjectInfo> get_projects ();
		public void remove (GLib.List<Ide.ProjectInfo> project_infos);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_refactory_get_type ()")]
	public abstract class Refactory : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Refactory ();
	}
	[CCode (cheader_filename = "ide.h")]
	[Compact]
	public class RefactoryInterface {
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_script_get_type ()")]
	public abstract class Script : Ide.Object, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		protected Script ();
		public unowned GLib.File get_file ();
		public GLib.File file { get; construct; }
		[HasEmitter]
		public virtual signal void load ();
		[HasEmitter]
		public virtual signal void unload ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_script_manager_get_type ()")]
	public class ScriptManager : Ide.Object {
		[CCode (has_construct_function = false)]
		protected ScriptManager ();
		public unowned string get_scripts_directory ();
		public async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public string scripts_directory { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_context_get_type ()")]
	public class SearchContext : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SearchContext ();
		public void add_result (Ide.SearchProvider provider, Ide.SearchResult result);
		public void cancel ();
		public void execute (string search_terms, size_t max_results);
		public size_t get_max_results ();
		public unowned GLib.List<Ide.SearchProvider> get_providers ();
		public void provider_completed (Ide.SearchProvider provider);
		public void remove_result (Ide.SearchProvider provider, Ide.SearchResult result);
		public void set_provider_count (Ide.SearchProvider provider, uint64 count);
		public signal void completed ();
		public signal void count_set (Ide.SearchProvider object, uint64 p0);
		public signal void result_added (Ide.SearchProvider object, Ide.SearchResult p0);
		public signal void result_removed (Ide.SearchProvider object, Ide.SearchResult p0);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_engine_get_type ()")]
	public class SearchEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SearchEngine ();
		public Ide.SearchContext? search (string search_terms);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_result_get_type ()")]
	public class SearchResult : Ide.Object {
		[CCode (has_construct_function = false)]
		public SearchResult (Ide.SearchProvider provider, string title, string subtitle, float score);
		public virtual void activate ();
		public int compare (Ide.SearchResult b);
		public unowned Ide.SearchProvider get_provider ();
		public float get_score ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		[NoAccessorMethod]
		public Ide.SearchProvider provider { owned get; set; }
		public float score { get; construct; }
		public string subtitle { get; construct; }
		public string title { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_settings_get_type ()")]
	public class Settings : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Settings ();
		public void bind (string key, void* object, string property, GLib.SettingsBindFlags flags);
		public void bind_with_mapping (string key, void* object, string property, GLib.SettingsBindFlags flags, GLib.SettingsBindGetMapping? get_mapping, owned GLib.SettingsBindSetMapping? set_mapping);
		public bool get_boolean (string key);
		public GLib.Variant get_default_value (string key);
		public double get_double (string key);
		public bool get_ignore_project_settings ();
		public int get_int (string key);
		public unowned string get_relative_path ();
		public unowned string get_schema_id ();
		public string get_string (string key);
		public uint get_uint (string key);
		public GLib.Variant get_user_value (string key);
		public GLib.Variant get_value (string key);
		public void set_boolean (string key, bool val);
		public void set_double (string key, double val);
		public void set_int (string key, int val);
		public void set_string (string key, string val);
		public void set_uint (string key, uint val);
		public void set_value (string key, GLib.Variant value);
		public void unbind (string property);
		public bool ignore_project_settings { get; construct; }
		public string relative_path { get; construct; }
		public string schema_id { get; construct; }
		public signal void changed (string object);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_source_location_ref", type_id = "ide_source_location_get_type ()", unref_function = "ide_source_location_unref")]
	[Compact]
	public class SourceLocation {
		[CCode (has_construct_function = false)]
		public SourceLocation (Ide.File file, uint line, uint line_offset, uint offset);
		public unowned Ide.File get_file ();
		public uint get_line ();
		public uint get_line_offset ();
		public uint get_offset ();
		public Ide.SourceLocation @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_map_get_type ()")]
	public class SourceMap : Gtk.SourceMap, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceMap ();
		public signal void hide_map ();
		public signal void show_map ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_source_range_ref", type_id = "ide_source_range_get_type ()", unref_function = "ide_source_range_unref")]
	[Compact]
	public class SourceRange {
		[CCode (has_construct_function = false)]
		public SourceRange (Ide.SourceLocation begin, Ide.SourceLocation end);
		public unowned Ide.SourceLocation get_begin ();
		public unowned Ide.SourceLocation get_end ();
		public Ide.SourceRange @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippet_get_type ()")]
	public class SourceSnippet : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippet (string trigger, string language);
		public void add_chunk (Ide.SourceSnippetChunk chunk);
		public Ide.SourceSnippet copy ();
		public void get_chunk_range (Ide.SourceSnippetChunk chunk, Gtk.TextIter begin, Gtk.TextIter end);
		public unowned Ide.SourceSnippetContext get_context ();
		public unowned string get_description ();
		public unowned string get_language ();
		public unowned Gtk.TextMark get_mark_begin ();
		public unowned Gtk.TextMark get_mark_end ();
		public uint get_n_chunks ();
		public unowned Ide.SourceSnippetChunk get_nth_chunk (uint n);
		public unowned string get_snippet_text ();
		public int get_tab_stop ();
		public unowned string get_trigger ();
		public void set_description (string description);
		public void set_language (string language);
		public void set_snippet_text (string snippet_text);
		public void set_trigger (string trigger);
		[NoAccessorMethod]
		public Gtk.TextBuffer buffer { owned get; }
		public string description { get; set; }
		public string language { get; set; }
		public Gtk.TextMark mark_begin { get; }
		public Gtk.TextMark mark_end { get; }
		public string snippet_text { get; set; }
		public int tab_stop { get; }
		public string trigger { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippet_chunk_get_type ()")]
	public class SourceSnippetChunk : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippetChunk ();
		public Ide.SourceSnippetChunk copy ();
		public unowned Ide.SourceSnippetContext get_context ();
		public unowned string get_spec ();
		public int get_tab_stop ();
		public unowned string get_text ();
		public bool get_text_set ();
		public void set_context (Ide.SourceSnippetContext context);
		public void set_spec (string spec);
		public void set_tab_stop (int tab_stop);
		public void set_text (string text);
		public void set_text_set (bool text_set);
		public Ide.SourceSnippetContext context { get; set; }
		public string spec { get; set; }
		public int tab_stop { get; set; }
		public string text { get; set; }
		public bool text_set { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippet_context_get_type ()")]
	public class SourceSnippetContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippetContext ();
		public void add_variable (string key, string value);
		public void clear_variables ();
		public void dump ();
		public void emit_changed ();
		public string expand (string input);
		public unowned string get_variable (string key);
		public void set_line_prefix (string line_prefix);
		public void set_tab_width (int tab_size);
		public void set_use_spaces (bool use_spaces);
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippets_get_type ()")]
	public class SourceSnippets : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippets ();
		public void add (Ide.SourceSnippet snippet);
		public void clear ();
		public uint count ();
		public void @foreach (string prefix, GLib.Func foreach_func);
		public void merge (Ide.SourceSnippets other);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippets_manager_get_type ()")]
	public class SourceSnippetsManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceSnippetsManager ();
		public unowned Ide.SourceSnippets? get_for_language (Gtk.SourceLanguage language);
		public unowned Ide.SourceSnippets? get_for_language_id (string language_id);
		public async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_view_get_type ()")]
	public class SourceView : Gtk.SourceView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceView ();
		public unowned Ide.BackForwardList? get_back_forward_list ();
		public uint get_count ();
		public unowned Ide.SourceSnippet? get_current_snippet ();
		public bool get_enable_word_completion ();
		public unowned Ide.FileSettings? get_file_settings ();
		public unowned Pango.FontDescription get_font_desc ();
		public bool get_highlight_current_line ();
		public bool get_insert_matching_brace ();
		public unowned string get_mode_display_name ();
		public unowned string get_mode_name ();
		public bool get_overwrite ();
		public bool get_overwrite_braces ();
		public bool get_rubberband_search ();
		public uint get_scroll_offset ();
		public unowned Gtk.SourceSearchContext? get_search_context ();
		public Gtk.DirectionType get_search_direction ();
		public bool get_show_grid_lines ();
		public bool get_show_line_changes ();
		public bool get_show_line_diagnostics ();
		public bool get_show_search_bubbles ();
		public bool get_show_search_shadow ();
		public bool get_snippet_completion ();
		public Gdk.Rectangle get_visible_rect ();
		public void get_visual_position (uint line, uint line_offset);
		public bool move_mark_onscreen (Gtk.TextMark mark);
		public bool place_cursor_onscreen ();
		public void rollback_search ();
		public void scroll_mark_onscreen (Gtk.TextMark mark, bool use_align, double alignx, double aligny);
		public void scroll_to_iter (Gtk.TextIter iter, double within_margin, bool use_align, double xalign, double yalign, bool animate_scroll);
		public void scroll_to_mark (Gtk.TextMark mark, double within_margin, bool use_align, double xalign, double yalign, bool animate_scroll);
		public void set_back_forward_list (Ide.BackForwardList back_forward_list);
		public void set_count (uint count);
		public void set_enable_word_completion (bool enable_word_copletion);
		public void set_font_desc (Pango.FontDescription font_desc);
		public void set_font_name (string font_name);
		public void set_highlight_current_line (bool highlight_current_line);
		public void set_insert_matching_brace (bool insert_matching_brace);
		public void set_overwrite_braces (bool overwrite_braces);
		public void set_rubberband_search (bool rubberband_search);
		public void set_scroll_offset (uint scroll_offset);
		public void set_search_direction (Gtk.DirectionType direction);
		public void set_show_grid_lines (bool show_grid_lines);
		public void set_show_line_changes (bool show_line_changes);
		public void set_show_line_diagnostics (bool show_line_changes);
		public void set_show_search_bubbles (bool show_search_bubbles);
		public void set_show_search_shadow (bool show_search_bubbles);
		public void set_snippet_completion (bool snippet_completion);
		public Ide.BackForwardList back_forward_list { get; set; }
		public uint count { get; set; }
		public bool enable_word_completion { get; set; }
		public Ide.FileSettings file_settings { get; }
		public Pango.FontDescription font_desc { get; set; }
		public string font_name { set construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { set; }
		[NoAccessorMethod]
		public Ide.Indenter indenter { owned get; }
		public bool insert_matching_brace { get; set; }
		public string mode_display_name { get; }
		public bool overwrite_braces { get; set; }
		public bool rubberband_search { get; set; }
		public uint scroll_offset { get; set; }
		public Gtk.SourceSearchContext search_context { get; }
		public Gtk.DirectionType search_direction { get; set; }
		public bool show_grid_lines { get; set; }
		public bool show_line_changes { get; set; }
		public bool show_line_diagnostics { get; set; }
		public bool show_search_bubbles { get; set; }
		public bool show_search_shadow { get; set; }
		public bool snippet_completion { get; set; }
		public virtual signal void action (string prefix, string action_name, string param);
		public virtual signal void append_to_count (int digit);
		public virtual signal void auto_indent ();
		public virtual signal void begin_macro ();
		public signal void begin_user_action ();
		public virtual signal void capture_modifier ();
		public virtual signal void clear_count ();
		public virtual signal void clear_modifier ();
		[HasEmitter]
		public virtual signal void clear_search ();
		public virtual signal void clear_selection ();
		[HasEmitter]
		public virtual signal void clear_snippets ();
		public virtual signal void cycle_completion (Gtk.DirectionType direction);
		public virtual signal void decrease_font_size ();
		public virtual signal void delete_selection ();
		public virtual signal void end_macro ();
		public signal void end_user_action ();
		public virtual signal void focus_location (Ide.SourceLocation location);
		public virtual signal void goto_definition ();
		public virtual signal void hide_completion ();
		public virtual signal void increase_font_size ();
		public virtual signal void indent_selection (int level);
		public virtual signal void insert_at_cursor_and_indent (string str);
		public virtual signal void insert_modifier (bool use_count);
		[HasEmitter]
		public virtual signal void jump (Gtk.TextIter location);
		public virtual signal void move_error (Gtk.DirectionType dir);
		public virtual signal void move_search (Gtk.DirectionType dir, bool extend_selection, bool select_match, bool exclusive, bool apply_count, bool at_word_boundaries);
		public virtual signal void movement (Ide.SourceViewMovement movement, bool extend_selection, bool exclusive, bool apply_count);
		public virtual signal void paste_clipboard_extended (bool smart_lines, bool after_cursor, bool place_cursor_at_original);
		public virtual signal void pop_selection ();
		[HasEmitter]
		public signal void pop_snippet ();
		public virtual signal void push_selection ();
		[HasEmitter]
		public signal void push_snippet (Ide.SourceSnippet snippet, Gtk.TextIter? location);
		public virtual signal void rebuild_highlight ();
		public signal void reindent ();
		public virtual signal void replay_macro (bool use_count);
		public virtual signal void request_documentation ();
		public virtual signal void reset_font_size ();
		public virtual signal void restore_insert_mark ();
		public virtual signal void save_command ();
		public virtual signal void save_insert_mark ();
		public virtual signal void save_search_char ();
		public virtual signal void selection_theatric (Ide.SourceViewTheatric theatric);
		public virtual signal void set_mode (string mode, Ide.SourceViewModeType type);
		public virtual signal void set_overwrite (bool overwrite);
		public virtual signal void set_search_text (string search_text, bool from_selection);
		public virtual signal void sort (bool ignore_case, bool reverse);
		public virtual signal void swap_selection_bounds ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_view_mode_get_type ()")]
	public class SourceViewMode : Gtk.Widget, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected SourceViewMode ();
		public bool get_block_cursor ();
		public unowned string get_default_mode ();
		public unowned string get_display_name ();
		public bool get_keep_mark_on_char ();
		public Ide.SourceViewModeType get_mode_type ();
		public bool get_repeat_insert_with_count ();
		public bool get_suppress_unbound ();
		public void set_has_indenter (bool has_indenter);
		public string name { get; }
		public signal void action (string object, string p0, string p1);
		public signal void append_to_count (int object);
		public signal void auto_indent ();
		public signal void backspace ();
		public signal void begin_macro ();
		public signal void begin_user_action ();
		public signal void capture_modifier ();
		public signal void change_case (Gtk.SourceChangeCaseType object);
		public signal void change_number (int object);
		public signal void clear_count ();
		public signal void clear_modifier ();
		public signal void clear_search ();
		public signal void clear_selection ();
		public signal void clear_snippets ();
		public signal void copy_clipboard ();
		public signal void cut_clipboard ();
		public signal void cycle_completion (Gtk.DirectionType object);
		public signal void decrease_font_size ();
		public signal void delete_from_cursor (Gtk.DeleteType object, int p0);
		public signal void delete_selection ();
		public signal void end_macro ();
		public signal void end_user_action ();
		public signal void goto_definition ();
		public signal void hide_completion ();
		public signal void increase_font_size ();
		public signal void indent_selection (int object);
		public signal void insert_at_cursor (string object);
		public signal void insert_at_cursor_and_indent (string object);
		public signal void insert_modifier (bool object);
		public signal void join_lines ();
		public signal void move_cursor (Gtk.MovementStep object, int p0, bool p1);
		public signal void move_error (Gtk.DirectionType object);
		public signal void move_lines (bool object, int p0);
		public signal void move_search (Gtk.DirectionType object, bool p0, bool p1, bool p2, bool p3, bool p4);
		public signal void move_to_matching_bracket (bool object);
		public signal void move_viewport (Gtk.ScrollStep object, int p0);
		public signal void move_words (int object);
		public signal void movement (Ide.SourceViewMovement object, bool p0, bool p1, bool p2);
		public signal void paste_clipboard ();
		public signal void paste_clipboard_extended (bool object, bool p0, bool p1);
		public signal void pop_selection ();
		public signal void preedit_changed (string object);
		public signal void push_selection ();
		public signal void rebuild_highlight ();
		public signal void redo ();
		public signal void reindent ();
		public signal void replay_macro (bool object);
		public signal void request_documentation ();
		public signal void reset_font_size ();
		public signal void restore_insert_mark ();
		public signal void save_command ();
		public signal void save_insert_mark ();
		public signal void save_search_char ();
		public signal void select_all (bool object);
		public signal void selection_theatric (Ide.SourceViewTheatric object);
		public signal void set_anchor ();
		public signal void set_mode (string object, Ide.SourceViewModeType p0);
		public signal void set_overwrite (bool object);
		public signal void set_search_text (string object, bool p0);
		public signal void show_completion ();
		public signal void sort (bool object, bool p0);
		public signal void swap_selection_bounds ();
		public signal void toggle_cursor_visible ();
		public signal void toggle_overwrite ();
		public signal void undo ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_symbol_ref", type_id = "ide_symbol_get_type ()", unref_function = "ide_symbol_unref")]
	[Compact]
	public class Symbol {
		[CCode (has_construct_function = false)]
		public Symbol (string name, Ide.SymbolKind kind, Ide.SymbolFlags flags, Ide.SourceLocation? declaration_location, Ide.SourceLocation? definition_location, Ide.SourceLocation? canonical_location);
		public unowned Ide.SourceLocation? get_canonical_location ();
		public unowned Ide.SourceLocation? get_declaration_location ();
		public unowned Ide.SourceLocation? get_definition_location ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public unowned string get_name ();
		public Ide.Symbol @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_symbol_node_get_type ()")]
	public class SymbolNode : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SymbolNode ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public virtual Ide.SourceLocation? get_location ();
		public unowned string get_name ();
		[NoAccessorMethod]
		public Ide.SymbolFlags flags { get; set; }
		[NoAccessorMethod]
		public Ide.SymbolKind kind { get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h")]
	[Compact]
	public class ThreadPool {
		public static void push (Ide.ThreadPoolKind kind, [CCode (scope = "async")] owned Ide.ThreadFunc func);
		public static void push_task (Ide.ThreadPoolKind kind, GLib.Task task, [CCode (scope = "async")] owned GLib.TaskThreadFunc func);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_unsaved_file_ref", type_id = "ide_unsaved_file_get_type ()", unref_function = "ide_unsaved_file_unref")]
	[Compact]
	public class UnsavedFile {
		public unowned GLib.Bytes get_content ();
		public unowned GLib.File get_file ();
		public int64 get_sequence ();
		public unowned string get_temp_path ();
		public bool persist (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public Ide.UnsavedFile @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_unsaved_files_get_type ()")]
	public class UnsavedFiles : Ide.Object {
		[CCode (has_construct_function = false)]
		protected UnsavedFiles ();
		public void clear ();
		public bool contains (GLib.File file);
		public int64 get_sequence ();
		public Ide.UnsavedFile? get_unsaved_file (GLib.File file);
		public void remove (GLib.File file);
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<weak Ide.UnsavedFile> to_array ();
		public void update (GLib.File file, GLib.Bytes content);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_vcs_get_type ()")]
	public abstract class Vcs : Ide.Object {
		[CCode (cname = "ide_vcs_new_async", has_construct_function = false)]
		public async Vcs (Ide.Context context, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual Ide.BufferChangeMonitor? get_buffer_change_monitor (Ide.Buffer buffer);
		public virtual unowned GLib.File get_working_directory ();
		public virtual bool is_ignored (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_vcs_uri_ref", type_id = "ide_vcs_uri_get_type ()", unref_function = "ide_vcs_uri_unref")]
	[Compact]
	public class VcsUri {
		[CCode (has_construct_function = false)]
		public VcsUri (string uri);
		public unowned string get_host ();
		public unowned string get_path ();
		public uint get_port ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public static bool is_valid (string uri_string);
		public Ide.VcsUri @ref ();
		public void set_host (string host);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public string to_string ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildSystemInterface", type_id = "ide_build_system_get_type ()")]
	public interface BuildSystem : Ide.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract async string[] get_build_flags_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract Ide.Builder get_builder (GLib.KeyFile config, Ide.Device device) throws GLib.Error;
		public abstract int get_priority ();
		public static async Ide.BuildSystem new_async (Ide.Context context, GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public abstract Ide.Context context { owned get; construct; }
		[NoAccessorMethod]
		public abstract GLib.File project_file { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCompletionProviderInterface", type_id = "ide_completion_provider_get_type ()")]
	public interface CompletionProvider : Gtk.SourceCompletionProvider, GLib.Object {
		public static string context_current_word (Gtk.SourceCompletionContext context);
		public static bool context_in_comment (Gtk.SourceCompletionContext context);
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDebuggerInterface", type_id = "ide_debugger_get_type ()")]
	public interface Debugger : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDeviceProviderInterface", type_id = "ide_device_provider_get_type ()")]
	public interface DeviceProvider : Ide.Object {
		public void emit_device_added (Ide.Device device);
		public void emit_device_removed (Ide.Device device);
		public abstract GLib.GenericArray<weak Ide.Device> get_devices ();
		public abstract bool get_settled ();
		public abstract Ide.Context context { construct; }
		public abstract bool settled { get; }
		public signal void device_added (Ide.Device object);
		public signal void device_removed (Ide.Device object);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDiagnosticProviderInterface", type_id = "ide_diagnostic_provider_get_type ()")]
	public interface DiagnosticProvider : Ide.Object {
		public abstract async Ide.Diagnostics? diagnose_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeExecutableInterface", type_id = "ide_executable_get_type ()")]
	public interface Executable : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeExecuterInterface", type_id = "ide_executer_get_type ()")]
	public interface Executer : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeHighlighterInterface", type_id = "ide_highlighter_get_type ()")]
	public interface Highlighter : Ide.Object {
		[NoWrapper]
		public abstract void set_engine (Ide.HighlightEngine engine);
		public abstract Gtk.TextIter update (Ide.HighlightCallback callback, Gtk.TextIter range_begin, Gtk.TextIter range_end);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeIndenterInterface", type_id = "ide_indenter_get_type ()")]
	public interface Indenter : GLib.Object {
		public abstract string? format (Gtk.TextView text_view, Gtk.TextIter begin, Gtk.TextIter end, out int cursor_offset, Gdk.EventKey event);
		public abstract bool is_trigger (Gdk.EventKey event);
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeProcessInterface", type_id = "ide_process_get_type ()")]
	public interface Process : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeProjectMinerInterface", type_id = "ide_project_miner_get_type ()")]
	public interface ProjectMiner : GLib.Object {
		public void emit_discovered (Ide.ProjectInfo project_info);
		public abstract async bool mine_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual signal void discovered (Ide.ProjectInfo project_info);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSearchProviderInterface", type_id = "ide_search_provider_get_type ()")]
	public interface SearchProvider : Ide.Object {
		public abstract void activate (Gtk.Widget row, Ide.SearchResult result);
		public abstract Gtk.Widget create_row (Ide.SearchResult result);
		public abstract unichar get_prefix ();
		public abstract int get_priority ();
		public abstract unowned string get_verb ();
		public abstract void populate (Ide.SearchContext context, string search_terms, size_t max_results, GLib.Cancellable? cancellable = null);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeServiceInterface", type_id = "ide_service_get_type ()")]
	public interface Service : GLib.Object {
		public abstract unowned string get_name ();
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract void start ();
		public abstract void stop ();
		public abstract Ide.Context context { construct; }
		public virtual signal void context_loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSymbolResolverInterface", type_id = "ide_symbol_resolver_get_type ()")]
	public interface SymbolResolver : Ide.Object {
		public abstract async Ide.SymbolTree? get_symbol_tree_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Ide.Symbol? lookup_symbol_async (Ide.SourceLocation location, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSymbolTreeInterface", type_id = "ide_symbol_tree_get_type ()")]
	public interface SymbolTree : GLib.Object {
		public abstract uint get_n_children (Ide.SymbolNode? node);
		public abstract Ide.SymbolNode? get_nth_child (Ide.SymbolNode? node, uint nth);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTagsBuilderInterface", type_id = "ide_tags_builder_get_type ()")]
	public interface TagsBuilder : GLib.Object {
		public abstract async bool build_async (GLib.File directory_or_flie, bool asynchronous, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTargetInterface", type_id = "ide_target_get_type ()")]
	public interface Target : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTestCaseInterface", type_id = "ide_test_case_get_type ()")]
	public interface TestCase : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTestSuiteInterface", type_id = "ide_test_suite_get_type ()")]
	public interface TestSuite : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct BackForwardItem_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct BackForwardList_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct BufferChangeMonitor_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct BufferManager_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Buffer_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct BuildResult_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct BuildSystem_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Builder_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct CompletionItem_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct CompletionResults_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Context_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Deployer_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct DeviceManager_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct DeviceProvider_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Device_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct DiagnosticProvider_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Diagnostic_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Diagnostician_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Diagnostics_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct DirectoryVcs_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct DoapPerson_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Doap_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ExtensionAdapter_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ExtensionSetAdapter_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct FileSettings_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct File_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct GitRemoteCallbacks_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct GitVcs_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct HighlightEngine_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct HighlightIndex_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Highlighter_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Indenter_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct LocalDevice_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Object_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct PatternSpec_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Progress_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ProjectFile_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ProjectFiles_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ProjectInfo_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ProjectItem_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ProjectMiner_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Project_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct RecentProjects_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Refactory_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct ScriptManager_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Script_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SearchContext_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SearchEngine_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SearchProvider_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SearchResult_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Service_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Settings_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceLocation_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceMap_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceRange_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceSnippetChunk_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceSnippetContext_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceSnippet_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceSnippetsManager_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceSnippets_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceViewMode_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SourceView_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SymbolNode_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SymbolResolver_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct SymbolTree_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Symbol_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct TagsBuilder_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct UnsavedFile_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct UnsavedFiles_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct VcsUri_autoptr {
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct Vcs_autoptr {
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUFFER_LINE_CHANGE_", has_type_id = false)]
	public enum BufferLineChange {
		NONE,
		ADDED,
		CHANGED,
		DELETED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUFFER_LINE_FLAGS_", type_id = "ide_buffer_line_flags_get_type ()")]
	[Flags]
	public enum BufferLineFlags {
		NONE,
		ADDED,
		CHANGED,
		ERROR,
		WARNING,
		NOTE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUILDER_BUILD_FLAGS_", has_type_id = false)]
	[Flags]
	public enum BuilderBuildFlags {
		NONE,
		FORCE_REBUILD
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DIAGNOSTIC_", type_id = "ide_diagnostic_severity_get_type ()")]
	public enum DiagnosticSeverity {
		IGNORED,
		NOTE,
		DEPRECATED,
		WARNING,
		ERROR,
		FATAL;
		public static unowned string to_string (Ide.DiagnosticSeverity severity);
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_HIGHLIGHT_", type_id = "ide_highlight_result_get_type ()")]
	public enum HighlightResult {
		STOP,
		CONTINUE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_INDENT_STYLE_", type_id = "ide_indent_style_get_type ()")]
	public enum IndentStyle {
		SPACES,
		TABS
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_MODE_TYPE_", type_id = "ide_source_view_mode_type_get_type ()")]
	public enum SourceViewModeType {
		TRANSIENT,
		PERMANENT,
		MODAL
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_MOVEMENT_", type_id = "ide_source_view_movement_get_type ()")]
	public enum SourceViewMovement {
		PREVIOUS_OFFSET,
		NEXT_OFFSET,
		NTH_CHAR,
		PREVIOUS_CHAR,
		NEXT_CHAR,
		FIRST_CHAR,
		FIRST_NONSPACE_CHAR,
		MIDDLE_CHAR,
		LAST_CHAR,
		NEXT_WORD_START,
		NEXT_FULL_WORD_START,
		NEXT_SUB_WORD_START,
		PREVIOUS_SUB_WORD_START,
		PREVIOUS_WORD_START,
		PREVIOUS_FULL_WORD_START,
		PREVIOUS_WORD_END,
		PREVIOUS_FULL_WORD_END,
		NEXT_WORD_END,
		NEXT_FULL_WORD_END,
		SENTENCE_START,
		SENTENCE_END,
		PARAGRAPH_START,
		PARAGRAPH_END,
		PREVIOUS_LINE,
		NEXT_LINE,
		FIRST_LINE,
		NTH_LINE,
		LAST_LINE,
		LINE_PERCENTAGE,
		LINE_CHARS,
		LINE_END,
		HALF_PAGE_UP,
		HALF_PAGE_DOWN,
		PAGE_UP,
		PAGE_DOWN,
		SCREEN_UP,
		SCREEN_DOWN,
		SCREEN_TOP,
		SCREEN_MIDDLE,
		SCREEN_BOTTOM,
		MATCH_SPECIAL,
		SCROLL_SCREEN_TOP,
		SCROLL_SCREEN_CENTER,
		SCROLL_SCREEN_BOTTOM,
		PREVIOUS_UNMATCHED_BRACE,
		NEXT_UNMATCHED_BRACE,
		PREVIOUS_UNMATCHED_PAREN,
		NEXT_UNMATCHED_PAREN,
		NEXT_MATCH_MODIFIER,
		PREVIOUS_MATCH_MODIFIER,
		NEXT_MATCH_SEARCH_CHAR,
		PREVIOUS_MATCH_SEARCH_CHAR
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_THEATRIC_", type_id = "ide_source_view_theatric_get_type ()")]
	public enum SourceViewTheatric {
		EXPAND,
		SHRINK
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SYMBOL_FLAGS_", type_id = "ide_symbol_flags_get_type ()")]
	[Flags]
	public enum SymbolFlags {
		NONE,
		IS_STATIC,
		IS_MEMBER,
		IS_DEPRECATED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SYMBOL_", type_id = "ide_symbol_kind_get_type ()")]
	public enum SymbolKind {
		NONE,
		SCALAR,
		CLASS,
		FUNCTION,
		METHOD,
		STRUCT,
		UNION,
		FIELD,
		ENUM,
		ENUM_VALUE,
		VARIABLE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_THREAD_POOL_", type_id = "ide_thread_pool_kind_get_type ()")]
	public enum ThreadPoolKind {
		COMPILER,
		INDEXER,
		LAST
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DOAP_ERROR_INVALID_")]
	public errordomain DoapError {
		FORMAT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", instance_pos = 3.9)]
	public delegate void ExtensionSetAdapterForeachFunc (Ide.ExtensionSetAdapter @set, Peas.PluginInfo plugin_info, Peas.Extension extension);
	[CCode (cheader_filename = "ide.h", has_target = false)]
	public delegate Ide.HighlightResult HighlightCallback (Gtk.TextIter begin, Gtk.TextIter end, string style_name);
	[CCode (cheader_filename = "ide.h", instance_pos = 0.9)]
	public delegate void ThreadFunc ();
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUFFER_LINE_FLAGS_DIAGNOSTICS_MASK")]
	public const int BUFFER_LINE_FLAGS_DIAGNOSTICS_MASK;
	[CCode (cheader_filename = "ide.h", cname = "IDE_FILE_SETTINGS_EXTENSION_POINT")]
	public const string FILE_SETTINGS_EXTENSION_POINT;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_BOOKMARK_FILENAME")]
	public const string RECENT_PROJECTS_BOOKMARK_FILENAME;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_GROUP")]
	public const string RECENT_PROJECTS_GROUP;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX;
	[CCode (cheader_filename = "ide.h", cname = "IDE_SCRIPT_EXTENSION_POINT")]
	public const string SCRIPT_EXTENSION_POINT;
	[CCode (cheader_filename = "ide.h", cname = "IDE_VCS_EXTENSION_POINT")]
	public const string VCS_EXTENSION_POINT;
	[CCode (cheader_filename = "ide.h")]
	public static async Ide.BuildSystem build_system_new_async (Ide.Context context, GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static string completion_provider_context_current_word (Gtk.SourceCompletionContext context);
	[CCode (cheader_filename = "ide.h")]
	public static bool completion_provider_context_in_comment (Gtk.SourceCompletionContext context);
	[CCode (cheader_filename = "ide.h")]
	public static unowned string get_program_name ();
	[CCode (cheader_filename = "ide.h")]
	public static void log_increase_verbosity ();
	[CCode (cheader_filename = "ide.h")]
	public static void log_init (bool stdout_, string filename);
	[CCode (cheader_filename = "ide.h")]
	public static void log_shutdown ();
	[CCode (cheader_filename = "ide.h")]
	public static void set_program_name (string program_name);
}
