/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPCreator;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.StreamUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.replacements.BASE64Decoder;

public final class PluginBridge
extends JNLPFile {
    private final PluginParameters params;
    private final Set<String> jars = new HashSet<String>();
    private List<ExtensionDesc> extensionJars = new ArrayList<ExtensionDesc>();
    private final List<String> codeBaseFolders = new ArrayList<String>();
    private String[] cacheJars = new String[0];
    private String[] cacheExJars = new String[0];
    private boolean usePack = false;
    private boolean useVersion = false;
    private boolean useJNLPHref;
    private String debugJnlp;
    static final String SANDBOX_REGEX = PluginBridge.toBaseRegex("sandbox", false);
    static final String CLOSE_INFORMATION_REGEX = PluginBridge.toBaseRegex("information", true);
    static final String SECURITY_REGEX = PluginBridge.toBaseRegex("security", false);
    static final String RESOURCE_REGEX = PluginBridge.toBaseRegex("resources", false);
    static final String TITLE_REGEX = PluginBridge.toBaseRegex("title", false);
    static final String VENDOR_REGEX = PluginBridge.toBaseRegex("vendor", false);
    static final String AP_REGEX = PluginBridge.toBaseRegex("all-permissions", false);
    static final String CODEBASE_REGEX1 = "(?i).*\\s+codebase\\s*=\\s*";
    static final String CODEBASE_REGEX2 = "(?i)\\s+codebase\\s*=\\s*.\\.{0,1}.((\\s+)|(\\s*>))";

    public PluginBridge(URL codebase, URL documentBase, String jar, String main, int width, int height, PluginParameters params) throws Exception {
        this(codebase, documentBase, jar, main, width, height, params, new JNLPCreator());
    }

    private void addArchiveEntries(String[] archives) {
        for (String archiveEntry : archives) {
            if ((archiveEntry = archiveEntry.trim()).endsWith("/") || archiveEntry.endsWith(File.pathSeparator)) {
                this.codeBaseFolders.add(archiveEntry);
                continue;
            }
            this.jars.add(archiveEntry);
        }
    }

    public PluginBridge(URL codebase, URL documentBase, String archive, String main, int width, int height, final PluginParameters params, JNLPCreator jnlpCreator) throws Exception {
        String cacheArchiveEx;
        String cacheArchive;
        this.specVersion = new Version("1.0");
        this.fileVersion = new Version("1.1");
        this.codeBase = codebase;
        this.sourceLocation = documentBase;
        this.params = params;
        this.parserSettings = ParserSettings.getGlobalParserSettings();
        if (params.getJNLPHref() != null) {
            this.useJNLPHref = true;
            try {
                JARDesc[] jarDescs;
                JNLPFile jnlpFile;
                ParserSettings defaultSettings = new ParserSettings();
                final URL jnlp = new URL(this.codeBase, params.getJNLPHref());
                if (this.fileLocation == null) {
                    this.fileLocation = jnlp;
                }
                if (params.getJNLPEmbedded() != null) {
                    ByteArrayInputStream jnlpInputStream = new ByteArrayInputStream(PluginBridge.decodeBase64String(params.getJNLPEmbedded()));
                    jnlpFile = new JNLPFile(jnlpInputStream, this.codeBase, defaultSettings);
                    this.debugJnlp = new StreamProvider(){

                        @Override
                        InputStream getStream() throws Exception {
                            return new ByteArrayInputStream(PluginBridge.decodeBase64String(params.getJNLPEmbedded()));
                        }
                    }.readStream();
                } else {
                    jnlpFile = jnlpCreator.create(jnlp, null, defaultSettings, JNLPRuntime.getDefaultUpdatePolicy(), this.codeBase);
                    this.debugJnlp = new StreamProvider(){

                        @Override
                        InputStream getStream() throws Exception {
                            return JNLPFile.openURL(jnlp, null, UpdatePolicy.ALWAYS);
                        }
                    }.readStream();
                }
                OutputController.getLogger().log("Loaded JNLPhref:");
                OutputController.getLogger().log(this.debugJnlp == null ? "null" : this.debugJnlp);
                if (jnlpFile.isApplet()) {
                    main = jnlpFile.getApplet().getMainClass();
                }
                Map<String, String> jnlpParams = jnlpFile.getApplet().getParameters();
                this.info = jnlpFile.info;
                for (Map.Entry<String, String> entry : jnlpParams.entrySet()) {
                    this.params.put(entry.getKey().toLowerCase(), entry.getValue());
                }
                for (JARDesc jarDesc : jarDescs = jnlpFile.getResources().getJARs()) {
                    String fileName = jarDesc.getLocation().toExternalForm();
                    this.jars.add(fileName);
                }
                this.usePack = jnlpFile.getDownloadOptions().useExplicitPack();
                this.useVersion = jnlpFile.getDownloadOptions().useExplicitVersion();
                this.extensionJars = Arrays.asList(jnlpFile.getResources().getExtensions());
            }
            catch (MalformedURLException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to get JNLP file at: " + params.getJNLPHref() + " with context of URL as: " + this.codeBase.toExternalForm());
            }
        } else {
            this.info = new ArrayList();
            this.useJNLPHref = false;
        }
        if (!(cacheArchive = params.getCacheArchive()).isEmpty()) {
            String[] versions = new String[]{};
            String cacheVersion = params.getCacheVersion();
            if (!cacheVersion.isEmpty()) {
                versions = cacheVersion.split(",");
            }
            String[] ljars = cacheArchive.split(",");
            this.cacheJars = new String[ljars.length];
            for (int i = 0; i < ljars.length; ++i) {
                this.cacheJars[i] = ljars[i].trim();
                if (versions.length <= 0) continue;
                int n = i;
                this.cacheJars[n] = this.cacheJars[n] + ";" + versions[i].trim();
            }
        }
        if (!(cacheArchiveEx = params.getCacheArchiveEx()).isEmpty()) {
            this.cacheExJars = cacheArchiveEx.split(",");
        }
        if (archive != null && archive.length() > 0) {
            String[] archives = archive.split(",");
            this.addArchiveEntries(archives);
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Jar string: " + archive);
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "jars length: " + archives.length);
        }
        if (main.endsWith(".class")) {
            main = main.substring(0, main.length() - 6);
        }
        String mainClass = main.replace('/', '.');
        this.launchType = new AppletDesc(this.getTitle(), mainClass, documentBase, width, height, params.getUnmodifiableMap());
        this.security = main.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost()) : null;
        this.uniqueKey = params.getUniqueKey(codebase);
        String jargs = params.getJavaArguments();
        if (!jargs.isEmpty()) {
            block13: for (String s : jargs.split(" ")) {
                String[] parts = s.trim().split("=");
                if (parts.length != 2 || !Boolean.valueOf(parts[1]).booleanValue() || null == parts[0]) continue;
                switch (parts[0]) {
                    case "-Djnlp.packEnabled": {
                        this.usePack = true;
                        continue block13;
                    }
                    case "-Djnlp.versionEnabled": {
                        this.useVersion = true;
                    }
                }
            }
        }
    }

    public List<String> getArchiveJars() {
        return new ArrayList<String>(this.jars);
    }

    public boolean codeBaseLookup() {
        return this.params.useCodebaseLookup();
    }

    public boolean useJNLPHref() {
        return this.useJNLPHref;
    }

    public PluginParameters getParams() {
        return this.params;
    }

    @Override
    public SecurityDesc.RequestedPermissionLevel getRequestedPermissionLevel() {
        String level = this.params.getPermissions();
        if (level == null) {
            return SecurityDesc.RequestedPermissionLevel.NONE;
        }
        if (level.equals(SecurityDesc.RequestedPermissionLevel.DEFAULT.toHtmlString())) {
            return SecurityDesc.RequestedPermissionLevel.NONE;
        }
        if (level.equals(SecurityDesc.RequestedPermissionLevel.SANDBOX.toHtmlString())) {
            return SecurityDesc.RequestedPermissionLevel.SANDBOX;
        }
        if (level.equals(SecurityDesc.RequestedPermissionLevel.ALL.toHtmlString())) {
            return SecurityDesc.RequestedPermissionLevel.ALL;
        }
        return SecurityDesc.RequestedPermissionLevel.NONE;
    }

    @Override
    public DownloadOptions getDownloadOptions() {
        return new DownloadOptions(this.usePack, this.useVersion);
    }

    @Override
    public String getTitle() {
        String inManifestTitle = super.getTitleFromManifest();
        if (inManifestTitle != null) {
            return inManifestTitle;
        }
        String mainClass = this.getManifestsAttributes().getMainClass();
        if (mainClass != null) {
            return mainClass;
        }
        return this.params.getAppletTitle();
    }

    @Override
    public ResourcesDesc getResources(Locale locale, String os, String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public <T> List<T> getResources(Class<T> launchType) {
                if (launchType.equals(JARDesc.class)) {
                    try {
                        Version version;
                        String jar;
                        ArrayList<JARDesc> jarDescs = new ArrayList<JARDesc>();
                        jarDescs.addAll(PluginBridge.this.sharedResources.getResources(JARDesc.class));
                        for (String name : PluginBridge.this.jars) {
                            if (name.length() <= 0) continue;
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, name), null, null, false, true, false, true));
                        }
                        boolean cacheable = true;
                        if (PluginBridge.this.params.getCacheOption().equalsIgnoreCase("no")) {
                            cacheable = false;
                        }
                        for (String cacheJar : PluginBridge.this.cacheJars) {
                            String[] jarAndVer = cacheJar.split(";");
                            jar = jarAndVer[0];
                            version = null;
                            if (jar.length() == 0) continue;
                            if (jarAndVer.length > 1) {
                                version = new Version(jarAndVer[1]);
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, false, true, false, cacheable));
                        }
                        for (String cacheExJar : PluginBridge.this.cacheExJars) {
                            if (cacheExJar.length() == 0) continue;
                            String[] jarInfo = cacheExJar.split(";");
                            jar = jarInfo[0].trim();
                            version = null;
                            boolean lazy = true;
                            if (jarInfo.length > 1) {
                                if (jarInfo[1].equals("preload")) {
                                    lazy = false;
                                } else {
                                    version = new Version(jarInfo[1].trim());
                                }
                                if (jarInfo.length > 2) {
                                    lazy = false;
                                    version = new Version(jarInfo[2].trim());
                                }
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, lazy, true, false, false));
                        }
                        ArrayList<JARDesc> result = jarDescs;
                        return result;
                    }
                    catch (MalformedURLException jarDescs) {}
                } else if (launchType.equals(ExtensionDesc.class)) {
                    List castList = PluginBridge.this.extensionJars;
                    return castList;
                }
                return PluginBridge.this.sharedResources.getResources(launchType);
            }

            @Override
            public JARDesc[] getJARs() {
                List<JARDesc> jarDescs = this.getResources(JARDesc.class);
                return jarDescs.toArray(new JARDesc[jarDescs.size()]);
            }

            @Override
            public void addResource(Object resource) {
                PluginBridge.this.sharedResources.addResource(resource);
            }
        };
    }

    public List<String> getCodeBaseFolders() {
        return new ArrayList<String>(this.codeBaseFolders);
    }

    @Override
    public ResourcesDesc[] getResourcesDescs(Locale locale, String os, String arch) {
        return new ResourcesDesc[]{this.getResources(locale, os, arch)};
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isInstaller() {
        return false;
    }

    static byte[] decodeBase64String(String encodedString) throws IOException {
        BASE64Decoder base64 = new BASE64Decoder();
        return base64.decodeBuffer(encodedString);
    }

    public String getDebugJnlp() {
        return this.debugJnlp;
    }

    public boolean haveDebugJnlp() {
        return this.debugJnlp != null;
    }

    public String toJnlp(boolean needSecurity, boolean useHref, boolean fix) {
        if (this.useJNLPHref && this.debugJnlp != null && useHref) {
            OutputController.getLogger().log("Using debugjnlp as return value toJnlp");
            if (fix) {
                return this.fixCommonIsuses(needSecurity, this.debugJnlp);
            }
            return this.debugJnlp;
        }
        StringBuilder s = new StringBuilder();
        s.append("<?xml version='1.0' encoding='UTF-8'?>\n<jnlp codebase='").append(this.getCodeBase().toString()).append("'>\n").append("  <information>\n    <title>").append(this.createJnlpTitle()).append("</title>\n    <vendor>").append(this.createJnlpVendor()).append("</vendor>\n  </information>\n");
        if (needSecurity) {
            s.append(PluginBridge.getSecurityElement());
        }
        s.append("  <resources>\n");
        for (String i : this.getArchiveJars()) {
            s.append("    <jar href='").append(i).append("' />\n");
        }
        s.append("  </resources>\n  <applet-desc\n").append("    name='").append(this.getTitle()).append("'\n    main-class='").append(this.getStrippedMain()).append("'\n    width='").append(this.getApplet().getWidth()).append("'\n    height='").append(this.getApplet().getHeight()).append("'>\n");
        if (!this.getApplet().getParameters().isEmpty()) {
            Set<Map.Entry<String, String>> prms = this.getApplet().getParameters().entrySet();
            for (Map.Entry<String, String> entry : prms) {
                s.append("    <param name='").append(entry.getKey()).append("' value='").append(entry.getValue()).append("'/>\n");
            }
        }
        s.append("  </applet-desc>\n</jnlp>\n");
        OutputController.getLogger().log("toJnlp generated:");
        OutputController.getLogger().log(s.toString());
        return s.toString();
    }

    private String getStrippedMain() {
        return PluginBridge.strippClass(this.getApplet().getMainClass().trim());
    }

    public static String strippClass(String s) {
        if (s.endsWith(".class")) {
            return s.substring(0, s.length() - ".class".length());
        }
        return s;
    }

    static String toMatcher(String regex) {
        return "(?s).*" + regex + ".*";
    }

    static String toBaseRegex(String tagName, boolean closing) {
        return "(?i)<\\s*" + (closing ? "/\\s*" : "") + tagName + "\\s*>";
    }

    private String fixCommonIsuses(boolean needSecurity, String orig) {
        String codebase = this.getCodeBase().toString();
        return PluginBridge.fixCommonIsuses(needSecurity, orig, codebase, this.createJnlpTitle(), this.createJnlpVendor());
    }

    static String fixCommonIsuses(boolean needSecurity, String orig, String codebase, String title, String vendor) {
        if (!orig.matches(PluginBridge.toMatcher(CLOSE_INFORMATION_REGEX))) {
            OutputController.getLogger().log("no information element Found. Trying to fix");
            if (orig.matches(PluginBridge.toMatcher(SECURITY_REGEX))) {
                orig = orig.replaceAll(SECURITY_REGEX, "\n<information>\n</information>\n<security>\n");
            } else if (orig.matches(PluginBridge.toMatcher(RESOURCE_REGEX))) {
                orig = orig.replaceAll(RESOURCE_REGEX, "\n<information>\n</information>\n<resources>\n");
            }
        }
        if (!orig.matches(PluginBridge.toMatcher(CODEBASE_REGEX1))) {
            OutputController.getLogger().log("jnlphref did not had codebase. Fixing");
            orig = orig.replaceAll("(?i)<\\s*jnlp\\s+", "<jnlp codebase='" + codebase + "' ");
        } else if (orig.matches(PluginBridge.toMatcher(CODEBASE_REGEX2))) {
            OutputController.getLogger().log("'.' codebase found. fixing");
            orig = orig.replaceAll(CODEBASE_REGEX2, " codebase='" + codebase + "'");
        }
        if (!orig.matches(PluginBridge.toMatcher(TITLE_REGEX))) {
            OutputController.getLogger().log("Missing title. Fixing");
            orig = orig.replaceAll(CLOSE_INFORMATION_REGEX, "\n<title>" + title + "</title>\n</information>\n");
        }
        if (!orig.matches(PluginBridge.toMatcher(VENDOR_REGEX))) {
            OutputController.getLogger().log("Missing vendor. Fixing");
            orig = orig.replaceAll(CLOSE_INFORMATION_REGEX, "\n<vendor>" + vendor + "</vendor>\n</information>\n");
        }
        if (needSecurity && !orig.matches(PluginBridge.toMatcher(AP_REGEX))) {
            OutputController.getLogger().log("all-permissions not found and app is signed.");
            if (orig.matches(SANDBOX_REGEX)) {
                OutputController.getLogger().log("Replacing sandbox by all-permissions");
                orig = orig.replaceAll(SANDBOX_REGEX, PluginBridge.getAllPermissionsElement());
            } else {
                OutputController.getLogger().log("adding security element");
                orig = orig.replaceAll(CLOSE_INFORMATION_REGEX, "</information>\n" + PluginBridge.getSecurityElement());
            }
        }
        return orig;
    }

    private static String getSecurityElement() {
        return "  <security>\n" + PluginBridge.getAllPermissionsElement() + "  </security>\n";
    }

    private static String getAllPermissionsElement() {
        return "    <all-permissions/>\n";
    }

    private abstract class StreamProvider {
        private StreamProvider() {
        }

        abstract InputStream getStream() throws Exception;

        String readStream() {
            try {
                return StreamUtils.readStreamAsString(this.getStream());
            }
            catch (Exception ex) {
                OutputController.getLogger().log(ex);
                return null;
            }
        }
    }
}

