/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class Version {
    private static final String seperators = ".-_";
    private static final String emptyString = new String("<EMPTY>");
    private final String versionString;

    public Version(String versions) {
        this.versionString = versions;
    }

    public boolean isVersionId() {
        return -1 == this.versionString.indexOf(" ");
    }

    public boolean matches(String version) {
        return this.matches(new Version(version));
    }

    public boolean matches(Version version) {
        List<String> versionStrings = version.getVersionStrings();
        for (String versionString1 : versionStrings) {
            if (this.matchesSingle(versionString1)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAny(String version) {
        return this.matches(new Version(version));
    }

    public boolean matchesAny(Version version) {
        List<String> versionStrings = version.getVersionStrings();
        for (String versionString1 : versionStrings) {
            if (!this.matchesSingle(versionString1)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesSingle(String version) {
        List<String> versionStrings = this.getVersionStrings();
        for (String versionString1 : versionStrings) {
            if (!this.matches(version, versionString1)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String subversion, String version) {
        List<String> subparts = this.getParts(subversion);
        List<String> parts = this.getParts(version);
        int maxLength = Math.max(subversion.length(), version.length());
        if (version.endsWith("*")) {
            maxLength = parts.size();
        }
        ArrayList<List<String>> versions = new ArrayList<List<String>>();
        versions.add(subparts);
        versions.add(parts);
        this.normalize(versions, maxLength);
        if (this.equal(subparts, parts)) {
            return true;
        }
        return version.endsWith("+") && this.greater(subparts, parts);
    }

    protected boolean equal(List<String> parts1, List<String> parts2) {
        for (int i = 0; i < parts1.size(); ++i) {
            if (0 == this.compare(parts1.get(i), parts2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean greater(List<String> parts1, List<String> parts2) {
        for (int i = 0; i < parts1.size(); ++i) {
            if (this.compare(parts1.get(i), parts2.get(i)) > 0) {
                return true;
            }
            if (this.compare(parts1.get(i), parts2.get(i)) >= 0) continue;
            return false;
        }
        return false;
    }

    protected int compare(String part1, String part2) {
        Integer number1 = 0;
        Integer number2 = 0;
        try {
            if (part1 != emptyString) {
                number1 = Integer.valueOf(part1);
            }
            if (part2 != emptyString) {
                number2 = Integer.valueOf(part2);
            }
            return number1.compareTo(number2);
        }
        catch (NumberFormatException numberFormatException) {
            if (part1 == emptyString) {
                part1 = "";
            }
            if (part2 == emptyString) {
                part2 = "";
            }
            return part1.compareTo(part2);
        }
    }

    protected void normalize(List<List<String>> versions, int maxLength) {
        int length = 0;
        for (List<String> vers : versions) {
            length = Math.max(length, vers.size());
        }
        if (length > maxLength) {
            length = maxLength;
        }
        for (List<String> vers : versions) {
            while (vers.size() > length) {
                vers.remove(vers.size() - 1);
            }
            while (vers.size() < length) {
                vers.add(emptyString);
            }
        }
    }

    protected List<String> getVersionStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.versionString, " ");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        return strings;
    }

    protected List<String> getParts(String oneVersion) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(oneVersion, ".-_+*");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        return strings;
    }

    public String toString() {
        return this.versionString;
    }

    public static class JreVersion
    extends Version {
        public static boolean warned = false;

        public JreVersion(String v, boolean strict) {
            this(v, strict, JNLPRuntime.isHeadless());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        JreVersion(String v, boolean strict, boolean headless) {
            super(v);
            boolean match = this.matchesJreVersion();
            if (!match) {
                String s = Translator.R("JREversionDontMatch", this.getJreVersion(), v);
                String e = "Strict run is  deffined, and your JRE - " + this.getJreVersion() + " - dont match requested JRE(s) - " + v;
                if (strict) {
                    if (headless) throw new RuntimeException(e);
                    if (warned) return;
                    int r = JOptionPane.showConfirmDialog(null, s + "\n" + Translator.R("JREContinueDialogSentence2"), Translator.R("JREContinueDialogSentenceTitle"), 0);
                    if (r == 1) {
                        throw new RuntimeException(e);
                    }
                    warned = true;
                    return;
                } else {
                    OutputController.getLogger().log(OutputController.Level.WARNING_ALL, s);
                }
                return;
            } else {
                OutputController.getLogger().log("good - your JRE - " + this.getJreVersion() + " - match requested JRE - " + v);
            }
        }

        public boolean matchesJreVersion() {
            return this.matches(this.getJreVersion());
        }

        private String getJreVersion() {
            return System.getProperty("java.version");
        }
    }
}

