/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.dialogs.AccessWarningPaneComplexReturn;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.XDesktopEntry;
import sun.misc.Launcher;

public class AccessWarningPane
extends SecurityDialogPanel {
    private Object[] extras;
    private JCheckBox desktopCheck;
    private JCheckBox menuCheck;
    HtmlShortcutPanel htmlPanelDesktop;
    HtmlShortcutPanel htmlPanelMenu;
    RememberPanel rememberPanel;

    public AccessWarningPane(SecurityDialog x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.addComponents();
    }

    public AccessWarningPane(SecurityDialog x, Object[] extras, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.extras = extras;
        this.addComponents();
    }

    private void addComponents() {
        SecurityDialogs.AccessType type = this.parent.getAccessType();
        JNLPFile file = this.parent.getFile();
        String name = "";
        String publisher = "";
        String from = "";
        try {
            name = file.getInformation().getTitle() != null ? file.getInformation().getTitle() : Translator.R("SNoAssociatedCertificate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            publisher = file.getInformation().getVendor() != null ? file.getInformation().getVendor() + " " + Translator.R("SUnverified") : Translator.R("SNoAssociatedCertificate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            from = !file.getInformation().getHomepage().toString().equals("") ? file.getInformation().getHomepage().toString() : file.getSourceLocation().getAuthority();
        }
        catch (Exception e) {
            from = file.getSourceLocation().getAuthority();
        }
        String topLabelText = "";
        switch (type) {
            case READ_FILE: {
                if (this.extras != null && this.extras.length > 0 && this.extras[0] instanceof String) {
                    topLabelText = Translator.R("SFileReadAccess", FileUtils.displayablePath((String)this.extras[0]));
                    break;
                }
                topLabelText = Translator.R("SFileReadAccess", Translator.R("AFileOnTheMachine"));
                break;
            }
            case WRITE_FILE: {
                if (this.extras != null && this.extras.length > 0 && this.extras[0] instanceof String) {
                    topLabelText = Translator.R("SFileWriteAccess", FileUtils.displayablePath((String)this.extras[0]));
                    break;
                }
                topLabelText = Translator.R("SFileWriteAccess", Translator.R("AFileOnTheMachine"));
                break;
            }
            case CREATE_DESTKOP_SHORTCUT: {
                topLabelText = Translator.R("SDesktopShortcut");
                break;
            }
            case CLIPBOARD_READ: {
                topLabelText = Translator.R("SClipboardReadAccess");
                break;
            }
            case CLIPBOARD_WRITE: {
                topLabelText = Translator.R("SClipboardWriteAccess");
                break;
            }
            case PRINTER: {
                topLabelText = Translator.R("SPrinterAccess");
                break;
            }
            case NETWORK: {
                topLabelText = this.extras != null && this.extras.length >= 0 ? Translator.R("SNetworkAccess", this.extras[0]) : Translator.R("SNetworkAccess", "(address here)");
            }
        }
        ImageIcon icon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/question.png"));
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(450, 100));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel nameLabel = new JLabel(Translator.R("Name") + ":   " + name);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel publisherLabel = new JLabel(Translator.R("Publisher") + ": " + publisher);
        publisherLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel fromLabel = new JLabel(Translator.R("From") + ":   " + from);
        fromLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JButton run = new JButton(Translator.R("ButAllow"));
        final JButton cancel = new JButton(Translator.R("ButCancel"));
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        infoPanel.add((Component)nameLabel, c);
        ++c.gridy;
        infoPanel.add((Component)publisherLabel, c);
        ++c.gridy;
        infoPanel.add((Component)fromLabel, c);
        ++c.gridy;
        if (type == SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT) {
            if (file.getInformation() != null && file.getInformation().getShortcut() != null && file.getInformation().getShortcut().onDesktop()) {
                this.desktopCheck = new JCheckBox(Translator.R("EXAWdesktopWants"));
                this.desktopCheck.setSelected(true);
            } else {
                this.desktopCheck = new JCheckBox(Translator.R("EXAWdesktopDontWants"));
                this.desktopCheck.setSelected(false);
            }
            if (file.getInformation() != null && file.getInformation().getShortcut() != null && file.getInformation().getShortcut().toMenu()) {
                this.menuCheck = file.getInformation().getShortcut() != null && file.getInformation().getShortcut().getMenu() != null && file.getInformation().getShortcut().getMenu().getSubMenu() != null ? new JCheckBox(Translator.R("EXAWsubmenu", file.getInformation().getShortcut().getMenu().getSubMenu())) : new JCheckBox(Translator.R("EXAWmenuWants"));
                this.menuCheck.setSelected(true);
            } else {
                this.menuCheck = new JCheckBox(Translator.R("EXAWmenuDontWants"));
                this.menuCheck.setSelected(false);
            }
            infoPanel.add((Component)new JLabel("<html>___________________________________________________</html>"), c);
            ++c.gridy;
            infoPanel.add((Component)this.desktopCheck, c);
            ++c.gridy;
            if (!JNLPRuntime.isWebstartApplication()) {
                this.htmlPanelDesktop = new HtmlShortcutPanel();
                infoPanel.add((Component)this.htmlPanelDesktop, c);
                this.htmlPanelDesktop.setVisible(false);
                ++c.gridy;
            }
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AccessWarningPane.this.desktopCheck.isSelected() || AccessWarningPane.this.menuCheck.isSelected()) {
                        run.setEnabled(true);
                        cancel.setEnabled(false);
                    } else {
                        run.setEnabled(false);
                        cancel.setEnabled(true);
                    }
                }
            };
            this.desktopCheck.addActionListener(al);
            this.menuCheck.addActionListener(al);
            al.actionPerformed(null);
            infoPanel.add((Component)this.menuCheck, c);
            ++c.gridy;
            if (!JNLPRuntime.isWebstartApplication()) {
                this.htmlPanelMenu = new HtmlShortcutPanel();
                infoPanel.add((Component)this.htmlPanelMenu, c);
                this.htmlPanelMenu.setVisible(false);
                ++c.gridy;
            }
            infoPanel.add((Component)new JLabel(Translator.R("EXAWsettingsInfo", ShortcutDesc.deploymentJavawsShortcutToString(JNLPRuntime.getConfiguration().getProperty("deployment.javaws.shortcut")), Translator.R("CPTabDesktopIntegration"))), c);
            ++c.gridy;
            infoPanel.add((Component)new JLabel(Translator.R("EXAWsettingsManage", Translator.R("CPTabMenuShortcuts"))), c);
            ++c.gridy;
            infoPanel.validate();
        }
        this.rememberPanel = new RememberPanel();
        infoPanel.add((Component)this.rememberPanel, c);
        ++c.gridy;
        infoPanel.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton showAdvanced = new JButton(Translator.R("ButAdvancedOptions"));
        showAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.negateVisibility(AccessWarningPane.this.rememberPanel);
                this.negateVisibility(AccessWarningPane.this.htmlPanelDesktop);
                this.negateVisibility(AccessWarningPane.this.htmlPanelMenu);
                AccessWarningPane.this.parent.pack();
            }

            private void negateVisibility(JComponent a) {
                if (a != null) {
                    a.setVisible(!a.isVisible());
                }
            }
        });
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessWarningPane.this.parent.setValue(AccessWarningPane.this.getModifier(0));
                AccessWarningPane.this.parent.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessWarningPane.this.parent.setValue(AccessWarningPane.this.getModifier(1));
                AccessWarningPane.this.parent.dispose();
            }
        });
        this.initialFocusComponent = cancel;
        buttonPanel.add(run);
        buttonPanel.add(cancel);
        buttonPanel.add(showAdvanced);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(topPanel);
        this.add(infoPanel);
        this.add(buttonPanel);
        this.rememberPanel.setVisible(false);
        this.parent.pack();
    }

    private AccessWarningPaneComplexReturn getModifier(int button) {
        AccessWarningPaneComplexReturn ar = new AccessWarningPaneComplexReturn(button);
        if (this.desktopCheck != null) {
            if (this.htmlPanelDesktop != null) {
                ar.setDekstop(this.htmlPanelDesktop.getShortcutResult(this.desktopCheck.isSelected()));
            } else {
                ar.setDekstop(new AccessWarningPaneComplexReturn.ShortcutResult(this.desktopCheck.isSelected()));
            }
        }
        if (this.menuCheck != null) {
            if (this.htmlPanelMenu != null) {
                ar.setMenu(this.htmlPanelMenu.getShortcutResult(this.menuCheck.isSelected()));
            } else {
                ar.setMenu(new AccessWarningPaneComplexReturn.ShortcutResult(this.menuCheck.isSelected()));
            }
        }
        if (this.rememberPanel != null) {
            ar.setRember(this.rememberPanel.getShortcutResult());
        }
        return ar;
    }

    private class HtmlShortcutPanel
    extends JPanel {
        final JRadioButton browser;
        final JComboBox<String> browsers;
        final JRadioButton jnlpGen;
        final JRadioButton jnlpHref;
        final JRadioButton javawsHtml;
        final JCheckBox fix;
        final ActionListener modifySecondaryControls;

        public HtmlShortcutPanel() {
            super(new FlowLayout(1, 1, 5));
            this.browser = new JRadioButton(Translator.R("EXAWbrowser"), true);
            this.browsers = new JComboBox<String>(XDesktopEntry.BROWSERS);
            this.jnlpGen = new JRadioButton(Translator.R("EXAWgenjnlp"));
            this.jnlpHref = new JRadioButton(Translator.R("EXAWjnlphref"));
            this.javawsHtml = new JRadioButton(Translator.R("EXAWhtml"));
            this.fix = new JCheckBox(Translator.R("EXAWfixhref"));
            this.modifySecondaryControls = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (HtmlShortcutPanel.this.browser.isSelected()) {
                        HtmlShortcutPanel.this.browsers.setEnabled(true);
                    } else {
                        HtmlShortcutPanel.this.browsers.setEnabled(false);
                    }
                    if (HtmlShortcutPanel.this.jnlpHref.isSelected()) {
                        HtmlShortcutPanel.this.fix.setEnabled(true);
                        HtmlShortcutPanel.this.fix.setSelected(true);
                    } else {
                        HtmlShortcutPanel.this.fix.setEnabled(false);
                        HtmlShortcutPanel.this.fix.setSelected(false);
                    }
                }
            };
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.addMainComponents();
            this.setTooltips();
            ButtonGroup bg = this.createRadiosGroup();
            this.modifySecondaryControls.actionPerformed(null);
            this.validate();
        }

        public AccessWarningPaneComplexReturn.ShortcutResult getShortcutResult(boolean mainResolution) {
            AccessWarningPaneComplexReturn.ShortcutResult r = new AccessWarningPaneComplexReturn.ShortcutResult(mainResolution);
            r.setBrowser((String)this.browsers.getSelectedItem());
            r.setFixHref(this.fix.isSelected());
            if (this.browser.isSelected()) {
                r.setShortcutType(AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.BROWSER);
            } else if (this.jnlpGen.isSelected()) {
                r.setShortcutType(AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.GENERATED_JNLP);
            } else if (this.jnlpHref.isSelected()) {
                r.setShortcutType(AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.JNLP_HREF);
            } else if (this.javawsHtml.isSelected()) {
                r.setShortcutType(AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.JAVAWS_HTML);
            }
            return r;
        }

        private ButtonGroup createRadiosGroup() {
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.browser);
            bg.add(this.jnlpGen);
            bg.add(this.jnlpHref);
            bg.add(this.javawsHtml);
            this.setCheckboxModifierListener();
            return bg;
        }

        private void setCheckboxModifierListener() {
            this.browser.addActionListener(this.modifySecondaryControls);
            this.jnlpGen.addActionListener(this.modifySecondaryControls);
            this.jnlpHref.addActionListener(this.modifySecondaryControls);
            this.javawsHtml.addActionListener(this.modifySecondaryControls);
        }

        private void addMainComponents() {
            this.add(this.browser);
            this.browsers.setEditable(true);
            this.browsers.setSelectedItem(XDesktopEntry.getBrowserBin());
            this.add(this.browsers);
            this.add(this.jnlpGen);
            this.add(this.jnlpHref);
            this.add(this.javawsHtml);
            this.add(this.fix);
            if (AccessWarningPane.this.parent.getFile() instanceof PluginBridge && ((PluginBridge)AccessWarningPane.this.parent.getFile()).haveDebugJnlp()) {
                this.jnlpHref.setEnabled(true);
            } else {
                this.jnlpHref.setEnabled(false);
            }
        }

        private void setTooltips() {
            this.browser.setToolTipText(Translator.R("EXAWbrowserTolltip"));
            this.browsers.setToolTipText(Translator.R("EXAWbrowsersTolltip"));
            this.jnlpGen.setToolTipText(Translator.R("EXAWgeneratedTolltip"));
            this.jnlpHref.setToolTipText(Translator.R("EXAWhrefTolltip"));
            this.javawsHtml.setToolTipText(Translator.R("EXAWhtmlTolltip"));
            this.fix.setToolTipText(Translator.R("EXAWfixTolltip"));
        }
    }

    private class RememberPanel
    extends JPanel {
        final JRadioButton byApp;
        final JRadioButton byPage;
        final JRadioButton dont;

        public RememberPanel() {
            super(new FlowLayout(1, 1, 5));
            this.byApp = new JRadioButton(Translator.R("EXAWrememberByApp"));
            this.byPage = new JRadioButton(Translator.R("EXAWrememberByPage"));
            this.dont = new JRadioButton(Translator.R("EXAWdontRemember"), true);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(this.byApp);
            this.add(this.byPage);
            this.add(this.dont);
            this.byApp.setToolTipText(Translator.R("EXAWrememberByAppTooltip"));
            this.byPage.setToolTipText(Translator.R("EXAWrememberByPageTooltip"));
            this.dont.setToolTipText(Translator.R("EXAWdontRememberTooltip"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.byApp);
            bg.add(this.byPage);
            bg.add(this.dont);
            this.validate();
        }

        public AccessWarningPaneComplexReturn.RemeberType getShortcutResult() {
            if (this.byApp.isSelected()) {
                return AccessWarningPaneComplexReturn.RemeberType.REMEMBER_BY_APP;
            }
            if (this.byPage.isSelected()) {
                return AccessWarningPaneComplexReturn.RemeberType.REMEMBER_BY_DOMAIN;
            }
            if (this.dont.isSelected()) {
                return AccessWarningPaneComplexReturn.RemeberType.REMEMBER_DONT;
            }
            return AccessWarningPaneComplexReturn.RemeberType.REMEMBER_DONT;
        }
    }
}

