/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.util.BiFunction;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.AbstractModelActionWithView;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.component.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.internal.builder.TypeBuilderFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeModelRuleExtractor
extends TypeModelRuleExtractor<ComponentType, ComponentSpec, BaseComponentSpec> {
    public ComponentTypeModelRuleExtractor(ModelSchemaStore schemaStore) {
        super("component", ComponentSpec.class, BaseComponentSpec.class, ComponentTypeBuilder.class, schemaStore, new TypeBuilderFactory<ComponentSpec>(){

            @Override
            public TypeBuilderInternal<ComponentSpec> create(ModelSchema<? extends ComponentSpec> schema) {
                return new DefaultComponentTypeBuilder(schema);
            }
        });
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends ComponentSpec> type, TypeBuilderInternal<ComponentSpec> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType implementation = this.determineImplementationType(type, builder);
        RegistrationAction<? extends ComponentSpec> mutator = RegistrationAction.create(type, implementation, builder.getInternalViews(), ruleDefinition.getDescriptor());
        return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, mutator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction<S extends ComponentSpec>
    extends AbstractModelActionWithView<ComponentSpecFactory> {
        private static final ModelType<ComponentSpecInternal> COMPONENT_SPEC_INTERNAL_MODEL_TYPE = ModelType.of(ComponentSpecInternal.class);
        private final ModelType<S> publicType;
        private final ModelType<? extends BaseComponentSpec> implementationType;
        private final Set<Class<?>> internalViews;

        public static <S extends ComponentSpec> RegistrationAction<S> create(ModelType<S> publicType, ModelType<? extends BaseComponentSpec> implementationType, Set<Class<?>> internalViews, ModelRuleDescriptor descriptor) {
            return new RegistrationAction<S>(publicType, implementationType, internalViews, descriptor);
        }

        private RegistrationAction(ModelType<S> publicType, ModelType<? extends BaseComponentSpec> implementationType, Set<Class<?>> internalViews, ModelRuleDescriptor descriptor) {
            super(ModelReference.of(ComponentSpecFactory.class), descriptor, new ModelReference[]{ModelReference.of((String)"serviceRegistry", ServiceRegistry.class), ModelReference.of((String)"projectIdentifier", ProjectIdentifier.class), ModelReference.of((String)"sources", ProjectSourceSet.class), ModelReference.of((String)"languages", LanguageRegistry.class)});
            this.publicType = publicType;
            this.implementationType = implementationType;
            this.internalViews = internalViews;
        }

        protected void execute(MutableModelNode modelNode, ComponentSpecFactory components, List<ModelView<?>> inputs) {
            InstanceFactory.TypeRegistrationBuilder registration = components.register(this.publicType, this.descriptor);
            if (this.implementationType != null) {
                ServiceRegistry serviceRegistry = (ServiceRegistry)ModelViews.assertType(inputs.get(0), (ModelType)ModelType.of(ServiceRegistry.class)).getInstance();
                final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
                final ProjectIdentifier projectIdentifier = (ProjectIdentifier)ModelViews.assertType(inputs.get(1), (ModelType)ModelType.of(ProjectIdentifier.class)).getInstance();
                ProjectSourceSet projectSourceSet = (ProjectSourceSet)ModelViews.assertType(inputs.get(2), (ModelType)ModelType.of(ProjectSourceSet.class)).getInstance();
                final LanguageRegistry languageRegistry = (LanguageRegistry)ModelViews.assertType(inputs.get(3), (ModelType)ModelType.of(LanguageRegistry.class)).getInstance();
                registration.withImplementation((ModelType)Cast.uncheckedCast(this.implementationType), new BiFunction<S, String, MutableModelNode>(){

                    public S apply(String name, MutableModelNode modelNode1) {
                        DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(projectIdentifier.getPath(), name);
                        return (ComponentSpec)Cast.uncheckedCast(BaseComponentSpec.create(RegistrationAction.this.implementationType.getConcreteClass(), id, modelNode1, instantiator, languageRegistry, projectIdentifier.getProjectDir()));
                    }
                });
                if (COMPONENT_SPEC_INTERNAL_MODEL_TYPE.isAssignableFrom(this.implementationType)) {
                    registration.withInternalView(COMPONENT_SPEC_INTERNAL_MODEL_TYPE);
                }
            }
            for (Class<?> internalView : this.internalViews) {
                registration.withInternalView(ModelType.of(internalView));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComponentTypeBuilder
    extends AbstractTypeBuilder<ComponentSpec>
    implements ComponentTypeBuilder<ComponentSpec> {
        public DefaultComponentTypeBuilder(ModelSchema<? extends ComponentSpec> schema) {
            super(ComponentType.class, schema);
        }
    }
}

