/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.model.ModelMap;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedModelMapProjection<P extends ModelMap<E>, E>
implements ModelProjection {
    private final ModelType<P> publicType;
    private final ModelType<E> elementType;
    private final Class<? extends P> viewImpl;
    private final ChildNodeInitializerStrategyAccessor<? super E> creatorStrategyAccessor;

    public SpecializedModelMapProjection(ModelType<P> publicType, ModelType<E> elementType, Class<? extends P> viewImpl, ChildNodeInitializerStrategyAccessor<? super E> creatorStrategyAccessor) {
        this.publicType = publicType;
        this.elementType = elementType;
        this.viewImpl = viewImpl;
        this.creatorStrategyAccessor = creatorStrategyAccessor;
    }

    @Override
    public Iterable<String> getReadableTypeDescriptions(MutableModelNode node) {
        return this.getWritableTypeDescriptions(node);
    }

    @Override
    public Iterable<String> getWritableTypeDescriptions(MutableModelNode node) {
        return Collections.singleton(this.publicType.toString());
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode node, @Nullable ModelRuleDescriptor ruleDescriptor) {
        if (this.canBeViewedAsImmutable(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(node, ruleDescriptor, false));
        }
        return null;
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, MutableModelNode node, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> implicitDependencies) {
        if (this.canBeViewedAsMutable(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(node, ruleDescriptor, true));
        }
        return null;
    }

    private ModelView<P> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
        ChildNodeInitializerStrategy<? super E> creatorStrategy = this.creatorStrategyAccessor.getStrategy(modelNode);
        DefaultModelViewState state = new DefaultModelViewState(this.publicType, ruleDescriptor, mutable, true);
        String description = this.publicType.getDisplayName() + " '" + modelNode.getPath() + "'";
        NodeBackedModelMap<? super E> rawView = new NodeBackedModelMap<E>(description, this.elementType, ruleDescriptor, modelNode, false, state, creatorStrategy);
        ModelMap instance = (ModelMap)DirectInstantiator.instantiate(this.viewImpl, (Object[])new Object[]{rawView});
        return InstanceModelView.of(modelNode.getPath(), this.publicType, instance, state.closer());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecializedModelMapProjection that = (SpecializedModelMapProjection)o;
        return this.publicType.equals(that.publicType) && this.viewImpl.equals(that.viewImpl);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.publicType.hashCode();
        result = 31 * result + this.viewImpl.hashCode();
        return result;
    }

    @Override
    public <T> boolean canBeViewedAsMutable(ModelType<T> targetType) {
        return targetType.equals(this.publicType) || targetType.equals(ModelType.of(Object.class));
    }

    @Override
    public <T> boolean canBeViewedAsImmutable(ModelType<T> targetType) {
        return this.canBeViewedAsMutable(targetType);
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        return Optional.absent();
    }
}

