/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelMapGroovyDecorator;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.manage.schema.extract.ManagedCollectionProxyClassGenerator;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedMapStrategy
implements ModelSchemaExtractionStrategy {
    private final ManagedCollectionProxyClassGenerator generator = new ManagedCollectionProxyClassGenerator();

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        Type type = extractionContext.getType().getType();
        if (!(type instanceof Class)) {
            return;
        }
        Class contractType = (Class)type;
        if (!contractType.isInterface()) {
            return;
        }
        if (contractType.getGenericInterfaces().length != 1) {
            return;
        }
        Type superType = contractType.getGenericInterfaces()[0];
        if (!(superType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedSuperType = (ParameterizedType)superType;
        if (!parameterizedSuperType.getRawType().equals(ModelMap.class)) {
            return;
        }
        ModelType<?> elementType = ModelType.of(parameterizedSuperType.getActualTypeArguments()[0]);
        Class<?> proxyImpl = this.generator.generate(ModelMapGroovyDecorator.Managed.class, contractType);
        extractionContext.found(new SpecializedMapSchema<T>(extractionContext.getType(), elementType, proxyImpl));
    }
}

