/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import org.gradle.api.Action;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.internal.serialize.StatefulSerializer;
import org.gradle.internal.serialize.kryo.JavaSerializer;
import org.gradle.internal.serialize.kryo.TypeSafeSerializer;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.ConnectCompletion;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.KryoBackedMessageSerializer;
import org.gradle.messaging.remote.internal.hub.InterHubMessageSerializer;
import org.gradle.messaging.remote.internal.hub.MessageHub;
import org.gradle.messaging.remote.internal.hub.MethodInvocationSerializer;
import org.gradle.messaging.remote.internal.hub.protocol.InterHubMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHubBackedObjectConnection
implements ObjectConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHubBackedObjectConnection.class);
    private final MessageHub hub;
    private ConnectCompletion completion;
    private Connection<InterHubMessage> connection;
    private ClassLoader methodParamClassLoader;
    private Serializer<Object[]> paramSerializer;

    public MessageHubBackedObjectConnection(ExecutorFactory executorFactory, ConnectCompletion completion) {
        this.hub = new MessageHub(completion.toString(), executorFactory, (Action<? super Throwable>)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                LOGGER.error("Unexpected exception thrown.", throwable);
            }
        });
        this.completion = completion;
    }

    @Override
    public <T> void addIncoming(Class<T> type, T instance) {
        if (this.methodParamClassLoader == null) {
            this.methodParamClassLoader = type.getClassLoader();
        }
        this.hub.addHandler(type.getName(), new ReflectionDispatch(instance));
    }

    @Override
    public <T> T addOutgoing(Class<T> type) {
        if (this.methodParamClassLoader == null) {
            this.methodParamClassLoader = type.getClassLoader();
        }
        ProxyDispatchAdapter<T> adapter = new ProxyDispatchAdapter<T>(this.hub.getOutgoing(type.getName(), MethodInvocation.class), type, ThreadSafe.class);
        return adapter.getSource();
    }

    @Override
    public void useDefaultSerialization(ClassLoader methodParamClassLoader) {
        this.methodParamClassLoader = methodParamClassLoader;
    }

    @Override
    public void useParameterSerializer(Serializer<Object[]> serializer) {
        this.paramSerializer = serializer;
    }

    @Override
    public void connect() {
        if (this.methodParamClassLoader == null) {
            this.methodParamClassLoader = this.getClass().getClassLoader();
        }
        StatefulSerializer<Object[]> paramSerializer = this.paramSerializer != null ? Serializers.stateful(this.paramSerializer) : new JavaSerializer<Object[]>(this.methodParamClassLoader);
        KryoBackedMessageSerializer<InterHubMessage> serializer = new KryoBackedMessageSerializer<InterHubMessage>(new InterHubMessageSerializer(new TypeSafeSerializer<MethodInvocation>(MethodInvocation.class, new MethodInvocationSerializer(this.methodParamClassLoader, paramSerializer))));
        this.connection = this.completion.create(serializer);
        this.hub.addConnection(this.connection);
        this.completion = null;
    }

    @Override
    public void requestStop() {
        this.hub.requestStop();
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.hub, this.connection}).stop();
    }
}

