/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import org.apache.commons.lang.WordUtils;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleOperationPersistentStore<V> {
    private static final long CACHE_KEY = 0L;
    private final CacheRepository cacheRepository;
    private final Object scope;
    private final String cacheName;
    private final Serializer<V> valueSerializer;
    private PersistentIndexedCache<Long, V> cache;
    private PersistentCache cacheAccess;

    public SingleOperationPersistentStore(CacheRepository cacheRepository, Object scope, String cacheName, Serializer<V> valueSerializer) {
        this.cacheRepository = cacheRepository;
        this.scope = scope;
        this.cacheName = cacheName;
        this.valueSerializer = valueSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAndClose(V value) {
        this.initCaches("write");
        try {
            this.cache.put(0L, value);
        }
        finally {
            this.closeCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndClose() {
        this.initCaches("read");
        try {
            V v = this.cache.get(0L);
            return v;
        }
        finally {
            this.cacheAccess.close();
        }
    }

    private void initCaches(String operation) {
        String identifier = WordUtils.uncapitalize((String)GUtil.toCamelCase(this.cacheName));
        this.cacheAccess = this.cacheRepository.store(this.scope, identifier).withDisplayName(this.cacheName + " " + operation + " cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive)).open();
        this.cache = this.cacheAccess.createCache(new PersistentIndexedCacheParameters(identifier, BaseSerializerFactory.LONG_SERIALIZER, this.valueSerializer));
    }

    private void closeCaches() {
        this.cacheAccess.close();
        this.cache = null;
        this.cacheAccess = null;
    }
}

