/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.google.common.base.Objects;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class SourceFragmentPositionRange {
    private final int mStartLine;
    private final int mStartColumn;
    private final int mStartOffset;
    private final int mEndLine;
    private final int mEndColumn;
    private final int mEndOffset;
    private static final String START_LINE = "startLine";
    private static final String START_COLUMN = "startColumn";
    private static final String START_OFFSET = "startOffset";
    private static final String END_LINE = "endLine";
    private static final String END_COLUMN = "endColumn";
    private static final String END_OFFSET = "endOffset";

    public SourceFragmentPositionRange(int startLine, int startColumn, int startOffset, int endLine, int endColumn, int endOffset) {
        this.mStartLine = startLine;
        this.mStartColumn = startColumn;
        this.mStartOffset = startOffset;
        this.mEndLine = endLine;
        this.mEndColumn = endColumn;
        this.mEndOffset = endOffset;
    }

    public SourceFragmentPositionRange(int lineNumber, int column, int offset) {
        this.mStartLine = this.mEndLine = lineNumber;
        this.mStartColumn = this.mEndColumn = column;
        this.mStartOffset = this.mEndOffset = offset;
    }

    public SourceFragmentPositionRange() {
        this.mEndOffset = -1;
        this.mEndColumn = -1;
        this.mEndLine = -1;
        this.mStartOffset = -1;
        this.mStartColumn = -1;
        this.mStartLine = -1;
    }

    public String toString() {
        StringBuilder sB = new StringBuilder();
        sB.append(this.mStartLine);
        if (this.mStartColumn != -1) {
            sB.append(':');
            sB.append(this.mStartColumn);
        }
        if (this.mEndLine != -1) {
            if (this.mEndLine == this.mStartLine) {
                if (this.mEndColumn != -1 && this.mEndColumn != this.mStartColumn) {
                    sB.append('-');
                    sB.append(this.mEndColumn);
                }
            } else {
                sB.append('-');
                sB.append(this.mEndLine);
                if (this.mEndColumn != -1) {
                    sB.append(':');
                    sB.append(this.mEndColumn);
                }
            }
        }
        return sB.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceFragmentPositionRange) {
            SourceFragmentPositionRange other = (SourceFragmentPositionRange)obj;
            return other.mStartLine == this.mStartLine && other.mStartColumn == this.mStartColumn && other.mStartOffset == this.mStartOffset && other.mEndLine == this.mEndLine && other.mEndColumn == this.mEndColumn && other.mEndOffset == this.mEndOffset;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mStartLine, this.mStartColumn, this.mStartOffset, this.mEndLine, this.mEndColumn, this.mEndOffset});
    }

    public int getStartLine() {
        return this.mStartLine;
    }

    public int getStartColumn() {
        return this.mStartColumn;
    }

    public int getStartOffset() {
        return this.mStartOffset;
    }

    public int getEndLine() {
        return this.mEndLine;
    }

    public int getEndColumn() {
        return this.mEndColumn;
    }

    public int getEndOffset() {
        return this.mEndOffset;
    }

    public static class Deserializer
    implements JsonDeserializer<SourceFragmentPositionRange> {
        public SourceFragmentPositionRange deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject object = jsonElement.getAsJsonObject();
            int startLine = object.has(SourceFragmentPositionRange.START_LINE) ? object.get(SourceFragmentPositionRange.START_LINE).getAsInt() : -1;
            int startColumn = object.has(SourceFragmentPositionRange.START_COLUMN) ? object.get(SourceFragmentPositionRange.START_COLUMN).getAsInt() : -1;
            int startOffset = object.has(SourceFragmentPositionRange.START_OFFSET) ? object.get(SourceFragmentPositionRange.START_OFFSET).getAsInt() : -1;
            int endLine = object.has(SourceFragmentPositionRange.END_LINE) ? object.get(SourceFragmentPositionRange.END_LINE).getAsInt() : startLine;
            int endColumn = object.has(SourceFragmentPositionRange.END_COLUMN) ? object.get(SourceFragmentPositionRange.END_COLUMN).getAsInt() : startColumn;
            int endOffset = object.has(SourceFragmentPositionRange.END_OFFSET) ? object.get(SourceFragmentPositionRange.END_OFFSET).getAsInt() : startOffset;
            return new SourceFragmentPositionRange(startLine, startColumn, startOffset, endLine, endColumn, endOffset);
        }
    }

    public static class Serializer
    implements JsonSerializer<SourceFragmentPositionRange> {
        public JsonElement serialize(SourceFragmentPositionRange position, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject result = new JsonObject();
            if (position.getStartLine() != -1) {
                result.addProperty(SourceFragmentPositionRange.START_LINE, (Number)position.getStartLine());
            }
            if (position.getStartColumn() != -1) {
                result.addProperty(SourceFragmentPositionRange.START_COLUMN, (Number)position.getStartColumn());
            }
            if (position.getStartOffset() != -1) {
                result.addProperty(SourceFragmentPositionRange.START_OFFSET, (Number)position.getStartOffset());
            }
            if (position.getEndLine() != -1 && position.getEndLine() != position.getStartLine()) {
                result.addProperty(SourceFragmentPositionRange.END_LINE, (Number)position.getEndLine());
            }
            if (position.getEndColumn() != -1 && position.getEndColumn() != position.getStartColumn()) {
                result.addProperty(SourceFragmentPositionRange.END_COLUMN, (Number)position.getEndColumn());
            }
            if (position.getEndOffset() != -1 && position.getEndOffset() != position.getStartOffset()) {
                result.addProperty(SourceFragmentPositionRange.END_OFFSET, (Number)position.getEndOffset());
            }
            return result;
        }
    }
}

