/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Random;
import kotlin.Pair;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!!!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u000455\u0002rA\u0007\b\u0013\tI\u0011\u0001'\u0003\n\u0005%\t\u0001\u0014\u0001\r\u00053\rAQ!D\u0001\u0019\u0002e\u0019\u00012B\u0007\u00021\u0003I2\u0001\u0003\u0004\u000e\u0003a\u0005Ak\u0001\u0002\u0012\u0019\u0011\u0019\u0005*\u0001\u0005\u0001\u001b\u0005A\n!U\u0002\u0005\u000b\u0001i!\u0001B\u0001\t\u0004Q\u001b!!%\u0005\u0005\u0003\"A)!D\u0001\u0019\u0007E\u001b\u0011!\u0002\u0001U\u0007\t\u0001"}, strings={"SOCKET_ANY_FREE_PORT", "", "getSOCKET_ANY_FREE_PORT", "()I", "NetworkUtilsKt", "portSelectionRng", "Ljava/util/Random;", "findPortAndCreateRegistry", "Lkotlin/Pair;", "Ljava/rmi/registry/Registry;", "attempts", "portRangeStart", "portRangeEnd"}, moduleName="rmi-interface")
public final class NetworkUtilsKt {
    private static final int SOCKET_ANY_FREE_PORT = 0;
    private static final Random portSelectionRng = new Random();

    public static final int getSOCKET_ANY_FREE_PORT() {
        return SOCKET_ANY_FREE_PORT;
    }

    @NotNull
    public static final Pair<Registry, Integer> findPortAndCreateRegistry(int attempts, int portRangeStart, int portRangeEnd) {
        int i = 0;
        RemoteException lastException = null;
        while (i++ < attempts) {
            int port = portSelectionRng.nextInt(portRangeEnd - portRangeStart) + portRangeStart;
            try {
                return new Pair((Object)LocateRegistry.createRegistry(port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory()), (Object)port);
            }
            catch (RemoteException e) {
                lastException = e;
            }
        }
        throw (Throwable)new IllegalStateException("Cannot find free port in " + attempts + " attempts", lastException);
    }
}

