/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.MessageNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultilineTreeCellRenderer;
import icons.AntIcons;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;

final class MessageTreeRenderer
extends MultilineTreeCellRenderer {
    private MessageTreeRenderer() {
    }

    public static JScrollPane install(JTree tree) {
        JScrollPane scrollPane = MultilineTreeCellRenderer.installRenderer((JTree)tree, (MultilineTreeCellRenderer)new MessageTreeRenderer());
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        return scrollPane;
    }

    protected void initComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof MessageNode) {
            MessageNode messageNode = (MessageNode)value;
            this.setText(messageNode.getText(), messageNode.getTypeString() + messageNode.getPositionString());
        } else {
            String[] text = new String[]{value.toString()};
            if (text[0] == null) {
                text[0] = "";
            }
            this.setText(text, null);
        }
        Icon icon = null;
        if (value instanceof MessageNode) {
            MessageNode node = (MessageNode)value;
            AntBuildMessageView.MessageType type = node.getType();
            if (type == AntBuildMessageView.MessageType.BUILD) {
                icon = AntIcons.Build;
            } else if (type == AntBuildMessageView.MessageType.TARGET) {
                icon = AntIcons.Target;
            } else if (type == AntBuildMessageView.MessageType.TASK) {
                icon = AntIcons.Task;
            } else if (type == AntBuildMessageView.MessageType.MESSAGE) {
                icon = node.getPriority() == 1 ? AllIcons.General.Warning : AntIcons.Message;
            } else if (type == AntBuildMessageView.MessageType.ERROR) {
                icon = AllIcons.General.Error;
            }
        }
        this.setIcon(icon);
    }
}

