/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import kotlin.ArraysKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u0016\u0015\u0001Q!\u0001E\r\u000b\u0001)\u0011\u0001\u0003\u0007\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0011\u0001b\u0001\u0006\u0003!5Q!\u0001C\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001BB\u0003\u0002\t\u0007)\u0011\u0001C\u0004\u0006\u0003\u0011\u0015Aa\u0003\u0007\u0001!WI\u0012\u0001'\u0001\u001e\u0003W1\u0012u\u0005\u0003\u0003\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005AJ!U\u0002\u0002\u0011\u0015)3\u0002C\u0004\u000e\u00051\u0005\u0001\u0004A\r\u0007\u0011\u001fiA\u0001$\u0001\u0019\u0011%\n\u0001\u0014C\u0013\u0005\t\u0005A\u0011\"D\u0001\u0019\u0014\u0015BA!\u0001\u0005\n\u001b\u0005A\u001a\"G\u0002\t\u00155\t\u0001\u0014B\u0013\u0015\t-A)\"D\u0001\u0019\u0001e\u0019\u0001\"A\u0007\u00021\u0007I2\u0001\u0003\u0002\u000e\u0003a\u0015\u0011d\u0001\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001\u0014B\u0013\b\u0011-i\u0011\u0001g\u0006\u001a\u0007!aQ\"\u0001M\fK\u001dAI\"D\u0001\u0019\u0014e\u0019\u0001\"D\u0007\u00021\u0001)s\u0001c\u0007\u000e\u0003aM\u0011d\u0001\u0005\u000e\u001b\u0005A\u0002!J\u0006\u0005\u0015!qQB\u0001G\u00011;IR\u0001c\u0004\u000e\u0007aA\u0011&\u0001M\tK\u001dAq\"D\u0001\u0019\ne\u0019\u0001\u0002D\u0007\u00021/)3\u0001c\b\u000e\u0003a%QU\u0002\u0005\u0011\u001b\ta\t\u0001g\u0005R\u0007\u0005A\t#j\u0004\u0005\u0017!\tRB\u0001G\u00011G\t6!\u0001\u0005\u0013K!!\u0011\u0001#\n\u000e\u0003aM\u0011d\u0001\u0005\u000e\u001b\u0005A\u0002!\n\u0003\u0005\u0017!\u0019R\"\u0001M\u0014K-!\u0011\u0001\u0003\u000b\u000e\u00051\u0005\u0001\u0004A\r\u0006\u0011\u001fi1\u0001\u0007\u0005*\u0003aEQe\u0003\u0003\u0002\u0011Si!\u0001$\u0001\u0019\u0001e)\u0001rB\u0007\u00041!I\u0013\u0001'\u0005&\u000f!)R\"\u0001M\n3\rAQ\"D\u0001\u0019\u0001%RAa\u0013\u0005\t\f5\t\u0001\u0004\u0001\u000f,#\u000e\u0019QB\u0001\u0003\u0007\u0011\u001bIs\u0001B!\t\u0011\u0011i\u0011\u0001'\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00055\t\u0001TA)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "", "indents", "", "types", "", "isExplicit", "", "charsEaten", "", "([I[C[ZI)V", "base", "getBase", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "addModifierIfNeeded", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "containsListMarkers", "", "upToIndex", "createNewConstraints", "eatItselfFromString", "", "s", "extendsList", "other", "extendsPrev", "fetchListMarker", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints$ListMarkerInfo;", "getCharsEaten", "getIndent", "getLastExplicit", "()Ljava/lang/Boolean;", "getLastType", "", "()Ljava/lang/Character;", "startsWith", "toString", "", "tryAddBlockQuote", "tryAddListItem", "upstreamWith", "Companion", "ListMarkerInfo"}, moduleName="intellij-markdown")
public class MarkdownConstraints {
    @NotNull
    public static final MarkdownConstraints BASE;
    public static final char BQ_CHAR = '>';
    private final int[] indents;
    private final char[] types;
    private final boolean[] isExplicit;
    private final int charsEaten;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.INSTANCE;
        BASE = new MarkdownConstraints(new int[0], new char[0], new boolean[0], 0);
        BQ_CHAR = (char)62;
    }

    @NotNull
    public MarkdownConstraints getBase() {
        return Companion.getBASE();
    }

    @NotNull
    public MarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        return new MarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @NotNull
    public final CharSequence eatItselfFromString(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (s.length() < this.charsEaten) {
            return "";
        }
        return s.subSequence(this.charsEaten, s.length());
    }

    public final int getIndent() {
        if (this.indents.length == 0) {
            return 0;
        }
        return ArraysKt.last((int[])this.indents);
    }

    public final int getCharsEaten(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return Math.min(this.charsEaten, s.length());
    }

    @Nullable
    public Character getLastType() {
        return ArraysKt.lastOrNull((char[])this.types);
    }

    @Nullable
    public final Boolean getLastExplicit() {
        return ArraysKt.lastOrNull((boolean[])this.isExplicit);
    }

    public final boolean upstreamWith(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.startsWith(this) && !this.containsListMarkers();
    }

    public final boolean extendsPrev(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.startsWith(other) && !this.containsListMarkers(other.types.length);
    }

    public final boolean extendsList(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other.types.length == 0) {
            throw (Throwable)new IllegalArgumentException("List constraints should contain at least one item");
        }
        return this.startsWith(other) && !this.containsListMarkers(other.types.length - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean startsWith(MarkdownConstraints other) {
        int n = this.indents.length;
        int m = other.indents.length;
        if (n < m) {
            return false;
        }
        int n2 = 0;
        int n3 = m - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (this.types[i] != other.types[i]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    private final boolean containsListMarkers() {
        return this.containsListMarkers(this.types.length);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsListMarkers(int upToIndex) {
        int n = 0;
        int n2 = upToIndex - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (this.types[i] != Companion.getBQ_CHAR() && this.isExplicit[i]) {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    @Nullable
    public final MarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getChar() == '\n') {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        MarkdownConstraints markdownConstraints = this.tryAddListItem(pos);
        if (markdownConstraints == null) {
            markdownConstraints = this.tryAddBlockQuote(pos);
        }
        return markdownConstraints;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        int offset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (pos.getChar() == '*' || pos.getChar() == '-' || pos.getChar() == '+') {
            return new ListMarkerInfo(String.valueOf(pos.getChar()), pos.getChar(), 1);
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length(); ++offset) {
            char c = line.charAt(offset);
            boolean bl = true;
            if (c < '0') {
                bl = false;
            }
            boolean bl2 = true;
            if (c > '9') {
                bl2 = false;
            }
            if (!(bl & bl2)) break;
        }
        if (offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')')) {
            return new ListMarkerInfo(line.subSequence(pos.getOffsetInCurrentLine(), offset + 1), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine());
        }
        return null;
    }

    private final MarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(spacesBefore);
        if (position == null) {
            Intrinsics.throwNpe();
        }
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerText().length();
        block5: while (offset < line.length()) {
            switch (line.charAt(offset)) {
                case ' ': {
                    ++spacesAfter;
                    break;
                }
                case '\t': {
                    spacesAfter += 4 - spacesAfter % 4;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++offset;
        }
        if (spacesAfter > 0 && spacesAfter < 5 && offset < line.length()) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + markerInfo.getMarkerIndent() + 1, markerInfo.getMarkerType(), true, Math.min(offset, markerEndOffset + 1));
        }
        return null;
    }

    private final MarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length() || line.charAt(offset) != Companion.getBQ_CHAR()) {
            return null;
        }
        int spacesAfter = 0;
        if (++offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                ++offset;
            }
        }
        return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + 1 + spacesAfter, MarkdownConstraints.Companion.getBQ_CHAR(), true, offset);
    }

    @NotNull
    public String toString() {
        return "MdConstraints: " + StringsKt.String((char[])this.types) + "(" + this.getIndent() + ")";
    }

    protected MarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000e\u0015\u0001Q!\u0001\u0005\u0007\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011-Aa\u0011\u0003\r\u0001e\t\u0001\u0014AQ\u000f\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015&AaQ\u0004\t\u00105\t\u00014AS\u0005\t\r;\u0001\u0002C\u0007\u00021\u000b)K\u0001B\"\b\u0011#i\u0011\u0001g\u0002&(\u0011\u00195\u0001C\u0005\u000e\u0003a\u0001\u0011\u0004\u0002\u0003\u0002\u0011\u0005i\u0011\u0001g\u0001\u001a\t\u0011\t\u0001BA\u0007\u00021\u000bIB\u0001B\u0001\t\u00075\t\u0001tA\u0015\u000b\t\rC\u0001bA\u0007\u00021\u000f\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0002\u0005\u0007S)!1\t\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\u000f\u0001"}, strings={"Lorg/intellij/markdown/parser/constraints/MarkdownConstraints$ListMarkerInfo;", "", "markerText", "", "markerType", "", "markerIndent", "", "(Ljava/lang/CharSequence;CI)V", "getMarkerIndent", "()I", "getMarkerText", "()Ljava/lang/CharSequence;", "getMarkerType", "()C", "component1", "component2", "component3", "copy"}, moduleName="intellij-markdown")
    public static final class ListMarkerInfo {
        @NotNull
        private final CharSequence markerText;
        private final char markerType;
        private final int markerIndent;

        @NotNull
        public final CharSequence getMarkerText() {
            return this.markerText;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        public ListMarkerInfo(@NotNull CharSequence markerText, char markerType, int markerIndent) {
            Intrinsics.checkParameterIsNotNull((Object)markerText, (String)"markerText");
            this.markerText = markerText;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        @NotNull
        public final CharSequence component1() {
            return this.markerText;
        }

        public final char component2() {
            return this.markerType;
        }

        public final int component3() {
            return this.markerIndent;
        }

        @NotNull
        public final ListMarkerInfo copy(@NotNull CharSequence markerText, char markerType, int markerIndent) {
            Intrinsics.checkParameterIsNotNull((Object)markerText, (String)"markerText");
            return new ListMarkerInfo(markerText, markerType, markerIndent);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ListMarkerInfo copy$default(ListMarkerInfo listMarkerInfo, CharSequence charSequence, char c, int n, int n2) {
            if ((n2 & 1) != 0) {
                charSequence = listMarkerInfo.markerText;
            }
            if ((n2 & 2) != 0) {
                c = listMarkerInfo.markerType;
            }
            if ((n2 & 4) != 0) {
                n = listMarkerInfo.markerIndent;
            }
            return listMarkerInfo.copy(charSequence, c, n);
        }

        public String toString() {
            return "ListMarkerInfo(markerText=" + this.markerText + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ")";
        }

        public int hashCode() {
            CharSequence charSequence = this.markerText;
            return ((charSequence != null ? charSequence.hashCode() : 0) * 31 + this.markerType) * 31 + this.markerIndent;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListMarkerInfo)) break block3;
                    ListMarkerInfo listMarkerInfo = (ListMarkerInfo)object;
                    if (!Intrinsics.areEqual((Object)this.markerText, (Object)listMarkerInfo.markerText) || !(this.markerType == listMarkerInfo.markerType) || !(this.markerIndent == listMarkerInfo.markerIndent)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aa!B\u0001\u0005\u0006\u0015\t\u0001\u0002B\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0003\u0011\rQ!\u0001\u0005\b\u000b\u0005!!!B\u0001\r\u0003\u0015\tA\"\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0004B\u0001\t\f5\t\u0001DA\r\u0004\u0011\u0019i\u0011\u0001\u0007\u0002\u001a\u0007!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\te\u0019\u0001\u0002C\u0007\u00021#I2\u0001C\u0005\u000e\u0003a9Qe\u0004E\n\u001b\u0005A\"!G\u0002\t\u00155\t\u0001TC\r\u0004\u0011-i\u0011\u0001G\u0004\u001a\u0007!]Q\"\u0001\r\u0003K5AA\"D\u0001\u0019\u0005e)\u0001\u0012D\u0007\u000415I\u0013\u0001g\u0007\u001a\u0007!]Q\"\u0001\r\u0003S-!1\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0006!\u0019\u0011v\u0003\u0003D\u0011\u0006A9!D\u0001\u0019\tE\u001bQ!B\u0001\r\u00025\u0011A\u0011\u0002\u0005\u0006"}, strings={"Lorg/intellij/markdown/parser/constraints/MarkdownConstraints$Companion;", "", "()V", "BASE", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getBASE", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "BQ_CHAR", "", "getBQ_CHAR", "()C", "MarkdownConstraints", "parent", "newIndentDelta", "", "newType", "newExplicit", "", "newOffset", "fillFromPrevious", "line", "", "startOffset", "prevLineConstraints", "fromBase", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final MarkdownConstraints getBASE() {
            return BASE;
        }

        public final char getBQ_CHAR() {
            return BQ_CHAR;
        }

        private final MarkdownConstraints MarkdownConstraints(MarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] _indents = new int[n + 1];
            char[] _types = new char[n + 1];
            boolean[] _isExplicit = new boolean[n + 1];
            System.arraycopy(parent.indents, 0, _indents, 0, n);
            System.arraycopy(parent.types, 0, _types, 0, n);
            System.arraycopy(parent.isExplicit, 0, _isExplicit, 0, n);
            _indents[n] = parent.getIndent() + newIndentDelta;
            _types[n] = newType;
            _isExplicit[n] = newExplicit;
            return parent.createNewConstraints(_indents, _types, _isExplicit, newOffset);
        }

        @NotNull
        public final MarkdownConstraints fromBase(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints prevLineConstraints) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
            String line = pos.getCurrentLine();
            MarkdownConstraints result = this.fillFromPrevious(line, 0, prevLineConstraints);
            while (true) {
                int offset;
                if (result.addModifierIfNeeded(pos.nextPosition(1 + (offset = result.getCharsEaten(line)))) != null) continue;
                break;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MarkdownConstraints fillFromPrevious(@NotNull String line, int startOffset, @NotNull MarkdownConstraints prevLineConstraints) {
            void indexPrev;
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            int prevN = prevLineConstraints.indents.length;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Function1 getBlockQuoteIndent2 = (Function1)new Function1<Integer, Integer>(line){
                final /* synthetic */ String $line;

                @Nullable
                public final Integer invoke(int startOffset) {
                    int blockQuoteIndent;
                    int offset = startOffset;
                    for (blockQuoteIndent = 0; blockQuoteIndent < 3 && offset < this.$line.length() && this.$line.charAt(offset) == ' '; ++blockQuoteIndent, ++offset) {
                    }
                    return offset < this.$line.length() && this.$line.charAt(offset) == MarkdownConstraints.Companion.getBQ_CHAR() ? Integer.valueOf(blockQuoteIndent + 1) : (Integer)null;
                }
                {
                    this.$line = string;
                    super(1);
                }
            };
            Function1 fillMaybeBlockquoteAndListIndents2 = (Function1)new Function1<MarkdownConstraints, MarkdownConstraints>((Ref.IntRef)indexPrev, prevN, startOffset, line, prevLineConstraints, getBlockQuoteIndent2){
                final /* synthetic */ Ref.IntRef $indexPrev;
                final /* synthetic */ int $prevN;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ String $line;
                final /* synthetic */ MarkdownConstraints $prevLineConstraints;
                final /* synthetic */ Function1 $getBlockQuoteIndent;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final MarkdownConstraints invoke(@NotNull MarkdownConstraints constraints) {
                    int n;
                    int bonusForTheBlockquote;
                    int deltaIndent;
                    Integer bqIndent;
                    void offset;
                    void spacesSeen;
                    Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
                    if (this.$indexPrev.element >= this.$prevN) {
                        return constraints;
                    }
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = this.$startOffset + constraints.getCharsEaten(this.$line);
                    Ref.IntRef intRef2 = new Ref.IntRef();
                    intRef2.element = 0;
                    Function1 hasKMoreSpaces2 = (Function1)new Function1<Integer, Boolean>(this, (Ref.IntRef)spacesSeen, (Ref.IntRef)offset){
                        final /* synthetic */ fillFromPrevious.fillMaybeBlockquoteAndListIndents.1 this$0;
                        final /* synthetic */ Ref.IntRef $spacesSeen;
                        final /* synthetic */ Ref.IntRef $offset;

                        public final boolean invoke(int k) {
                            boolean bl;
                            int oldSpacesSeen = this.$spacesSeen.element;
                            int oldOffset = this.$offset.element;
                            block4: while (this.$spacesSeen.element < k && this.$offset.element < this.this$0.$line.length()) {
                                switch (this.this$0.$line.charAt(this.$offset.element)) {
                                    case ' ': {
                                        int n = this.$spacesSeen.element++;
                                        break;
                                    }
                                    case '\t': {
                                        this.$spacesSeen.element += 4 - this.$spacesSeen.element % 4;
                                        break;
                                    }
                                    default: {
                                        break block4;
                                    }
                                }
                                int n = this.$offset.element++;
                            }
                            if (this.$offset.element == this.this$0.$line.length()) {
                                this.$spacesSeen.element = Integer.MAX_VALUE;
                            }
                            if (k <= this.$spacesSeen.element) {
                                this.$spacesSeen.element -= k;
                                bl = true;
                            } else {
                                this.$offset.element = oldOffset;
                                this.$spacesSeen.element = oldSpacesSeen;
                                bl = false;
                            }
                            return bl;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$spacesSeen = intRef;
                            this.$offset = intRef2;
                            super(1);
                        }
                    };
                    if (MarkdownConstraints.access$getTypes$p(this.$prevLineConstraints)[this.$indexPrev.element] == MarkdownConstraints.Companion.getBQ_CHAR()) {
                        Integer n2 = (Integer)this.$getBlockQuoteIndent.invoke((Object)offset.element);
                        if (n2 == null) {
                            return constraints;
                        }
                        bqIndent = ((Number)n2).intValue();
                        offset.element += ((Number)bqIndent).intValue();
                        int n3 = this.$indexPrev.element++;
                    } else {
                        bqIndent = null;
                    }
                    int oldIndexPrev = this.$indexPrev.element;
                    while (this.$indexPrev.element < this.$prevN && MarkdownConstraints.access$getTypes$p(this.$prevLineConstraints)[this.$indexPrev.element] != MarkdownConstraints.Companion.getBQ_CHAR() && ((Boolean)hasKMoreSpaces2.invoke((Object)(deltaIndent = MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[this.$indexPrev.element] - (this.$indexPrev.element == 0 ? 0 : MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[this.$indexPrev.element - 1])))).booleanValue()) {
                        int n4 = this.$indexPrev.element++;
                    }
                    MarkdownConstraints result = constraints;
                    if (bqIndent != null) {
                        bonusForTheBlockquote = (Boolean)hasKMoreSpaces2.invoke((Object)1) != false ? 1 : 0;
                        result = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.access$MarkdownConstraints(MarkdownConstraints.Companion, result, ((Number)bqIndent).intValue() + bonusForTheBlockquote, MarkdownConstraints.Companion.getBQ_CHAR(), true, offset.element);
                    }
                    if ((bonusForTheBlockquote = oldIndexPrev) <= (n = this.$indexPrev.element - 1)) {
                        while (true) {
                            void index;
                            int deltaIndent2 = MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[index] - (index == false ? 0 : MarkdownConstraints.access$getIndents$p(this.$prevLineConstraints)[index - true]);
                            result = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.access$MarkdownConstraints(MarkdownConstraints.Companion, result, deltaIndent2, MarkdownConstraints.access$getTypes$p(this.$prevLineConstraints)[index], false, offset.element);
                            if (index == n) break;
                            ++index;
                        }
                    }
                    return result;
                }
                {
                    this.$indexPrev = intRef;
                    this.$prevN = n;
                    this.$startOffset = n2;
                    this.$line = string;
                    this.$prevLineConstraints = markdownConstraints;
                    this.$getBlockQuoteIndent = function1;
                    super(1);
                }
            };
            MarkdownConstraints result = prevLineConstraints.getBase();
            MarkdownConstraints nextConstraints;
            while (!Intrinsics.areEqual((Object)(nextConstraints = (MarkdownConstraints)fillMaybeBlockquoteAndListIndents2.invoke((Object)result)), (Object)result)) {
                result = nextConstraints;
            }
            return result;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

