/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

public class Call {
    private final long mMethodId;
    private final int mEntryThreadTime;
    private final int mEntryGlobalTime;
    private final int mExitGlobalTime;
    private final int mExitThreadTime;
    private final long mInclusiveThreadTimeInCallees;
    private final long mInclusiveGlobalTimeInCallees;
    private final int mDepth;
    private final boolean mIsRecursive;
    private final List<Call> mCallees;
    private static final Formatter METHOD_ID_FORMATTER = new Formatter(){

        @Override
        public String format(Call c) {
            return Long.toString(c.getMethodId());
        }
    };

    private Call(@NonNull Builder builder, @NonNull Stack<Long> backStack) {
        this.mMethodId = builder.mMethodId;
        this.mEntryThreadTime = builder.mEntryThreadTime;
        this.mEntryGlobalTime = builder.mEntryGlobalTime;
        this.mExitThreadTime = builder.mExitThreadTime;
        this.mExitGlobalTime = builder.mExitGlobalTime;
        this.mDepth = backStack.size();
        this.mIsRecursive = backStack.contains(this.mMethodId);
        if (builder.mCallees == null) {
            this.mCallees = Collections.emptyList();
        } else {
            backStack.push(this.mMethodId);
            ArrayList<Call> callees = new ArrayList<Call>(builder.mCallees.size());
            for (Builder b : builder.mCallees) {
                callees.add(b.build(backStack));
            }
            backStack.pop();
            this.mCallees = new ImmutableList.Builder().addAll(callees).build();
        }
        this.mInclusiveThreadTimeInCallees = this.sumInclusiveTimes(this.mCallees, ClockType.THREAD);
        this.mInclusiveGlobalTimeInCallees = this.sumInclusiveTimes(this.mCallees, ClockType.GLOBAL);
    }

    private long sumInclusiveTimes(@NonNull List<Call> callees, ClockType clockType) {
        long sum = 0L;
        for (Call c : callees) {
            sum += c.getInclusiveTime(clockType, TimeUnit.MICROSECONDS);
        }
        return sum;
    }

    public long getMethodId() {
        return this.mMethodId;
    }

    @NonNull
    public List<Call> getCallees() {
        return this.mCallees;
    }

    public int getDepth() {
        return this.mDepth;
    }

    public boolean isRecursive() {
        return this.mIsRecursive;
    }

    public long getEntryTime(ClockType clockType, TimeUnit units) {
        long entryTime = clockType == ClockType.THREAD ? UnsignedInts.toLong((int)this.mEntryThreadTime) : UnsignedInts.toLong((int)this.mEntryGlobalTime);
        return units.convert(entryTime, VmTraceData.getDefaultTimeUnits());
    }

    public long getExitTime(ClockType clockType, TimeUnit units) {
        long exitTime = clockType == ClockType.THREAD ? UnsignedInts.toLong((int)this.mExitThreadTime) : UnsignedInts.toLong((int)this.mExitGlobalTime);
        return units.convert(exitTime, VmTraceData.getDefaultTimeUnits());
    }

    public long getInclusiveTime(ClockType clockType, TimeUnit units) {
        long inclusiveTime = clockType == ClockType.THREAD ? UnsignedInts.toLong((int)(this.mExitThreadTime - this.mEntryThreadTime)) : UnsignedInts.toLong((int)(this.mExitGlobalTime - this.mEntryGlobalTime));
        return units.convert(inclusiveTime, VmTraceData.getDefaultTimeUnits());
    }

    public long getExclusiveTime(ClockType clockType, TimeUnit units) {
        long inclusiveTimeInCallees = clockType == ClockType.THREAD ? this.mInclusiveThreadTimeInCallees : this.mInclusiveGlobalTimeInCallees;
        long exclusiveTime = this.getInclusiveTime(clockType, VmTraceData.getDefaultTimeUnits()) - inclusiveTimeInCallees;
        return units.convert(exclusiveTime, VmTraceData.getDefaultTimeUnits());
    }

    public String format(Formatter f) {
        StringBuilder sb = new StringBuilder(100);
        this.printCallHierarchy(sb, f);
        return sb.toString();
    }

    public String toString() {
        return this.format(METHOD_ID_FORMATTER);
    }

    private void printCallHierarchy(@NonNull StringBuilder sb, Formatter formatter) {
        sb.append(" -> ");
        sb.append(formatter.format(this));
        List<Call> callees = this.getCallees();
        int lineStart = sb.lastIndexOf("\n");
        int depth = sb.length() - (lineStart + 1);
        for (int i = 0; i < callees.size(); ++i) {
            if (i != 0) {
                sb.append("\n");
                sb.append(Strings.repeat((String)" ", (int)depth));
            }
            Call callee = callees.get(i);
            callee.printCallHierarchy(sb, formatter);
        }
    }

    @NonNull
    public Iterator<Call> getCallHierarchyIterator() {
        return new CallHierarchyIterator(this);
    }

    private static class CallHierarchyIterator
    implements Iterator<Call> {
        private final Stack<Call> mCallStack = new Stack();

        public CallHierarchyIterator(@NonNull Call top) {
            this.mCallStack.push(top);
        }

        @Override
        public boolean hasNext() {
            return !this.mCallStack.isEmpty();
        }

        @Override
        public Call next() {
            if (this.mCallStack.isEmpty()) {
                return null;
            }
            Call top = this.mCallStack.pop();
            for (int i = top.getCallees().size() - 1; i >= 0; --i) {
                this.mCallStack.push(top.getCallees().get(i));
            }
            return top;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Formatter {
        public String format(Call var1);
    }

    public static class Builder {
        private final long mMethodId;
        private int mEntryThreadTime;
        private int mEntryGlobalTime;
        private int mExitGlobalTime;
        private int mExitThreadTime;
        private List<Builder> mCallees = null;

        public Builder(long methodId) {
            this.mMethodId = methodId;
        }

        public long getMethodId() {
            return this.mMethodId;
        }

        public void setMethodEntryTime(int threadTime, int globalTime) {
            this.mEntryThreadTime = threadTime;
            this.mEntryGlobalTime = globalTime;
        }

        public void setMethodExitTime(int threadTime, int globalTime) {
            this.mExitThreadTime = threadTime;
            this.mExitGlobalTime = globalTime;
        }

        public void addCallee(Builder c) {
            if (this.mCallees == null) {
                this.mCallees = new ArrayList<Builder>();
            }
            this.mCallees.add(c);
        }

        @Nullable
        public List<Builder> getCallees() {
            return this.mCallees;
        }

        public int getMethodEntryThreadTime() {
            return this.mEntryThreadTime;
        }

        public int getMethodEntryGlobalTime() {
            return this.mEntryGlobalTime;
        }

        public int getMethodExitThreadTime() {
            return this.mExitThreadTime;
        }

        public int getMethodExitGlobalTime() {
            return this.mExitGlobalTime;
        }

        @NonNull
        public Call build(@NonNull Stack<Long> backStack) {
            return new Call(this, backStack);
        }
    }
}

