/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathString;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;

public class XPathStringImpl
extends XPathElementImpl
implements XPathString {
    public XPathStringImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathType xPathType = XPathType.STRING;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathStringImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    public boolean isWellFormed() {
        char quoteChar;
        String text = this.getUnescapedText();
        if (!text.endsWith(String.valueOf(quoteChar = this.getQuoteChar())) || text.indexOf(quoteChar) == text.lastIndexOf(quoteChar)) {
            return false;
        }
        if (this.getXPathVersion() == XPathVersion.V2) {
            String value = this.getStringBetweenQuotes();
            String unescaped = XPathStringImpl.unescape(quoteChar, value);
            return XPathStringImpl.escape(quoteChar, unescaped).equals(value);
        }
        if (this.getValue().indexOf(quoteChar) != -1) {
            return false;
        }
        return !this.textContains('\n') && !this.textContains('\r');
    }

    @Override
    public String getValue() {
        String value = this.getStringBetweenQuotes();
        if (this.getXPathVersion() == XPathVersion.V2) {
            return XPathStringImpl.unescape(this.getQuoteChar(), value);
        }
        return value;
    }

    private String getStringBetweenQuotes() {
        String text = this.getUnescapedText();
        if (text.endsWith(String.valueOf(this.getQuoteChar())) && text.length() > 1) {
            return text.substring(1, text.length() - 1);
        }
        return text.substring(1, text.length());
    }

    private char getQuoteChar() {
        return this.getUnescapedText().charAt(0);
    }

    private static String unescape(char quote, String value) {
        String singleQuote = String.valueOf(quote);
        String escapedQuote = singleQuote + quote;
        return value.replaceAll(escapedQuote, singleQuote);
    }

    private static String escape(char quote, String value) {
        String singleQuote = String.valueOf(quote);
        String escapedQuote = singleQuote + quote;
        return value.replaceAll(singleQuote, escapedQuote);
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathString(this);
    }
}

