/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.xpathView.util.Copyable;

public final class Namespace
implements Cloneable,
Copyable<Namespace> {
    public String prefix;
    public final String uri;

    public Namespace(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return !(this.uri == null ? namespace.uri != null : !this.uri.equals(namespace.uri));
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }

    protected Namespace clone() {
        try {
            return (Namespace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    @Override
    public Namespace copy() {
        return this.clone();
    }

    public static Collection<Namespace> fromMap(Map<String, String> namespaces) {
        ArrayList<Namespace> list = new ArrayList<Namespace>(namespaces.size());
        for (Map.Entry<String, String> e : namespaces.entrySet()) {
            list.add(new Namespace(e.getKey(), e.getValue()));
        }
        return list;
    }

    public static Map<String, String> makeMap(Collection<Namespace> namespaces) {
        HashMap<String, String> _ns = new HashMap<String, String>();
        for (Namespace namespace : namespaces) {
            _ns.put(namespace.getPrefix(), namespace.getUri());
        }
        return _ns;
    }
}

