/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.psi.PsiElement;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction<T extends PsiElement>
extends AnAction {
    private final LineMarkerInfo<T> myInfo;

    public NavigateAction(@NotNull String text, @NotNull LineMarkerInfo<T> info, @Nullable String originalActionId) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/NavigateAction", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/NavigateAction", "<init>"));
        }
        super(text);
        this.myInfo = info;
        if (originalActionId != null) {
            ShortcutSet set = ActionManager.getInstance().getAction(originalActionId).getShortcutSet();
            this.setShortcutSet(set);
        }
    }

    public NavigateAction(@NotNull LineMarkerInfo<T> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/NavigateAction", "<init>"));
        }
        this.myInfo = info;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        if (this.myInfo.getNavigationHandler() != null) {
            MouseEvent mouseEvent = (MouseEvent)e.getInputEvent();
            T element = this.myInfo.getElement();
            if (element == null || !element.isValid()) {
                return;
            }
            this.myInfo.getNavigationHandler().navigate(mouseEvent, element);
        }
    }

    @NotNull
    public static <T extends PsiElement> LineMarkerInfo<T> setNavigateAction(@NotNull LineMarkerInfo<T> info, @NotNull String text, @Nullable String originalActionId) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/NavigateAction", "setNavigateAction"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/NavigateAction", "setNavigateAction"));
        }
        NavigateAction<T> action = new NavigateAction<T>(text, info, originalActionId);
        info.setNavigateAction(action);
        LineMarkerInfo<T> lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/NavigateAction", "setNavigateAction"));
        }
        return lineMarkerInfo;
    }
}

