/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.CaretSpecificDataContext;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorActionHandler {
    private final boolean myRunForEachCaret;
    private boolean myWorksInInjected;
    private boolean inExecution;
    private boolean inCheck;

    protected EditorActionHandler() {
        this(false);
    }

    protected EditorActionHandler(boolean runForEachCaret) {
        this.myRunForEachCaret = runForEachCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(Editor editor, final DataContext dataContext) {
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            Editor hostEditor;
            if (editor == null) {
                boolean bl = false;
                return bl;
            }
            Editor editor2 = hostEditor = dataContext == null ? null : CommonDataKeys.HOST_EDITOR.getData(dataContext);
            if (hostEditor == null) {
                hostEditor = editor;
            }
            final boolean[] result = new boolean[1];
            final CaretTask check = new CaretTask(){

                @Override
                public void perform(@NotNull Caret caret, @Nullable DataContext dataContext) {
                    if (caret == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actionSystem/EditorActionHandler$1", "perform"));
                    }
                    result[0] = true;
                }
            };
            if (this.myRunForEachCaret) {
                hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

                    @Override
                    public void perform(Caret caret) {
                        EditorActionHandler.this.doIfEnabled(caret, dataContext, check);
                    }
                });
            } else {
                this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, check);
            }
            boolean bl = result[0];
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    private void doIfEnabled(@NotNull Caret hostCaret, @Nullable DataContext context, @NotNull CaretTask task) {
        DataContext injectedCaretContext;
        Caret injectedCaret;
        CaretSpecificDataContext caretContext;
        if (hostCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostCaret", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "doIfEnabled"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "doIfEnabled"));
        }
        CaretSpecificDataContext caretSpecificDataContext = caretContext = context == null ? null : new CaretSpecificDataContext(context, hostCaret);
        if (this.myWorksInInjected && caretContext != null && (injectedCaret = CommonDataKeys.CARET.getData(injectedCaretContext = AnActionEvent.getInjectedDataContext(caretContext))) != null && injectedCaret != hostCaret && this.isEnabledForCaret(injectedCaret.getEditor(), injectedCaret, injectedCaretContext)) {
            task.perform(injectedCaret, injectedCaretContext);
            return;
        }
        if (this.isEnabledForCaret(hostCaret.getEditor(), hostCaret, caretContext)) {
            task.perform(hostCaret, caretContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "isEnabledForCaret"));
        }
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            boolean bl = this.isEnabled(editor, dataContext);
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    public final boolean isEnabled(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "isEnabled"));
        }
        return caret == null ? this.isEnabled(editor, dataContext) : this.isEnabledForCaret(editor, caret, dataContext);
    }

    public void execute(Editor editor, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    public boolean executeInCommand(Editor editor, DataContext dataContext) {
        return true;
    }

    public boolean runForAllCarets() {
        return this.myRunForEachCaret;
    }

    public final void execute(@NotNull Editor editor, @Nullable Caret contextCaret, final DataContext dataContext) {
        Editor hostEditor;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "execute"));
        }
        Editor editor2 = hostEditor = dataContext == null ? null : CommonDataKeys.HOST_EDITOR.getData(dataContext);
        if (hostEditor == null) {
            hostEditor = editor;
        }
        if (contextCaret == null && this.runForAllCarets()) {
            hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

                @Override
                public void perform(Caret caret) {
                    EditorActionHandler.this.doIfEnabled(caret, dataContext, new CaretTask(){

                        @Override
                        public void perform(@NotNull Caret caret, @Nullable DataContext dataContext) {
                            if (caret == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actionSystem/EditorActionHandler$3$1", "perform"));
                            }
                            EditorActionHandler.this.doExecute(caret.getEditor(), caret, dataContext);
                        }
                    });
                }
            });
        } else if (contextCaret == null) {
            this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, new CaretTask(){

                @Override
                public void perform(@NotNull Caret caret, @Nullable DataContext dataContext) {
                    if (caret == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actionSystem/EditorActionHandler$4", "perform"));
                    }
                    EditorActionHandler.this.doExecute(caret.getEditor(), null, dataContext);
                }
            });
        } else {
            this.doExecute(editor, contextCaret, dataContext);
        }
    }

    void setWorksInInjected(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public DocCommandGroupId getCommandGroupId(Editor editor) {
        return DocCommandGroupId.noneGroupId(editor.getDocument());
    }

    private static interface CaretTask {
        public void perform(@NotNull Caret var1, @Nullable DataContext var2);
    }
}

