/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class AnnotatedPackagesSearch
extends ExtensibleQueryFactory<PsiPackage, Parameters> {
    public static final AnnotatedPackagesSearch INSTANCE = new AnnotatedPackagesSearch();

    private AnnotatedPackagesSearch() {
    }

    public static Query<PsiPackage> search(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedPackagesSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedPackagesSearch", "search"));
        }
        return INSTANCE.createQuery(new Parameters(annotationClass, scope));
    }

    public static Query<PsiPackage> search(@NotNull PsiClass annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedPackagesSearch", "search"));
        }
        return AnnotatedPackagesSearch.search(annotationClass, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(annotationClass)));
    }

    public static class Parameters {
        private final PsiClass myAnnotationClass;
        private final SearchScope myScope;

        public Parameters(PsiClass annotationClass, SearchScope scope) {
            this.myAnnotationClass = annotationClass;
            this.myScope = scope;
        }

        public PsiClass getAnnotationClass() {
            return this.myAnnotationClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

