/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementContainer;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementParameterizedCreator;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementContainerEx;

public class JpsElementContainerImpl
extends JpsElementContainerEx
implements JpsElementContainer {
    private final Map<JpsElementChildRole<?>, JpsElement> myElements;
    @NotNull
    private final JpsCompositeElementBase<?> myParent;

    public JpsElementContainerImpl(@NotNull JpsCompositeElementBase<?> parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "<init>"));
        }
        this.myElements = new THashMap(1);
        this.myParent = parent;
    }

    public JpsElementContainerImpl(@NotNull JpsElementContainerEx original, @NotNull JpsCompositeElementBase<?> parent) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "<init>"));
        }
        this.myElements = new THashMap(1);
        this.myParent = parent;
        for (Map.Entry entry : original.getElementsMap().entrySet()) {
            JpsElementChildRole role = (JpsElementChildRole)entry.getKey();
            JpsElement copy = ((JpsElement)entry.getValue()).getBulkModificationSupport().createCopy();
            JpsElementBase.setParent((JpsElement)copy, this.myParent);
            this.myElements.put(role, copy);
        }
    }

    public <T extends JpsElement> T getChild(@NotNull JpsElementChildRole<T> role) {
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "getChild"));
        }
        return (T)this.myElements.get(role);
    }

    @NotNull
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T setChild(@NotNull K role, @NotNull P param) {
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "setChild"));
        }
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "setChild"));
        }
        JpsElement child = ((JpsElementParameterizedCreator)role).create(param);
        JpsElement jpsElement = this.setChild(role, child);
        if (jpsElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "setChild"));
        }
        return (T)jpsElement;
    }

    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T setChild(@NotNull K role) {
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "setChild"));
        }
        JpsElement child = ((JpsElementCreator)role).create();
        JpsElement jpsElement = this.setChild(role, child);
        if (jpsElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "setChild"));
        }
        return (T)jpsElement;
    }

    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role) {
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "getOrSetChild"));
        }
        T child = this.getChild(role);
        if (child == null) {
            T t = this.setChild(role);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "getOrSetChild"));
            }
            return t;
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "getOrSetChild"));
        }
        return t;
    }

    public <T extends JpsElement> T setChild(JpsElementChildRole<T> role, T child) {
        this.myElements.put(role, child);
        JpsElementBase.setParent(child, this.myParent);
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementAdded(child, role);
        }
        return child;
    }

    public <T extends JpsElement> void removeChild(@NotNull JpsElementChildRole<T> role) {
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "removeChild"));
        }
        JpsElement removed = this.myElements.remove(role);
        if (removed == null) {
            return;
        }
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementRemoved(removed, role);
        }
        JpsElementBase.setParent((JpsElement)removed, null);
    }

    protected Map<JpsElementChildRole<?>, JpsElement> getElementsMap() {
        return this.myElements;
    }

    public void applyChanges(@NotNull JpsElementContainerEx modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/model/ex/JpsElementContainerImpl", "applyChanges"));
        }
        for (JpsElementChildRole<?> jpsElementChildRole : this.myElements.keySet()) {
            this.applyChanges(jpsElementChildRole, modified);
        }
        for (JpsElementChildRole jpsElementChildRole : modified.getElementsMap().keySet()) {
            if (this.myElements.containsKey(jpsElementChildRole)) continue;
            this.applyChanges(jpsElementChildRole, modified);
        }
    }

    private <T extends JpsElement> void applyChanges(JpsElementChildRole<T> role, JpsElementContainerEx modified) {
        T child = this.getChild(role);
        JpsElement modifiedChild = modified.getChild(role);
        if (child != null && modifiedChild != null) {
            JpsElement.BulkModificationSupport modificationSupport = child.getBulkModificationSupport();
            modificationSupport.applyChanges(modifiedChild);
        } else if (modifiedChild == null) {
            this.removeChild(role);
        } else {
            this.setChild(role, modifiedChild.getBulkModificationSupport().createCopy());
        }
    }

    @Nullable
    private JpsEventDispatcher getEventDispatcher() {
        return this.myParent.getEventDispatcher();
    }
}

