/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.AnnotateTask;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class AndroidInferNullityAnnotationAction
extends InferNullityAnnotationsAction {
    private static final Logger LOG = Logger.getInstance(AndroidInferNullityAnnotationAction.class);
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "analyze"));
        }
        if (!Projects.isBuildWithGradle(project)) {
            super.analyze(project, scope);
            return;
        }
        int[] fileCount = new int[]{0};
        Map<Module, PsiFile> modules = AndroidInferNullityAnnotationAction.findModulesInScope(project, scope, fileCount);
        if (modules == null) {
            return;
        }
        if (!this.checkModules(project, scope, modules)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final UsageInfo[] usageInfos = AndroidInferNullityAnnotationAction.findUsages(project, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        if (usageInfos.length < 5) {
            SwingUtilities.invokeLater(AndroidInferNullityAnnotationAction.applyRunnable(project, new Computable<UsageInfo[]>(){

                public UsageInfo[] compute() {
                    return usageInfos;
                }
            }));
        } else {
            this.showUsageView(project, usageInfos, scope);
        }
    }

    private static Map<Module, PsiFile> findModulesInScope(final @NotNull Project project, final @NotNull AnalysisScope scope, final @NotNull int[] fileCount) {
        HashMap<Module, PsiFile> modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "findModulesInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "findModulesInScope"));
        }
        if (fileCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileCount", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "findModulesInScope"));
        }
        final ProgressManager progressManager = ProgressManager.getInstance();
        boolean completed = progressManager.runProcessWithProgressSynchronously(new Runnable(modules = new HashMap<Module, PsiFile>()){
            final /* synthetic */ Map val$modules;
            {
                this.val$modules = map;
            }

            @Override
            public void run() {
                scope.accept(new PsiElementVisitor(){

                    public void visitFile(PsiFile file) {
                        Module module;
                        fileCount[0] = fileCount[0] + 1;
                        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                        if (progressIndicator != null) {
                            VirtualFile virtualFile = file.getVirtualFile();
                            if (virtualFile != null) {
                                progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                            }
                            progressIndicator.setText(AnalysisScopeBundle.message((String)"scanning.scope.progress.title", (Object[])new Object[0]));
                        }
                        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null && !val$modules.containsKey(module)) {
                            val$modules.put(module, file);
                        }
                    }
                });
            }
        }, "Check applicability...", true, project);
        return completed ? modules : null;
    }

    private static UsageInfo[] findUsages(final @NotNull Project project, final @NotNull AnalysisScope scope, final int fileCount) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "findUsages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "findUsages"));
        }
        final NullityInferrer inferrer = new NullityInferrer(false, project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        Runnable searchForUsages = new Runnable(){

            @Override
            public void run() {
                scope.accept(new PsiElementVisitor(){
                    int myFileCount = 0;

                    public void visitFile(PsiFile file) {
                        Document document;
                        ++this.myFileCount;
                        VirtualFile virtualFile = file.getVirtualFile();
                        FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                        Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                        if (document == null || virtualFile.getFileType().isBinary()) {
                            return;
                        }
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                            progressIndicator.setFraction((double)this.myFileCount / (double)fileCount);
                        }
                        if (file instanceof PsiJavaFile) {
                            inferrer.collect(file);
                        }
                    }
                });
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(searchForUsages, INFER_NULLITY_ANNOTATIONS, true, project)) {
                return null;
            }
        } else {
            searchForUsages.run();
        }
        ArrayList usages = new ArrayList();
        inferrer.collect(usages);
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(final @NotNull Project project, @NotNull AnalysisScope scope, @NotNull Map<Module, PsiFile> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "checkModules"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "checkModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "checkModules"));
        }
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        final String libraryCoordinate = manager.getLibraryCoordinate("support-annotations");
        final HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module : modules.keySet()) {
            GradleBuildFile gradleBuildFile;
            AndroidModuleInfo info = AndroidModuleInfo.get(module);
            if (info != null && info.getBuildSdkVersion() != null && info.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module);
            }
            if ((gradleBuildFile = GradleBuildFile.get(module)) == null) {
                LOG.warn("Unable to find Gradle build file for module " + module.getModuleFilePath());
                continue;
            }
            boolean dependencyFound = false;
            for (BuildFileStatement entry : gradleBuildFile.getDependencies()) {
                if (!(entry instanceof Dependency)) continue;
                Dependency dependency = (Dependency)entry;
                if (dependency.scope != Dependency.Scope.COMPILE || dependency.type != Dependency.Type.EXTERNAL || !dependency.getValueAsString().equals(libraryCoordinate)) continue;
                dependencyFound = true;
                break;
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format("Infer Nullity Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_NULLITY_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return module.getName();
            }
        }, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", "support-annotations", StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction$5", "run"));
                        }
                        for (Module module : modulesWithoutAnnotations) {
                            AndroidInferNullityAnnotationAction.addDependency(module, libraryCoordinate);
                        }
                        GradleProjectImporter.getInstance().requestProjectSync(project, false, null);
                    }
                }.execute();
                this.restartAnalysis(project, scope);
            }
            finally {
                action.finish();
            }
        }
        return true;
    }

    private static Runnable applyRunnable(final Project project, final Computable<UsageInfo[]> computable) {
        return new Runnable(){

            @Override
            public void run() {
                LocalHistoryAction action = LocalHistory.getInstance().startAction(AndroidInferNullityAnnotationAction.INFER_NULLITY_ANNOTATIONS);
                try {
                    new WriteCommandAction(project, AndroidInferNullityAnnotationAction.INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction$6$1", "run"));
                            }
                            UsageInfo[] infos = (UsageInfo[])computable.compute();
                            if (infos.length > 0) {
                                LinkedHashSet elements = new LinkedHashSet();
                                for (UsageInfo info : infos) {
                                    PsiElement element = info.getElement();
                                    if (element == null) continue;
                                    ContainerUtil.addIfNotNull(elements, (Object)element.getContainingFile());
                                }
                                if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                    return;
                                }
                                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, AndroidInferNullityAnnotationAction.INFER_NULLITY_ANNOTATIONS, false);
                                progressTask.setMinIterationTime(200L);
                                progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                                ProgressManager.getInstance().run((Task)progressTask);
                            } else {
                                NullityInferrer.nothingFoundMessage((Project)project);
                            }
                        }
                    }.execute();
                }
                finally {
                    action.finish();
                }
            }
        };
    }

    protected void restartAnalysis(final Project project, final AnalysisScope scope) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                AndroidInferNullityAnnotationAction.this.analyze(project, scope);
            }
        });
    }

    private void showUsageView(@NotNull Project project, final UsageInfo[] usageInfos, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "showUsageView"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "showUsageView"));
        }
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        final Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos));
                    }
                });
            }
        }, "Preprocess usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        final UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, AndroidInferNullityAnnotationAction.rerunFactory(project, scope));
        Runnable refactoringRunnable = AndroidInferNullityAnnotationAction.applyRunnable(project, new Computable<UsageInfo[]>(){

            public UsageInfo[] compute() {
                Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
                return infos.toArray(new UsageInfo[infos.size()]);
            }
        });
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "rerunFactory"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "rerunFactory"));
        }
        Factory<UsageSearcher> factory = new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new UsageInfoSearcherAdapter(){

                    protected UsageInfo[] findUsages() {
                        return AndroidInferNullityAnnotationAction.findUsages(project, scope, scope.getFileCount());
                    }

                    public void generate(@NotNull Processor<Usage> processor) {
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction$10$1", "generate"));
                        }
                        this.processUsages(processor, project);
                    }
                };
            }
        };
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction", "rerunFactory"));
        }
        return factory;
    }

    private static void addDependency(final Module module, final String libraryCoordinate) {
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
                if (gradleBuildFile != null) {
                    List<BuildFileStatement> dependencies = gradleBuildFile.getDependencies();
                    dependencies.add(new Dependency(Dependency.Scope.COMPILE, Dependency.Type.EXTERNAL, libraryCoordinate));
                    gradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
                }
            }
        });
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        if (!Projects.isBuildWithGradle(project)) {
            return super.getAdditionalActionSettings(project, dialog);
        }
        return null;
    }
}

