/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.tables;

import com.android.tools.idea.editors.allocations.ColumnTreeBuilder;
import com.android.tools.idea.editors.hprof.tables.SelectionModel;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Type;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceReferenceTree {
    private static final int MAX_AUTO_EXPANSION_DEPTH = 5;
    private static final SimpleTextAttributes SOFT_REFERENCE_TEXT_ATTRIBUTE = new SimpleTextAttributes(2, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES.getFgColor());
    private static final Comparator<Instance> DEPTH_COMPARATOR = new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            return o1.getDistanceToGcRoot() - o2.getDistanceToGcRoot();
        }
    };
    @NotNull
    private Tree myTree;
    @NotNull
    private JComponent myColumnTree;
    private Instance myInstance;

    public InstanceReferenceTree(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree", "<init>"));
        }
        final TreeBuilder model = new TreeBuilder(null){

            public void buildChildren(TreeBuilderNode node) {
                if (node == this.getRoot()) {
                    node.add((MutableTreeNode)((Object)new InstanceNode(this, InstanceReferenceTree.this.myInstance, new String[0])));
                } else {
                    InstanceReferenceTree.this.addReferences((InstanceNode)node);
                }
                this.nodeChanged((TreeNode)node);
            }

            public boolean isExpandable(TreeBuilderNode node) {
                if (node == this.getRoot()) {
                    return node.getChildCount() > 0;
                }
                Instance instance = (Instance)node.getUserObject();
                return instance.getHardReferences().size() > 0 || instance.getSoftReferences() != null;
            }
        };
        model.setRoot(new TreeBuilderNode(null){

            protected TreeBuilder getTreeBuilder() {
                return model;
            }
        });
        this.myTree = new Tree((TreeModel)model);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){
            private boolean myIsCurrentlyExpanding = false;

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                InstanceNode childNode;
                InstanceNode node;
                if (this.myIsCurrentlyExpanding) {
                    return;
                }
                this.myIsCurrentlyExpanding = true;
                InstanceNode currentNode = node = (InstanceNode)((Object)event.getPath().getLastPathComponent());
                for (int recursiveDepth = 5; currentNode.getChildCount() == 1 && recursiveDepth > 0 && !(childNode = (InstanceNode)((Object)currentNode.getChildAt(0))).isLeaf() && childNode.getInstance().getDistanceToGcRoot() != 0; --recursiveDepth) {
                    currentNode = childNode;
                    Instance currentInstance = currentNode.getInstance();
                    if (currentInstance.getDistanceToGcRoot() != 0) continue;
                    break;
                }
                if (node != currentNode) {
                    InstanceReferenceTree.this.myTree.expandPath(new TreePath(currentNode.getPath()));
                }
                this.myIsCurrentlyExpanding = false;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Reference Tree").setPreferredWidth(1200).setHeaderAlignment(2).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$8", "customizeCellRenderer"));
                }
                if (value instanceof InstanceNode) {
                    InstanceNode node = (InstanceNode)((Object)value);
                    Instance instance = node.getInstance();
                    String[] referenceVarNames = node.getVarNames();
                    if (referenceVarNames.length > 0) {
                        if (instance instanceof ArrayInstance) {
                            this.append(StringUtil.pluralize((String)"Index", (int)referenceVarNames.length), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                            this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append(referenceVarNames[0]);
                        for (int i = 1; i < referenceVarNames.length; ++i) {
                            builder.append(", ");
                            builder.append(referenceVarNames[i]);
                        }
                        this.append(builder.toString(), instance.getIsSoftReference() ? SOFT_REFERENCE_TEXT_ATTRIBUTE : XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        this.append(" in ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                    }
                    SimpleTextAttributes classTextAttributes = InstanceReferenceTree.this.myInstance.getImmediateDominator() == instance ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (instance.getIsSoftReference() ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : (instance.getDistanceToGcRoot() == 0 ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (instance.getImmediateDominator() == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES)));
                    if (instance instanceof ArrayInstance) {
                        this.setIcon(AllIcons.Debugger.Db_array);
                    } else if (instance instanceof ClassObj) {
                        this.setIcon(PlatformIcons.FIELD_ICON);
                    } else {
                        this.setIcon(AllIcons.Debugger.Value);
                    }
                    if (InstanceReferenceTree.this.myInstance.getImmediateDominator() == instance || instance.getDistanceToGcRoot() == 0) {
                        int totalIcons = 1 + (InstanceReferenceTree.this.myInstance.getImmediateDominator() == instance ? 1 : 0) + (instance.getDistanceToGcRoot() == 0 ? 1 : 0);
                        RowIcon icons = new RowIcon(totalIcons);
                        icons.setIcon(this.getIcon(), 0);
                        int currentIcon = 1;
                        if (InstanceReferenceTree.this.myInstance.getImmediateDominator() == instance) {
                            icons.setIcon(AllIcons.Hierarchy.Class, currentIcon++);
                        }
                        if (instance.getDistanceToGcRoot() == 0) {
                            icons.setIcon(AllIcons.Hierarchy.Subtypes, currentIcon);
                        }
                        this.setIcon((Icon)icons);
                    }
                    this.append(instance.toString(), classTextAttributes);
                } else {
                    this.append(value.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Depth").setPreferredWidth(40).setHeaderAlignment(4).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$7", "customizeCellRenderer"));
                }
                if (value instanceof InstanceNode) {
                    Instance instance = ((InstanceNode)((Object)value)).getInstance();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getDistanceToGcRoot()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.setTextAlign(4);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(80).setHeaderAlignment(4).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$6", "customizeCellRenderer"));
                }
                if (value instanceof InstanceNode) {
                    Instance instance = ((InstanceNode)((Object)value)).getInstance();
                    if (instance != null) {
                        this.append(String.valueOf(instance.getSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.setTextAlign(4);
                }
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Dominating Size").setPreferredWidth(80).setHeaderAlignment(4).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$5", "customizeCellRenderer"));
                }
                if (value instanceof InstanceNode) {
                    Instance instance = ((InstanceNode)((Object)value)).getInstance();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getTotalRetainedSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.setTextAlign(4);
                }
            }
        }));
        this.myColumnTree = builder.build();
        selectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(@NotNull Heap heap) {
                if (heap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$9", "onHeapChanged"));
                }
                InstanceReferenceTree.this.clearInstance();
            }

            @Override
            public void onClassObjChanged(@Nullable ClassObj classObj) {
                InstanceReferenceTree.this.clearInstance();
            }

            @Override
            public void onInstanceChanged(@Nullable Instance instance) {
                if (instance == null) {
                    InstanceReferenceTree.this.clearInstance();
                } else {
                    InstanceReferenceTree.this.myInstance = instance;
                    TreeBuilder model = InstanceReferenceTree.this.getMutableModel();
                    TreeBuilderNode root = (TreeBuilderNode)model.getRoot();
                    root.removeAllChildren();
                    root.add((MutableTreeNode)((Object)new InstanceNode(InstanceReferenceTree.this.getMutableModel(), instance, new String[0])));
                    model.nodeStructureChanged((TreeNode)((TreeBuilderNode)model.getRoot()));
                    InstanceReferenceTree.this.myTree.expandRow(0);
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.myColumnTree;
    }

    private void clearInstance() {
        TreeBuilderNode root = (TreeBuilderNode)this.getMutableModel().getRoot();
        root.removeAllChildren();
        this.getMutableModel().nodeStructureChanged((TreeNode)root);
    }

    @NotNull
    private TreeBuilder getMutableModel() {
        TreeBuilder treeBuilder = (TreeBuilder)this.myTree.getModel();
        if (treeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree", "getMutableModel"));
        }
        return treeBuilder;
    }

    private void addReferences(@NotNull InstanceNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree", "addReferences"));
        }
        Instance instance = node.getInstance();
        if (instance instanceof RootObj) {
            return;
        }
        ArrayList sortedReferences = new ArrayList(instance.getHardReferences());
        Collections.sort(sortedReferences, DEPTH_COMPARATOR);
        if (instance.getSoftReferences() != null) {
            ArrayList sortedSoftReferences = new ArrayList(instance.getSoftReferences());
            Collections.sort(sortedSoftReferences, DEPTH_COMPARATOR);
            sortedReferences.addAll(sortedSoftReferences);
        }
        for (Instance reference : sortedReferences) {
            ArrayList<String> scratchList = new ArrayList<String>(3);
            if (reference instanceof ClassInstance) {
                ClassInstance classInstance = (ClassInstance)reference;
                for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                    if (entry.getField().getType() != Type.OBJECT || entry.getValue() != instance) continue;
                    scratchList.add(entry.getField().getName());
                }
            } else if (reference instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)reference;
                assert (arrayInstance.getArrayType() == Type.OBJECT);
                Object[] values = arrayInstance.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != instance) continue;
                    scratchList.add(String.valueOf(i));
                }
            } else if (reference instanceof ClassObj) {
                ClassObj classObj = (ClassObj)reference;
                Map staticValues = classObj.getStaticFieldValues();
                for (Map.Entry entry : staticValues.entrySet()) {
                    if (((Field)entry.getKey()).getType() != Type.OBJECT || entry.getValue() != instance) continue;
                    scratchList.add(((Field)entry.getKey()).getName());
                }
            }
            String[] scratchNameArray = new String[scratchList.size()];
            node.add((MutableTreeNode)((Object)new InstanceNode(this.getMutableModel(), reference, scratchList.toArray(scratchNameArray))));
        }
    }

    private static class InstanceNode
    extends TreeBuilderNode {
        @NotNull
        private TreeBuilder myModel;
        @NotNull
        private String[] myVarNames;

        public InstanceNode(@NotNull TreeBuilder model, @NotNull Instance userObject, String ... varNames) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$InstanceNode", "<init>"));
            }
            if (userObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$InstanceNode", "<init>"));
            }
            if (varNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varNames", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$InstanceNode", "<init>"));
            }
            super((Object)userObject);
            this.myModel = model;
            this.myVarNames = varNames;
        }

        @NotNull
        public String[] getVarNames() {
            if (this.myVarNames == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/tables/InstanceReferenceTree$InstanceNode", "getVarNames"));
            }
            return this.myVarNames;
        }

        public Instance getInstance() {
            return (Instance)this.getUserObject();
        }

        protected TreeBuilder getTreeBuilder() {
            return this.myModel;
        }
    }
}

