/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.tables;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel {
    private final EventDispatcher<SelectionListener> myDispatcher;
    @NotNull
    private Heap myHeap;
    @Nullable
    private ClassObj myClassObj;
    @Nullable
    private Instance myInstance;
    private boolean mySelectionLocked;

    public SelectionModel(@NotNull Heap heap) {
        if (heap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/tables/SelectionModel", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(SelectionListener.class);
        this.myHeap = heap;
    }

    @NotNull
    public Heap getHeap() {
        Heap heap = this.myHeap;
        if (heap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/tables/SelectionModel", "getHeap"));
        }
        return heap;
    }

    public void setHeap(@NotNull Heap heap) {
        if (heap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/tables/SelectionModel", "setHeap"));
        }
        if (this.myHeap != heap && !this.mySelectionLocked) {
            this.myHeap = heap;
            ((SelectionListener)this.myDispatcher.getMulticaster()).onHeapChanged(this.myHeap);
        }
    }

    @Nullable
    public ClassObj getClassObj() {
        return this.myClassObj;
    }

    public void setClassObj(@Nullable ClassObj classObj) {
        if (this.myClassObj != classObj && !this.mySelectionLocked) {
            this.myClassObj = classObj;
            ((SelectionListener)this.myDispatcher.getMulticaster()).onClassObjChanged(this.myClassObj);
        }
    }

    @Nullable
    public Instance getInstance() {
        return this.myInstance;
    }

    public void setInstance(@Nullable Instance instance) {
        if (this.myInstance != instance && !this.mySelectionLocked) {
            this.myInstance = instance;
            ((SelectionListener)this.myDispatcher.getMulticaster()).onInstanceChanged(this.myInstance);
        }
    }

    public void setSelectionLocked(boolean locked) {
        this.mySelectionLocked = locked;
    }

    public void addListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/tables/SelectionModel", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
        listener.onHeapChanged(this.myHeap);
        listener.onClassObjChanged(this.myClassObj);
        listener.onInstanceChanged(this.myInstance);
    }

    public void removeListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/tables/SelectionModel", "removeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public static interface SelectionListener
    extends EventListener {
        public void onHeapChanged(@NotNull Heap var1);

        public void onClassObjChanged(@Nullable ClassObj var1);

        public void onInstanceChanged(@Nullable Instance var1);
    }
}

