/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.idea.editors.navigation.model.State;

public class Locator {
    @NonNull
    private final State state;
    @Nullable
    private final String fragmentClassName;
    @Nullable
    private final String viewId;

    private Locator(@NonNull State state, @Nullable String fragmentClassName, @Nullable String viewId) {
        this.state = state;
        this.fragmentClassName = fragmentClassName;
        this.viewId = viewId;
    }

    public static Locator of(@NonNull State state) {
        return new Locator(state, null, null);
    }

    public static Locator of(@NonNull State state, @Nullable String viewName) {
        return new Locator(state, null, viewName);
    }

    public static Locator of(@NonNull State state, @Nullable String fragmentClassName, @Nullable String viewName) {
        return new Locator(state, fragmentClassName, viewName);
    }

    @NonNull
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getFragmentClassName() {
        return this.fragmentClassName;
    }

    @Nullable
    public String getViewId() {
        return this.viewId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Locator locator = (Locator)o;
        if (this.fragmentClassName != null ? !this.fragmentClassName.equals(locator.fragmentClassName) : locator.fragmentClassName != null) {
            return false;
        }
        if (!this.state.equals(locator.state)) {
            return false;
        }
        return !(this.viewId != null ? !this.viewId.equals(locator.viewId) : locator.viewId != null);
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + (this.fragmentClassName != null ? this.fragmentClassName.hashCode() : 0);
        result = 31 * result + (this.viewId != null ? this.viewId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Locator{state=" + this.state + ", viewName='" + this.viewId + '\'' + '}';
    }
}

