/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.gradle.AndroidProjectSettingsService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectStructureAction
extends AnAction {
    protected AbstractProjectStructureAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.getTargetModule(e) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ProjectSettingsService service;
        Module module = this.getTargetModule(e);
        if (module != null && (service = ProjectSettingsService.getInstance((Project)module.getProject())) instanceof AndroidProjectSettingsService) {
            this.actionPerformed(module, (AndroidProjectSettingsService)service, e);
        }
    }

    protected abstract Module getTargetModule(@NotNull AnActionEvent var1);

    @Nullable
    protected Module getSelectedAndroidModule(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "getSelectedAndroidModule"));
        }
        Module module = this.getSelectedGradleModule(e);
        if (module != null && AndroidFacet.getInstance(module) != null) {
            return module;
        }
        return null;
    }

    @Nullable
    protected Module getSelectedGradleModule(@NotNull AnActionEvent e) {
        ProjectFileIndex fileIndex;
        VirtualFile file;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "getSelectedGradleModule"));
        }
        DataContext dataContext = e.getDataContext();
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (AbstractProjectStructureAction.isGradleModule(module)) {
            return module;
        }
        Project project = e.getProject();
        if (project != null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && AbstractProjectStructureAction.isGradleModule(module = (fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getModuleForFile(file))) {
            return module;
        }
        return null;
    }

    private static boolean isGradleModule(@Nullable Module module) {
        return module != null && Projects.isBuildWithGradle(module);
    }

    protected abstract void actionPerformed(@NotNull Module var1, @NotNull AndroidProjectSettingsService var2, @NotNull AnActionEvent var3);
}

