/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public class UnparseableStatement
extends BuildFileStatement {
    private final String myGroovy;
    private final boolean myComment;
    private final Project myProject;

    public UnparseableStatement(String groovy, Project project) {
        this.myGroovy = groovy;
        this.myProject = project;
        this.myComment = groovy.startsWith("//");
    }

    public UnparseableStatement(PsiElement element) {
        this.myGroovy = element.getText();
        this.myProject = element.getProject();
        this.myComment = element instanceof PsiComment;
    }

    @Override
    public List<PsiElement> getGroovyElements(GroovyPsiElementFactory factory) {
        if (this.myComment) {
            PsiElementFactory psiFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            return ImmutableList.of((Object)factory.createLineTerminator("\n"), (Object)psiFactory.createCommentFromText(this.myGroovy, null), (Object)factory.createLineTerminator("\n"));
        }
        return ImmutableList.of((Object)factory.createStatementFromText((CharSequence)this.myGroovy));
    }

    public String toString() {
        return this.myGroovy;
    }

    public boolean isComment() {
        return this.myComment;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        UnparseableStatement that = (UnparseableStatement)o;
        return this.myComment == that.myComment && Objects.equal((Object)this.myGroovy, (Object)that.myGroovy);
    }

    public int hashCode() {
        int result = this.myGroovy != null ? this.myGroovy.hashCode() : 0;
        result = 31 * result + (this.myComment ? 1 : 0);
        return result;
    }
}

