/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.resources.ResourceFolderType;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.SystemProperties;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RecipeMergeUtils {
    private static final Logger LOG = Logger.getInstance(RecipeMergeUtils.class);
    private static final String MERGE_ATTR_STRATEGY = "templateMergeStrategy";
    private static final String MERGE_ATTR_STRATEGY_REPLACE = "replace";
    private static final String MERGE_ATTR_STRATEGY_PRESERVE = "preserve";
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("(^|\\n)\\s*include +(':[^']+', *)*':[^']+'");

    public static String mergeGradleSettingsFile(@NotNull String source, @NotNull String dest) throws IOException, TemplateException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeGradleSettingsFile"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeGradleSettingsFile"));
        }
        StringBuilder contents = new StringBuilder(dest);
        for (String line : Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)source)) {
            if (!line.startsWith("include")) {
                throw new RuntimeException("When merging settings.gradle files, only include directives can be merged.");
            }
            line = line.substring("include".length()).trim();
            Matcher matcher = INCLUDE_PATTERN.matcher(contents);
            if (matcher.find()) {
                contents.insert(matcher.end(), ", " + line);
                continue;
            }
            contents.insert(0, "include " + line + SystemProperties.getLineSeparator());
        }
        return contents.toString();
    }

    @Nullable
    public static String mergeXml(@NotNull Project project, String sourceXml, String targetXml, File targetFile) {
        boolean ok;
        String contents;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeXml"));
        }
        String fileName = targetFile.getName();
        if (fileName.equals("AndroidManifest.xml")) {
            Document currentDocument = XmlUtils.parseDocumentSilently((String)targetXml, (boolean)true);
            assert (currentDocument != null) : targetXml + " failed to parse";
            Document fragment = XmlUtils.parseDocumentSilently((String)sourceXml, (boolean)true);
            assert (fragment != null) : sourceXml + " failed to parse";
            contents = RecipeMergeUtils.mergeManifest(targetFile, sourceXml);
            ok = contents != null;
        } else {
            String parentFolderName = targetFile.getParentFile().getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentFolderName);
            contents = RecipeMergeUtils.mergeResourceFile(project, targetXml, sourceXml, folderType);
            boolean bl = ok = contents != null;
        }
        if (!ok) {
            contents = RecipeMergeUtils.wrapWithMergeConflict(targetXml, sourceXml);
        }
        return contents;
    }

    public static String mergeResourceFile(@NotNull Project project, @NotNull String targetXml, @NotNull String sourceXml, @Nullable ResourceFolderType folderType) {
        XmlAttribute[] attributes;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeResourceFile"));
        }
        if (targetXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetXml", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeResourceFile"));
        }
        if (sourceXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceXml", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeResourceFile"));
        }
        XmlFile targetPsiFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("targetFile", (Language)XMLLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)targetXml));
        XmlFile sourcePsiFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("sourceFile", (Language)XMLLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)sourceXml));
        XmlTag root = targetPsiFile.getDocument().getRootTag();
        assert (root != null) : "Cannot find XML root in target: " + targetXml;
        for (XmlAttribute attr : attributes = sourcePsiFile.getRootTag().getAttributes()) {
            if (!attr.getNamespacePrefix().equals("xmlns:")) continue;
            root.setAttribute(attr.getName(), attr.getValue());
        }
        ArrayList prependElements = Lists.newArrayList();
        XmlText indent = null;
        if (folderType == ResourceFolderType.VALUES) {
            HashMap old = Maps.newHashMap();
            for (XmlTag xmlTag : root.getSubTags()) {
                old.put(RecipeMergeUtils.getResourceId(xmlTag), xmlTag);
            }
            for (XmlTag xmlTag : sourcePsiFile.getRootTag().getChildren()) {
                XmlTag replace;
                if (xmlTag instanceof XmlComment) {
                    if (indent != null) {
                        prependElements.add(indent);
                    }
                    prependElements.add((XmlTagChild)xmlTag);
                    continue;
                }
                if (xmlTag instanceof XmlText) {
                    indent = (XmlText)xmlTag;
                    continue;
                }
                if (!(xmlTag instanceof XmlTag)) continue;
                XmlTag subTag = xmlTag;
                String mergeStrategy = subTag.getAttributeValue(MERGE_ATTR_STRATEGY);
                subTag.setAttribute(MERGE_ATTR_STRATEGY, null);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)subTag);
                String name = RecipeMergeUtils.getResourceId(subTag);
                XmlTag xmlTag2 = replace = name != null ? (XmlTag)old.get(name) : null;
                if (replace != null) {
                    if (MERGE_ATTR_STRATEGY_REPLACE.equals(mergeStrategy)) {
                        PsiElement psiElement = replace.replace((PsiElement)xmlTag);
                        if (psiElement.getPrevSibling() instanceof XmlText && prependElements.get(0) instanceof XmlText) {
                            prependElements.remove(0);
                            if (!prependElements.isEmpty()) {
                                prependElements.add(indent);
                            }
                        }
                        for (XmlTagChild element : prependElements) {
                            root.addBefore((PsiElement)element, psiElement);
                        }
                    } else if (!MERGE_ATTR_STRATEGY_PRESERVE.equals(mergeStrategy)) {
                        LOG.warn("Warning: Ignoring name conflict in resource file for name " + name);
                    }
                } else {
                    if (indent != null) {
                        prependElements.add(indent);
                    }
                    subTag = root.addSubTag(subTag, false);
                    for (XmlTagChild element : prependElements) {
                        root.addBefore((PsiElement)element, (PsiElement)subTag);
                    }
                }
                prependElements.clear();
            }
        } else {
            for (PsiElement child : sourcePsiFile.getRootTag().getChildren()) {
                if (!(child instanceof XmlTag)) continue;
                root.addSubTag((XmlTag)child, false);
            }
        }
        return targetPsiFile.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String mergeManifest(@NotNull File targetManifest, @NotNull String mergeText) {
        if (targetManifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetManifest", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeManifest"));
        }
        if (mergeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeText", "com/android/tools/idea/templates/RecipeMergeUtils", "mergeManifest"));
        }
        File tempFile = null;
        try {
            tempFile = FileUtil.createTempFile((String)"manifmerge", (String)".xml");
            FileUtil.writeToFile((File)tempFile, (String)mergeText);
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            ManifestMerger2.Invoker merger = ManifestMerger2.newMerger((File)targetManifest, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.EXTRACT_FQCNS, ManifestMerger2.Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT}).addLibraryManifest(tempFile);
            MergingReport mergeReport = merger.merge();
            if (mergeReport.getMergedDocument().isPresent()) {
                String string = XmlPrettyPrinter.prettyPrint((Node)((XmlDocument)mergeReport.getMergedDocument().get()).getXml(), (XmlFormatPreferences)RecipeMergeUtils.createXmlFormatPreferences(), (XmlFormatStyle)XmlFormatStyle.MANIFEST, (String)"\n", (boolean)mergeText.endsWith("\n"));
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (ManifestMerger2.MergeFailureException e) {
            LOG.error((Throwable)e);
            try {
                FileUtil.appendToFile((File)tempFile, (String)String.format("<!--%s-->", e.getMessage()));
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return null;
    }

    private static String getResourceId(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/templates/RecipeMergeUtils", "getResourceId"));
        }
        String name = tag.getAttributeValue("name");
        if (name == null) {
            name = tag.getAttributeValue("id");
        }
        return name;
    }

    @NotNull
    private static XmlFormatPreferences createXmlFormatPreferences() {
        XmlFormatPreferences xmlFormatPreferences = XmlFormatPreferences.defaults();
        if (xmlFormatPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/RecipeMergeUtils", "createXmlFormatPreferences"));
        }
        return xmlFormatPreferences;
    }

    private static String wrapWithMergeConflict(String original, String added) {
        String sep = "\n";
        return "<<<<<<< Original" + sep + original + sep + "=======" + sep + added + ">>>>>>> Added" + sep;
    }
}

