/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.AndroidStudioWizardStep;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.StringEvaluator;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public abstract class TemplateWizardStep
extends ModuleWizardStep
implements ActionListener,
FocusListener,
DocumentListener,
ChangeListener,
AndroidStudioWizardStep {
    private static final Logger LOG = Logger.getInstance((String)("#" + TemplateWizardStep.class.getName()));
    protected static final String LAST_USED_CLASS_PREFIX_KEY = "LAST_USED_CLASS_PREFIX";
    protected final TemplateWizardState myTemplateState;
    protected final BiMap<String, JComponent> myParamFields;
    protected final Map<String, JLabel> myParamFieldLabels;
    protected final Map<JRadioButton, Pair<String, Object>> myRadioButtonValues;
    protected final Map<Parameter, ComboBoxItem> myComboBoxValues;
    protected final Project myProject;
    protected final Module myModule;
    private final Icon mySidePanelIcon;
    protected boolean myIgnoreUpdates;
    protected boolean myFirstUpdate;
    protected boolean myIsValid;
    protected boolean myVisible;
    protected final UpdateListener myUpdateListener;
    private final StringEvaluator myStringEvaluator;
    protected Queue<String> myIdsWithNewValues;
    public static final UpdateListener NONE = new UpdateListener(){

        @Override
        public void update() {
        }
    };

    public TemplateWizardStep(@NotNull TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, @Nullable UpdateListener updateListener) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/TemplateWizardStep", "<init>"));
        }
        this.myParamFields = HashBiMap.create();
        this.myParamFieldLabels = Maps.newHashMap();
        this.myRadioButtonValues = Maps.newHashMap();
        this.myComboBoxValues = Maps.newHashMap();
        this.myIgnoreUpdates = false;
        this.myFirstUpdate = true;
        this.myIsValid = true;
        this.myVisible = true;
        this.myStringEvaluator = new StringEvaluator();
        this.myIdsWithNewValues = new ConcurrentLinkedQueue<String>();
        this.myTemplateState = state;
        this.myProject = project;
        this.myModule = module;
        this.mySidePanelIcon = sidePanelIcon;
        this.myUpdateListener = updateListener;
    }

    public void _init() {
        super._init();
        this.update();
    }

    @NotNull
    protected abstract JLabel getDescription();

    protected void setDescriptionHtml(@Nullable String s) {
        JLabel label;
        if (s == null) {
            s = "";
        }
        if (!s.startsWith("<html>")) {
            s = "<html>" + s + "</html>";
            s.replaceAll("\n", "<br>");
        }
        if ((label = this.getDescription()) != null) {
            label.setText(s);
            this.growLabelIfNecessary(label);
        }
    }

    @NotNull
    protected abstract JLabel getError();

    public void setErrorHtml(@Nullable String s) {
        JLabel label;
        if (s == null) {
            s = "";
        }
        if (!s.startsWith("<html>")) {
            s = "<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + XmlUtils.toXmlTextValue((String)s) + "</font></html>";
            s.replaceAll("\n", "<br>");
        }
        if ((label = this.getError()) != null) {
            label.setText(s);
            this.growLabelIfNecessary(label);
        }
    }

    protected void growLabelIfNecessary(JLabel label) {
        Dimension newSize = label.getMinimumSize();
        label.setPreferredSize(null);
        label.validate();
        Dimension pd = label.getPreferredSize();
        int currentWidth = label.getSize().width;
        int preferredHeight = 0;
        if (currentWidth != 0 && pd.width != 0 && pd.height != 0) {
            preferredHeight = pd.height * (int)((float)pd.width / (float)currentWidth);
            if (currentWidth % pd.width != 0) {
                preferredHeight += pd.height;
            }
        }
        newSize.height = Math.max(newSize.height, preferredHeight);
        label.setMinimumSize(newSize);
        label.setPreferredSize(newSize);
        if (this.getComponent() != null) {
            this.getComponent().revalidate();
        }
    }

    @Nullable
    protected String getHelpText(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/android/tools/idea/wizard/TemplateWizardStep", "getHelpText"));
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.myIsValid;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    public boolean isStepVisible() {
        return this.myVisible;
    }

    public void updateParams() {
        if (!this.myVisible) {
            return;
        }
        Template.convertApisToInt(this.myTemplateState.getParameters());
        Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.setDescriptionHtml("");
        this.setErrorHtml("");
        for (String string : this.myParamFields.keySet()) {
            Object newValue;
            if (this.myTemplateState.myHidden.contains(string)) continue;
            Parameter param = this.myTemplateState.hasTemplate() ? this.myTemplateState.getTemplateMetadata().getParameter(string) : null;
            Object oldValue = this.myTemplateState.get(string);
            JComponent component = (JComponent)this.myParamFields.get((Object)string);
            if (component == focusedComponent || component.isAncestorOf(focusedComponent)) {
                String help = param != null && param.help != null && param.help.length() > 0 ? param.help : this.getHelpText(string);
                this.setDescriptionHtml(help);
            }
            if ((newValue = this.getComponentValue(param, component)) == null || newValue.equals(oldValue)) continue;
            this.myTemplateState.put(string, newValue);
            if (oldValue != null) {
                this.myTemplateState.myModified.add(string);
            }
            if (this.myIdsWithNewValues.contains(string)) continue;
            this.myIdsWithNewValues.add(string);
        }
        for (Map.Entry entry : this.myRadioButtonValues.entrySet()) {
            if (!((JRadioButton)entry.getKey()).isSelected()) continue;
            Pair value = (Pair)entry.getValue();
            this.myTemplateState.put((String)value.getFirst(), value.getSecond());
        }
    }

    protected void deriveValues() {
        TemplateMetadata metadata = this.myTemplateState.getTemplateMetadata();
        if (metadata == null) {
            return;
        }
        for (String changedParamId : this.myIdsWithNewValues) {
            for (String paramName : this.myParamFields.keySet()) {
                String updated;
                Parameter param = this.myTemplateState.hasTemplate() ? metadata.getParameter(paramName) : null;
                if (param == null || (param.suggest == null || param.suggest.isEmpty()) && (param.visibility == null || param.visibility.isEmpty())) continue;
                if (param.visibility != null && param.visibility.contains(changedParamId)) {
                    this.updateVisibility(param);
                }
                if (this.myTemplateState.myHidden.contains(paramName) || param.suggest == null || !param.suggest.contains(changedParamId) || (updated = this.myStringEvaluator.evaluate(param.suggest, this.myTemplateState.getParameters())) == null || updated.equals(this.myTemplateState.get(param.id))) continue;
                this.myIdsWithNewValues.add(param.id);
                this.updateDerivedValue(param.id, (JTextField)this.myParamFields.get((Object)param.id), new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return updated;
                    }
                });
            }
        }
    }

    protected void updateVisibility(Parameter param) {
        if (param.visibility != null && !param.visibility.isEmpty()) {
            boolean visible = this.myStringEvaluator.evaluateBooleanExpression(param.visibility, this.myTemplateState.getParameters(), true);
            if (visible) {
                String updated;
                this.myTemplateState.myHidden.remove(param.id);
                if (param.suggest != null && (updated = this.myStringEvaluator.evaluate(param.suggest, this.myTemplateState.getParameters())) != null && !updated.equals(this.myTemplateState.get(param.id))) {
                    this.updateDerivedValue(param.id, (JTextField)this.myParamFields.get((Object)param.id), new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return updated;
                        }
                    });
                }
            } else {
                this.myTemplateState.myHidden.add(param.id);
            }
            ((JComponent)this.myParamFields.get((Object)param.id)).setVisible(visible);
            if (this.myParamFieldLabels.containsKey(param.id)) {
                this.myParamFieldLabels.get(param.id).setVisible(visible);
            }
        }
    }

    public boolean validate() {
        Template.convertApisToInt(this.myTemplateState.getParameters());
        if (!this.myVisible) {
            return true;
        }
        Integer minApi = (Integer)this.myTemplateState.get("minApiLevel");
        Integer buildApi = (Integer)this.myTemplateState.get("buildApi");
        for (String paramName : this.myParamFields.keySet()) {
            Parameter param;
            if (this.myTemplateState.myHidden.contains(paramName) || (param = this.myTemplateState.hasTemplate() ? this.myTemplateState.getTemplateMetadata().getParameter(paramName) : null) == null) continue;
            String error = param.validate(this.myProject, this.myModule, this.myTemplateState.getSourceProvider(), (String)this.myTemplateState.get("packageName"), this.myTemplateState.get(paramName));
            if (error != null) {
                this.setErrorHtml(error);
                return false;
            }
            if (!this.myComboBoxValues.containsKey(param)) continue;
            ComboBoxItem selectedItem = this.myComboBoxValues.get(param);
            if (selectedItem == null) {
                return false;
            }
            if (minApi != null && selectedItem.minApi > minApi) {
                this.setErrorHtml(String.format("The \"%s\" option for %s requires a minimum API level of %d", selectedItem.label, param.name, selectedItem.minApi));
                return false;
            }
            if (buildApi == null || selectedItem.minBuildApi <= buildApi) continue;
            this.setErrorHtml(String.format("The \"%s\" option for %s requires a minimum API level of %d", selectedItem.label, param.name, selectedItem.minBuildApi));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUiFromParameters() {
        if (this.myTemplateState.myTemplate == null) {
            return;
        }
        for (Parameter param : this.myTemplateState.myTemplate.getMetadata().getParameters()) {
            if (param.initial == null || this.myTemplateState.myModified.contains(param.id)) continue;
            this.myTemplateState.myParameters.remove(param.id);
        }
        this.myTemplateState.setParameterDefaults();
        Template.convertApisToInt(this.myTemplateState.getParameters());
        boolean oldIgnoreUpdates = this.myIgnoreUpdates;
        try {
            this.myIgnoreUpdates = true;
            block4: for (String paramName : this.myParamFields.keySet()) {
                if (this.myTemplateState.myHidden.contains(paramName)) continue;
                JComponent component = (JComponent)this.myParamFields.get((Object)paramName);
                Object value = this.myTemplateState.get(paramName);
                if (value == null) continue;
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setSelected(Boolean.parseBoolean(value.toString()));
                    continue;
                }
                if (component instanceof JComboBox) {
                    for (int i = 0; i < ((JComboBox)component).getItemCount(); ++i) {
                        if (!((ComboBoxItem)((JComboBox)component).getItemAt((int)i)).id.equals(value)) continue;
                        ((JComboBox)component).setSelectedIndex(i);
                        continue block4;
                    }
                    continue;
                }
                if (component instanceof JTextField) {
                    ((JTextField)component).setText(value.toString());
                    continue;
                }
                if (component instanceof TextFieldWithBrowseButton) {
                    ((TextFieldWithBrowseButton)component).setText(value.toString());
                    continue;
                }
                if (component instanceof JSlider) {
                    ((JSlider)component).setValue(Integer.parseInt(value.toString()));
                    continue;
                }
                if (component instanceof JSpinner) {
                    ((JSpinner)component).setValue(Integer.parseInt(value.toString()));
                    continue;
                }
                if (!(component instanceof ColorPanel)) continue;
                ((ColorPanel)component).setSelectedColor((Color)value);
            }
        }
        finally {
            this.myIgnoreUpdates = oldIgnoreUpdates;
        }
    }

    @Nullable
    protected Object getComponentValue(Parameter param, JComponent component) {
        Object newValue = null;
        if (component instanceof JCheckBox) {
            newValue = ((JCheckBox)component).isSelected();
        } else if (component instanceof JComboBox) {
            ComboBoxItem selectedItem = (ComboBoxItem)((JComboBox)component).getSelectedItem();
            this.myComboBoxValues.put(param, selectedItem);
            if (selectedItem != null) {
                newValue = selectedItem.id;
            }
        } else if (component instanceof JTextField) {
            newValue = ((JTextField)component).getText();
        } else if (component instanceof TextFieldWithBrowseButton) {
            newValue = ((TextFieldWithBrowseButton)component).getText();
        } else if (component instanceof JSlider) {
            newValue = ((JSlider)component).getValue();
        } else if (component instanceof JSpinner) {
            newValue = ((JSpinner)component).getValue();
        } else if (component instanceof ColorPanel) {
            newValue = ((ColorPanel)component).getSelectedColor();
        }
        return newValue;
    }

    protected static void populateComboBox(@NotNull JComboBox comboBox, @NotNull Parameter parameter) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/wizard/TemplateWizardStep", "populateComboBox"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/wizard/TemplateWizardStep", "populateComboBox"));
        }
        List<Element> options = parameter.getOptions();
        assert (!options.isEmpty());
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Element option = options.get(i);
            String optionId = option.getAttribute("id");
            assert (optionId != null && !optionId.isEmpty()) : "id";
            NodeList childNodes = option.getChildNodes();
            assert (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3);
            String optionLabel = childNodes.item(0).getNodeValue().trim();
            int minSdk = 1;
            try {
                minSdk = Integer.parseInt(option.getAttribute("minApi"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int minBuildApi = 1;
            try {
                minBuildApi = Integer.parseInt(option.getAttribute("minBuildApi"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            comboBox.addItem(new ComboBoxItem(optionId, optionLabel, minSdk, minBuildApi));
            String isDefault = option.getAttribute("default");
            if (isDefault == null || isDefault.isEmpty() || !Boolean.valueOf(isDefault).booleanValue()) continue;
            comboBox.setSelectedIndex(comboBox.getItemCount() - 1);
        }
    }

    protected static <E extends Enum<E>> void populateComboBox(@NotNull JComboBox comboBox, @NotNull Class<E> enumClass) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/wizard/TemplateWizardStep", "populateComboBox"));
        }
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "com/android/tools/idea/wizard/TemplateWizardStep", "populateComboBox"));
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            comboBox.addItem(new ComboBoxItem(e.name(), e.toString(), 1, 1));
        }
    }

    protected static void populateComboBox(@NotNull JComboBox comboBox, @NotNull Object[] array) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/wizard/TemplateWizardStep", "populateComboBox"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/android/tools/idea/wizard/TemplateWizardStep", "populateComboBox"));
        }
        for (int i = 0; i < array.length; ++i) {
            comboBox.addItem(new ComboBoxItem(i, array[i].toString(), 1, 1));
        }
    }

    protected void registerLabel(@NotNull String paramName, @NotNull JLabel label) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "registerLabel"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/wizard/TemplateWizardStep", "registerLabel"));
        }
        this.myParamFieldLabels.put(paramName, label);
    }

    protected void register(@NotNull String paramName, @NotNull JCheckBox checkBox) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (checkBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        this.myParamFields.put((Object)paramName, (Object)checkBox);
        Object value = this.myTemplateState.get(paramName);
        if (value != null) {
            checkBox.setSelected(Boolean.parseBoolean(value.toString()));
        } else {
            this.myTemplateState.put(paramName, false);
        }
        checkBox.addFocusListener(this);
        checkBox.addActionListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JComboBox comboBox) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        this.myParamFields.put((Object)paramName, (Object)comboBox);
        Object value = this.myTemplateState.get(paramName);
        if (value != null) {
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                Object item = comboBox.getItemAt(i);
                if (!(item instanceof ComboBoxItem) || !((ComboBoxItem)item).id.equals(value)) continue;
                comboBox.setSelectedIndex(i);
                break;
            }
        }
        comboBox.addFocusListener(this);
        comboBox.addActionListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JTextField textField) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        String value = (String)this.myTemplateState.get(paramName);
        if (value != null) {
            textField.setText(value);
        } else {
            this.myTemplateState.put(paramName, "");
        }
        this.myParamFields.put((Object)paramName, (Object)textField);
        textField.addFocusListener(this);
        textField.getDocument().addDocumentListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JRadioButton radioButton, @Nullable Object value) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (radioButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "radioButton", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        Object currentValue = this.myTemplateState.get(paramName);
        radioButton.setSelected(currentValue != null && currentValue.equals(value));
        if (value != null) {
            this.myRadioButtonValues.put(radioButton, (Pair<String, Object>)Pair.of((Object)paramName, (Object)value));
        }
        radioButton.addFocusListener(this);
        radioButton.addActionListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JSlider paddingSlider) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (paddingSlider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paddingSlider", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        Integer value = (Integer)this.myTemplateState.get(paramName);
        if (value != null) {
            paddingSlider.setValue(value);
        } else {
            this.myTemplateState.put(paramName, paddingSlider.getValue());
        }
        this.myParamFields.put((Object)paramName, (Object)paddingSlider);
        paddingSlider.addFocusListener(this);
        paddingSlider.addChangeListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JSpinner spinner) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (spinner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spinner", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        Integer value = (Integer)this.myTemplateState.get(paramName);
        if (value != null) {
            spinner.setValue(value);
        } else {
            this.myTemplateState.put(paramName, spinner.getValue());
        }
        this.myParamFields.put((Object)paramName, (Object)spinner);
        spinner.addFocusListener(this);
        spinner.addChangeListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull TextFieldWithBrowseButton field) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        String value = (String)this.myTemplateState.get(paramName);
        if (value != null) {
            field.setText(value);
        } else {
            this.myTemplateState.put(paramName, field.getText());
        }
        this.myParamFields.put((Object)paramName, (Object)field);
        field.addFocusListener((FocusListener)this);
        field.getTextField().getDocument().addDocumentListener(this);
        field.getTextField().addFocusListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull ColorPanel colorPanel) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        if (colorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorPanel", "com/android/tools/idea/wizard/TemplateWizardStep", "register"));
        }
        Color value = (Color)this.myTemplateState.get(paramName);
        if (value != null) {
            colorPanel.setSelectedColor(value);
        } else {
            this.myTemplateState.put(paramName, colorPanel.getSelectedColor());
        }
        this.myParamFields.put((Object)paramName, (Object)colorPanel);
        colorPanel.addFocusListener((FocusListener)this);
        colorPanel.addActionListener((ActionListener)this);
    }

    protected void update() {
        if (this.myIgnoreUpdates) {
            return;
        }
        this.myIgnoreUpdates = true;
        this.myIdsWithNewValues = new ConcurrentLinkedQueue<String>();
        this.updateParams();
        if (this.myFirstUpdate) {
            this.myIdsWithNewValues = new ConcurrentLinkedQueue<String>(this.myTemplateState.getParameters().keySet());
        }
        this.deriveValues();
        this.myIsValid = this.validate();
        if (this.myUpdateListener != null) {
            this.myUpdateListener.update();
        }
        this.myFirstUpdate = false;
        this.myIgnoreUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateDerivedValue(@NotNull String attrName, @NotNull JTextField textField, @NotNull Callable<String> valueDeriver) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/android/tools/idea/wizard/TemplateWizardStep", "updateDerivedValue"));
        }
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/android/tools/idea/wizard/TemplateWizardStep", "updateDerivedValue"));
        }
        if (valueDeriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDeriver", "com/android/tools/idea/wizard/TemplateWizardStep", "updateDerivedValue"));
        }
        boolean updated = false;
        try {
            String s;
            this.myIgnoreUpdates = true;
            if (!this.myTemplateState.myModified.contains(attrName) && (s = valueDeriver.call()) != null && !s.equals(this.myTemplateState.get(attrName))) {
                this.myTemplateState.put(attrName, s);
                textField.setText(s);
                this.myTemplateState.myModified.remove(attrName);
                updated = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.myIgnoreUpdates = false;
        }
        return updated;
    }

    public JComponent getComponent() {
        return null;
    }

    public Icon getIcon() {
        return this.mySidePanelIcon;
    }

    public void updateDataModel() {
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionEvent", "com/android/tools/idea/wizard/TemplateWizardStep", "actionPerformed"));
        }
        this.update();
    }

    @Override
    public void focusGained(@NotNull FocusEvent focusEvent) {
        if (focusEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusEvent", "com/android/tools/idea/wizard/TemplateWizardStep", "focusGained"));
        }
        this.update();
    }

    @Override
    public void focusLost(@NotNull FocusEvent focusEvent) {
        if (focusEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusEvent", "com/android/tools/idea/wizard/TemplateWizardStep", "focusLost"));
        }
        this.update();
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/android/tools/idea/wizard/TemplateWizardStep", "insertUpdate"));
        }
        this.update();
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/android/tools/idea/wizard/TemplateWizardStep", "removeUpdate"));
        }
        this.update();
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/android/tools/idea/wizard/TemplateWizardStep", "changedUpdate"));
        }
        this.update();
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/wizard/TemplateWizardStep", "stateChanged"));
        }
        this.update();
    }

    protected void hide(JComponent ... components) {
        for (JComponent component : components) {
            component.setVisible(false);
        }
    }

    protected void show(JComponent ... components) {
        for (JComponent component : components) {
            component.setVisible(true);
        }
    }

    public static interface UpdateListener {
        public void update();
    }
}

