/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.NonNull;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ColorPicker;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidColorAnnotator
implements Annotator {
    private static final int ICON_SIZE = 8;
    private static final int MAX_ICON_SIZE = 5000;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        ResourceType type;
        AndroidPsiUtils.ResourceReferenceType referenceType;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/AndroidColorAnnotator", "annotate"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String tagName = tag.getName();
            if (ResourceType.COLOR.getName().equals(tagName) || ResourceType.DRAWABLE.getName().equals(tagName) || ResourceType.MIPMAP.getName().equals(tagName)) {
                DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
                if (domElement instanceof ResourceElement) {
                    String value = tag.getValue().getText().trim();
                    AndroidColorAnnotator.annotateXml(element, holder, value);
                }
            } else if ("item".equals(tagName)) {
                XmlTagValue value = tag.getValue();
                String text = value.getText();
                AndroidColorAnnotator.annotateXml(element, holder, text);
            }
        } else if (element instanceof XmlAttributeValue) {
            XmlAttributeValue v = (XmlAttributeValue)element;
            String value = v.getValue();
            if (value == null || value.isEmpty()) {
                return;
            }
            AndroidColorAnnotator.annotateXml(element, holder, value);
        } else if (element instanceof PsiReferenceExpression && (referenceType = AndroidPsiUtils.getResourceReferenceType(element)) != AndroidPsiUtils.ResourceReferenceType.NONE && ((type = AndroidPsiUtils.getResourceType(element)) == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP)) {
            String name = AndroidPsiUtils.getResourceName(element);
            AndroidColorAnnotator.annotateResourceReference(type, holder, element, name, referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK);
        }
    }

    private static void annotateXml(PsiElement element, AnnotationHolder holder, String value) {
        if (value.startsWith("#")) {
            PsiFile file = element.getContainingFile();
            if (file != null && AndroidResourceUtil.isInResourceSubdirectory(file, null)) {
                if (element instanceof XmlTag) {
                    Annotation annotation = holder.createInfoAnnotation(element, null);
                    annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, null));
                } else {
                    assert (element instanceof XmlAttributeValue);
                    Color color = ResourceHelper.parseColor(value);
                    if (color != null) {
                        Annotation annotation = holder.createInfoAnnotation(element, null);
                        annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, null));
                    }
                }
            }
        } else if (value.startsWith("@color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value.substring("@color/".length()), false);
        } else if (value.startsWith("@android:color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value.substring("@android:color/".length()), true);
        } else if (value.startsWith("@drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value.substring("@drawable/".length()), false);
        } else if (value.startsWith("@android:drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value.substring("@android:drawable/".length()), true);
        } else if (value.startsWith("@mipmap/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.MIPMAP, holder, element, value.substring("@mipmap/".length()), false);
        }
    }

    @Nullable
    public static VirtualFile pickLayoutFile(@NotNull Module module, @NotNull AndroidFacet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/AndroidColorAnnotator", "pickLayoutFile"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/AndroidColorAnnotator", "pickLayoutFile"));
        }
        VirtualFile layout = null;
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)module.getProject()).getOpenFiles();
        for (VirtualFile file : openFiles) {
            if (!file.getName().endsWith(".xml") || file.getParent() == null || !file.getParent().getName().startsWith("layout")) continue;
            layout = file;
            break;
        }
        if (layout == null) {
            for (VirtualFile resourceDir : facet.getAllResourceDirectories()) {
                block2: for (VirtualFile folder : resourceDir.getChildren()) {
                    if (!folder.getName().startsWith("layout") || !folder.isDirectory()) continue;
                    for (VirtualFile file : folder.getChildren()) {
                        if (!file.getName().endsWith(".xml") || file.getParent() == null || !file.getParent().getName().startsWith("layout")) continue;
                        layout = file;
                        continue block2;
                    }
                }
            }
        }
        return layout;
    }

    private static void annotateResourceReference(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String name, boolean isFramework) {
        ResourceResolver resourceResolver;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceReference"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class);
        if (file == null) {
            return;
        }
        Configuration configuration = AndroidColorAnnotator.pickConfiguration(facet, module, file);
        if (configuration == null) {
            return;
        }
        ResourceValue value = AndroidColorAnnotator.findResourceValue(type, name, isFramework, module, configuration);
        if (value != null && (resourceResolver = configuration.getResourceResolver()) != null) {
            AndroidColorAnnotator.annotateResourceValue(type, holder, element, value, resourceResolver);
        }
    }

    @Nullable
    private static Configuration pickConfiguration(AndroidFacet facet, Module module, PsiFile file) {
        VirtualFile layout;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String parentName = virtualFile.getParent().getName();
        if (!parentName.startsWith("layout")) {
            layout = AndroidColorAnnotator.pickLayoutFile(module, facet);
            if (layout == null) {
                return null;
            }
        } else {
            layout = virtualFile;
        }
        return facet.getConfigurationManager().getConfiguration(layout);
    }

    private static void annotateResourceValue(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull ResourceValue value, @NotNull ResourceResolver resourceResolver) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (resourceResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceResolver", "org/jetbrains/android/AndroidColorAnnotator", "annotateResourceValue"));
        }
        if (type == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)resourceResolver, value);
            if (color != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, color));
            }
        } else {
            assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
            File iconFile = AndroidColorAnnotator.pickBestBitmap(ResourceHelper.resolveDrawable((RenderResources)resourceResolver, value));
            if (iconFile != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(element, iconFile));
            }
        }
    }

    @Nullable
    private static File pickBestBitmap(@Nullable File bitmap) {
        if (bitmap != null && bitmap.exists()) {
            File smallest = AndroidColorAnnotator.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.length();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static File findSmallestDpiVersion(@NonNull File bitmap) {
        File parentFile = bitmap.getParentFile();
        if (parentFile == null) {
            return null;
        }
        File resFolder = parentFile.getParentFile();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            for (int i = densities.length - 1; i >= 0; --i) {
                String folder;
                Density d = densities[i];
                if (!d.isValidValueForDevice() || !(bitmap = new File(resFolder, (folder = parentName.replace(density.getResourceValue(), d.getResourceValue())) + File.separator + fileName)).exists()) continue;
                if (bitmap.length() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static ResourceValue findResourceValue(ResourceType type, String name, boolean isFramework, Module module, Configuration configuration) {
        if (isFramework) {
            ResourceRepository frameworkResources = configuration.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            if (!frameworkResources.hasResourceItem(type, name)) {
                return null;
            }
            ResourceItem item = frameworkResources.getResourceItem(type, name);
            return item.getResourceValue(type, configuration.getFullConfig(), false);
        }
        AppResourceRepository appResources = AppResourceRepository.getAppResources(module, true);
        if (appResources == null) {
            return null;
        }
        if (!appResources.hasResourceItem(type, name)) {
            return null;
        }
        return appResources.getConfiguredValue(type, name, configuration.getFullConfig());
    }

    private static class MyRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;

        private MyRenderer(@NotNull PsiElement element, @Nullable Color color) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/AndroidColorAnnotator$MyRenderer", "<init>"));
            }
            this.myElement = element;
            this.myColor = color;
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            Icon icon = color == null ? EmptyIcon.create((int)8) : new ColorIcon(8, color);
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidColorAnnotator$MyRenderer", "getIcon"));
            }
            return icon;
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (this.myColor != null) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Color color;
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null && (color = ColorPicker.showDialog(editor.getComponent(), "Choose Color", MyRenderer.this.getCurrentColor(), true, null, false)) != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                XmlAttribute attribute;
                                if (MyRenderer.this.myElement instanceof XmlTag) {
                                    ((XmlTag)MyRenderer.this.myElement).getValue().setText(ResourceHelper.colorToString(color));
                                } else if (MyRenderer.this.myElement instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)MyRenderer.this.myElement, XmlAttribute.class)) != null) {
                                    attribute.setValue(ResourceHelper.colorToString(color));
                                }
                            }
                        });
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyRenderer that = (MyRenderer)((Object)o);
            if (this.myColor != null ? !this.myColor.equals(that.myColor) : that.myColor != null) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            int result = this.myElement.hashCode();
            result = 31 * result + (this.myColor != null ? this.myColor.hashCode() : 0);
            return result;
        }
    }
}

