/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.logcat.AndroidConfiguredLogFilters;
import org.jetbrains.android.logcat.AndroidLogFilterModel;
import org.jetbrains.android.logcat.AndroidLogcatFiltersPreferences;
import org.jetbrains.android.logcat.AndroidLogcatUtil;
import org.jetbrains.android.logcat.AndroidLoggingReader;
import org.jetbrains.android.logcat.ConfiguredFilter;
import org.jetbrains.android.logcat.EditLogFilterDialog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLogcatView
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.logcat.AndroidLogcatView");
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    public static final String SELECTED_APP_FILTER = AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    public static final String NO_FILTERS = AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    public static final String EDIT_FILTER_CONFIGURATION = AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    private final Project myProject;
    private final DeviceContext myDeviceContext;
    private JPanel myPanel;
    private DefaultComboBoxModel myFilterComboBoxModel;
    private volatile IDevice myDevice;
    private final Object myLock;
    private final LogConsoleBase myLogConsole;
    private final AndroidLogFilterModel myLogFilterModel;
    private volatile Reader myCurrentReader;
    private volatile Writer myCurrentWriter;
    private final IDevice myPreselectedDevice;
    @NotNull
    private ConfiguredFilter mySelectedAppFilter;
    @NotNull
    private ConfiguredFilter myNoFilter;

    private void updateInUIThread() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AndroidLogcatView.this.myProject.isDisposed()) {
                    return;
                }
                AndroidLogcatView.this.updateLogConsole();
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public LogConsoleBase getLogConsole() {
        LogConsoleBase logConsoleBase = this.myLogConsole;
        if (logConsoleBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView", "getLogConsole"));
        }
        return logConsoleBase;
    }

    public void clearLogcat(@Nullable IDevice device) {
        if (device == null) {
            return;
        }
        AndroidLogcatUtil.clearLogcat(this.myProject, device);
        if (device.equals(this.getSelectedDevice())) {
            this.restartLogging();
        }
    }

    public AndroidLogcatView(@NotNull Project project, @NotNull IDevice preselectedDevice) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        if (preselectedDevice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedDevice", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        this(project, preselectedDevice, null);
    }

    public AndroidLogcatView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        this(project, null, deviceContext);
    }

    private AndroidLogcatView(final Project project, @Nullable IDevice preselectedDevice, @Nullable DeviceContext deviceContext) {
        this.myLock = new Object();
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.myPreselectedDevice = preselectedDevice;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myLogFilterModel = new AndroidLogFilterModel(){
            @Nullable
            private ConfiguredFilter myConfiguredFilter;

            @Override
            protected void setCustomFilter(String filter) {
                AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CUSTOM_FILTER = filter;
            }

            @Override
            protected void saveLogLevel(String logLevelName) {
                AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_LOG_LEVEL;
            }

            public String getCustomFilter() {
                return AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CUSTOM_FILTER;
            }

            @Override
            protected void setConfiguredFilter(@Nullable ConfiguredFilter filter) {
                AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CONFIGURED_FILTER = filter != null ? filter.getName() : "";
                this.myConfiguredFilter = filter;
            }

            @Override
            @Nullable
            protected ConfiguredFilter getConfiguredFilter() {
                return this.myConfiguredFilter;
            }
        };
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel);
        this.myLogConsole.addListener(new LogConsoleListener(){

            public void loggingWillBeStopped() {
                if (AndroidLogcatView.this.myCurrentWriter != null) {
                    try {
                        AndroidLogcatView.this.myCurrentWriter.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        if (preselectedDevice == null && deviceContext != null) {
            DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

                @Override
                public void deviceSelected(@Nullable IDevice device) {
                    AndroidLogcatView.this.updateInUIThread();
                }

                @Override
                public void deviceChanged(@NotNull IDevice device, int changeMask) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/logcat/AndroidLogcatView$4", "deviceChanged"));
                    }
                    if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                        AndroidLogcatView.this.myDevice = null;
                        AndroidLogcatView.this.updateInUIThread();
                    }
                }

                @Override
                public void clientSelected(@Nullable Client c) {
                    boolean reselect = AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() == AndroidLogcatView.this.mySelectedAppFilter;
                    AndroidConfiguredLogFilters.MyFilterEntry f = c != null ? AndroidConfiguredLogFilters.getInstance(AndroidLogcatView.this.myProject).createFilterForProcess(c.getClientData().getPid()) : new AndroidConfiguredLogFilters.MyFilterEntry();
                    int index = AndroidLogcatView.this.myFilterComboBoxModel.getIndexOf(AndroidLogcatView.this.mySelectedAppFilter);
                    if (index >= 0) {
                        AndroidLogcatView.this.myFilterComboBoxModel.removeElementAt(index);
                        AndroidLogcatView.this.mySelectedAppFilter = ConfiguredFilter.compile(f, SELECTED_APP_FILTER);
                        AndroidLogcatView.this.myFilterComboBoxModel.insertElementAt(AndroidLogcatView.this.mySelectedAppFilter, index);
                    }
                    if (reselect) {
                        AndroidLogcatView.this.myFilterComboBoxModel.setSelectedItem(AndroidLogcatView.this.mySelectedAppFilter);
                    }
                }
            };
            deviceContext.addListener(deviceSelectionListener, this);
        }
        this.mySelectedAppFilter = ConfiguredFilter.compile(new AndroidConfiguredLogFilters.MyFilterEntry(), SELECTED_APP_FILTER);
        this.myNoFilter = ConfiguredFilter.compile(new AndroidConfiguredLogFilters.MyFilterEntry(), NO_FILTERS);
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.myLogConsole.getOrCreateActions(), false);
            toolbar.setTargetComponent(console.getComponent());
            JComponent tbComp1 = toolbar.getComponent();
            this.myPanel.add((Component)tbComp1, "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public JPanel createSearchComponent() {
        JPanel panel = new JPanel();
        final JComboBox editFiltersCombo = new JComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        editFiltersCombo.setModel(this.myFilterComboBoxModel);
        String def = AndroidLogcatFiltersPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)def)) {
            def = this.myDeviceContext != null ? SELECTED_APP_FILTER : NO_FILTERS;
        }
        this.updateFilterCombobox(def);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener(){
            @Nullable
            private ConfiguredFilter myLastSelected;

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item instanceof ConfiguredFilter) {
                        this.myLastSelected = (ConfiguredFilter)item;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item instanceof ConfiguredFilter) {
                        AndroidLogcatView.this.applySelectedFilter();
                    } else {
                        assert (EDIT_FILTER_CONFIGURATION.equals(item));
                        EditLogFilterDialog dialog = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog.showAndGet()) {
                            AndroidConfiguredLogFilters.MyFilterEntry newEntry = dialog.getCustomLogFiltersEntry();
                            AndroidLogcatView.this.updateFilterCombobox(newEntry != null ? newEntry.getName() : null);
                        } else {
                            editFiltersCombo.setSelectedItem(this.myLastSelected);
                        }
                    }
                }
            }
        });
        editFiltersCombo.setRenderer(new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ConfiguredFilter) {
                    this.setBorder(null);
                    this.append(((ConfiguredFilter)value).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value.toString());
                }
            }
        });
        panel.add(editFiltersCombo);
        JPanel searchComponent = new JPanel();
        searchComponent.setLayout(new BoxLayout(searchComponent, 0));
        searchComponent.add(this.myLogConsole.getSearchComponent());
        searchComponent.add(panel);
        JPanel jPanel = searchComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView", "createSearchComponent"));
        }
        return jPanel;
    }

    protected abstract boolean isActive();

    public void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
            this.updateFilterCombobox(AndroidLogcatFiltersPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER);
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            Object object = this.myLock;
            synchronized (object) {
                this.myDevice = device;
                if (this.myCurrentWriter != null) {
                    try {
                        this.myCurrentWriter.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (this.myCurrentReader != null) {
                    try {
                        this.myCurrentReader.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (device != null) {
                    Pair<Reader, Writer> pair;
                    ConsoleView console = this.myLogConsole.getConsole();
                    if (console != null) {
                        console.clear();
                    }
                    if ((pair = AndroidLogcatUtil.startLoggingThread(this.myProject, device, false, this.myLogConsole)) != null) {
                        this.myCurrentReader = (Reader)pair.first;
                        this.myCurrentWriter = (Writer)pair.second;
                    } else {
                        this.myCurrentReader = null;
                        this.myCurrentWriter = null;
                    }
                }
            }
        }
    }

    @Nullable
    public IDevice getSelectedDevice() {
        if (this.myPreselectedDevice != null) {
            return this.myPreselectedDevice;
        }
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter = this.myFilterComboBoxModel.getSelectedItem();
        if (filter instanceof ConfiguredFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/logcat/AndroidLogcatView$7", "run"));
                    }
                    AndroidLogcatView.this.myLogFilterModel.updateConfiguredFilter((ConfiguredFilter)filter);
                }
            });
        }
    }

    private void updateFilterCombobox(String select) {
        AndroidConfiguredLogFilters filters = AndroidConfiguredLogFilters.getInstance(this.myProject);
        List<AndroidConfiguredLogFilters.MyFilterEntry> entries = filters.getFilterEntries();
        this.myFilterComboBoxModel.removeAllElements();
        if (this.myDeviceContext != null) {
            this.myFilterComboBoxModel.addElement(this.mySelectedAppFilter);
        }
        this.myFilterComboBoxModel.addElement(this.myNoFilter);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION);
        for (AndroidConfiguredLogFilters.MyFilterEntry entry : entries) {
            String name = entry.getName();
            ConfiguredFilter filter = ConfiguredFilter.compile(entry, entry.getName());
            this.myFilterComboBoxModel.addElement(filter);
            if (!name.equals(select)) continue;
            this.myFilterComboBoxModel.setSelectedItem(filter);
        }
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    public void dispose() {
    }

    private void restartLogging() {
        this.myDevice = null;
        this.updateLogConsole();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public class AndroidLogConsole
    extends LogConsoleBase {
        public AndroidLogConsole(Project project, AndroidLogFilterModel logFilterModel) {
            super(project, (Reader)new MyLoggingReader(), "", false, (LogFilterModel)logFilterModel);
            ConsoleView console = this.getConsole();
            if (console instanceof ConsoleViewImpl) {
                ConsoleViewImpl c = (ConsoleViewImpl)console;
                c.addCustomConsoleAction((AnAction)new Separator());
                c.addCustomConsoleAction((AnAction)new MyRestartAction());
            }
        }

        public boolean isActive() {
            return AndroidLogcatView.this.isActive();
        }

        public void clearLogcat() {
            AndroidLogcatView.this.clearLogcat(AndroidLogcatView.this.getSelectedDevice());
        }
    }

    private class MyRestartAction
    extends AnAction {
        public MyRestartAction() {
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLogcatView.this.restartLogging();
        }
    }

    private class MyLoggingReader
    extends AndroidLoggingReader {
        private MyLoggingReader() {
        }

        @Override
        @NotNull
        protected Object getLock() {
            Object object = AndroidLogcatView.this.myLock;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView$MyLoggingReader", "getLock"));
            }
            return object;
        }

        @Override
        protected Reader getReader() {
            return AndroidLogcatView.this.myCurrentReader;
        }
    }
}

