/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.XsltBreakpointType;
import org.intellij.plugins.xsltDebugger.impl.XsltDebugProcess;
import org.intellij.plugins.xsltDebugger.rt.engine.Breakpoint;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
    private XsltDebugProcess myXsltDebugProcess;

    public XsltBreakpointHandler(XsltDebugProcess xsltDebugProcess, Class<? extends XsltBreakpointType> typeClass) {
        super(typeClass);
        this.myXsltDebugProcess = xsltDebugProcess;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/intellij/plugins/xsltDebugger/impl/XsltBreakpointHandler", "registerBreakpoint"));
        }
        XSourcePosition sourcePosition = breakpoint.getSourcePosition();
        if (sourcePosition == null || !sourcePosition.getFile().exists() || !sourcePosition.getFile().isValid()) {
            return;
        }
        VirtualFile file = sourcePosition.getFile();
        Project project = this.myXsltDebugProcess.getSession().getProject();
        String fileURL = XsltBreakpointHandler.getFileURL(file);
        int lineNumber = XsltBreakpointHandler.getActualLineNumber(breakpoint, project);
        if (lineNumber == -1) {
            XDebugSession session = this.myXsltDebugProcess.getSession();
            session.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, "Unsupported breakpoint position");
            return;
        }
        try {
            BreakpointManager manager = this.myXsltDebugProcess.getBreakpointManager();
            Breakpoint bp = manager.getBreakpoint(fileURL, lineNumber);
            if (bp != null) {
                bp.setEnabled(true);
            } else {
                manager.setBreakpoint(fileURL, lineNumber);
            }
        }
        catch (DebuggerStoppedException manager) {
        }
        catch (VMPausedException e) {
            XDebugSession session = this.myXsltDebugProcess.getSession();
            session.reportMessage("Target VM is not responding. Breakpoint can not be set", MessageType.ERROR);
            session.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, "Target VM is not responding. Breakpoint can not be set");
        }
    }

    public static String getFileURL(VirtualFile file) {
        return VfsUtil.virtualToIoFile((VirtualFile)file).toURI().toASCIIString();
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, boolean temporary) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/intellij/plugins/xsltDebugger/impl/XsltBreakpointHandler", "unregisterBreakpoint"));
        }
        XSourcePosition sourcePosition = breakpoint.getSourcePosition();
        if (sourcePosition == null || !sourcePosition.getFile().exists() || !sourcePosition.getFile().isValid()) {
            return;
        }
        VirtualFile file = sourcePosition.getFile();
        Project project = this.myXsltDebugProcess.getSession().getProject();
        String fileURL = XsltBreakpointHandler.getFileURL(file);
        int lineNumber = XsltBreakpointHandler.getActualLineNumber(breakpoint, project);
        try {
            BreakpointManager manager = this.myXsltDebugProcess.getBreakpointManager();
            if (temporary) {
                Breakpoint bp = manager.getBreakpoint(fileURL, lineNumber);
                if (bp != null) {
                    bp.setEnabled(false);
                }
            } else {
                manager.removeBreakpoint(fileURL, lineNumber);
            }
        }
        catch (DebuggerStoppedException manager) {
        }
        catch (VMPausedException e) {
            this.myXsltDebugProcess.getSession().reportMessage("Target VM is not responding. Breakpoint can not be removed", MessageType.ERROR);
        }
    }

    public static int getActualLineNumber(XLineBreakpoint breakpoint, Project project) {
        return XsltBreakpointHandler.getActualLineNumber(project, breakpoint.getSourcePosition());
    }

    public static int getActualLineNumber(Project project, @Nullable XSourcePosition position) {
        IElementType tokenType;
        if (position == null) {
            return -1;
        }
        PsiElement element = XsltBreakpointHandler.findContextElement(project, position);
        if (element == null) {
            return -1;
        }
        if (element instanceof XmlToken && ((tokenType = ((XmlToken)element).getTokenType()) == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_NAME)) {
            XmlTag tag;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = psiManager.findFile(position.getFile());
            if (psiFile == null) {
                return -1;
            }
            Document document = documentManager.getDocument(psiFile);
            if (document == null) {
                return -1;
            }
            if (document.getLineNumber(element.getTextRange().getStartOffset()) == position.getLine() && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false)) != null) {
                ASTNode node = tag.getNode();
                assert (node != null);
                ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(node);
                if (end != null) {
                    return document.getLineNumber(end.getTextRange().getEndOffset()) + 1;
                }
                ASTNode end2 = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(node);
                if (end2 != null) {
                    return document.getLineNumber(end2.getTextRange().getEndOffset()) + 1;
                }
            }
        }
        return -1;
    }

    @Nullable
    public static PsiElement findContextElement(Project project, @Nullable XSourcePosition position) {
        if (position == null) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(position.getFile());
        if (file == null) {
            return null;
        }
        int offset = -1;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document != null && document.getLineCount() > position.getLine() && position.getLine() >= 0) {
            offset = document.getLineStartOffset(position.getLine());
        }
        if (offset < 0) {
            offset = position.getOffset();
        }
        PsiElement contextElement = file.findElementAt(offset);
        while (contextElement != null && !(contextElement instanceof XmlElement)) {
            contextElement = PsiTreeUtil.nextLeaf((PsiElement)contextElement);
        }
        return contextElement;
    }
}

