/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.common.RepositoryPathProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentListener;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderOnStoredRepositoryPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;

public class GetDirectoriesListViaUpdateOperation
extends LocalPathIndifferentOperation
implements DirectoryContentProvider {
    private final DirectoryContentListener myDirectoryContentListener = new DirectoryContentListener();
    private DirectoryContentListener myStreamingDirectoryContentListener = null;
    private long timeStamp = System.currentTimeMillis();
    private Consumer<DirectoryContent> myStreamingListener;

    public GetDirectoriesListViaUpdateOperation(CvsEnvironment env, String parentDirectoryName) {
        super((IAdminReader)new AdminReaderOnStoredRepositoryPath(GetDirectoriesListViaUpdateOperation.createRepositoryPathProvider(parentDirectoryName)), env);
        this.addFinishAction(new Runnable(){

            @Override
            public void run() {
                if (GetDirectoriesListViaUpdateOperation.this.myStreamingListener != null) {
                    GetDirectoriesListViaUpdateOperation.this.myStreamingListener.consume((Object)GetDirectoriesListViaUpdateOperation.this.myStreamingDirectoryContentListener.getDirectoryContent());
                }
            }
        });
    }

    public static RepositoryPathProvider createRepositoryPathProvider(final String parentDirName) {
        return new RepositoryPathProvider(){

            @Override
            public String getRepositoryPath(String repository) {
                String result = repository;
                if (!StringUtil.endsWithChar((CharSequence)result, (char)'/')) {
                    result = result + "/";
                }
                return result + parentDirName;
            }
        };
    }

    @Override
    public void modifyOptions(GlobalOptions options) {
        super.modifyOptions(options);
        options.setDoNoChanges(true);
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        UpdateCommand command = new UpdateCommand();
        command.setBuildDirectories(true);
        command.setRecursive(true);
        root.getRevisionOrDate().setForCommand((Command)command);
        return command;
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        if (this.myStreamingListener != null) {
            this.myStreamingDirectoryContentListener.messageSent(message);
            long timePassed = System.currentTimeMillis() - this.timeStamp;
            DirectoryContent streamingContent = this.myStreamingDirectoryContentListener.getDirectoryContent();
            int size = streamingContent.getTotalSize();
            if (timePassed > 25L && size > 0) {
                this.myStreamingListener.consume((Object)streamingContent);
                this.myStreamingDirectoryContentListener = new DirectoryContentListener();
                this.timeStamp = System.currentTimeMillis();
            }
        } else {
            this.myDirectoryContentListener.messageSent(message);
        }
    }

    @Override
    public DirectoryContent getDirectoryContent() {
        return this.myDirectoryContentListener.getDirectoryContent();
    }

    @Override
    protected String getOperationName() {
        return "update";
    }

    @Override
    public void setStreamingListener(Consumer<DirectoryContent> streamingListener) {
        this.myStreamingListener = streamingListener;
        this.myStreamingDirectoryContentListener = new DirectoryContentListener();
    }
}

