/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import gnu.trove.TIntObjectHashMap;
import javax.swing.Icon;

public class ElementPresentationUtil
implements PlatformIcons {
    public static final int CLASS_KIND_CLASS = 30;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND_KEY");
    private static final TIntObjectHashMap<Icon> BASE_ICON = new TIntObjectHashMap(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element, boolean isLocked) {
        boolean isEnum = element instanceof PsiClass && ((PsiClass)element).isEnum();
        int flags = (element.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element instanceof PsiClass) {
            int kind;
            PsiClass aClass = (PsiClass)element;
            if (element.hasModifierProperty("abstract") && !((PsiClass)element).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    public static RowIcon createLayeredIcon(Icon baseIcon, PsiModifierListOwner element, boolean isLocked) {
        return ElementBase.createLayeredIcon(element, baseIcon, ElementPresentationUtil.getFlags(element, isLocked));
    }

    public static int getBasicClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(final PsiClass aClass) {
        if (!aClass.isValid()) {
            aClass.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue<Integer> value2 = aClass.getUserData(CLASS_KIND_KEY);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager(aClass.getProject()).createCachedValue(new CachedValueProvider<Integer>(){

                @Override
                public CachedValueProvider.Result<Integer> compute() {
                    return CachedValueProvider.Result.createSingleDependency(ElementPresentationUtil.getClassKindImpl(aClass), aClass);
                }
            }, false);
            aClass.putUserData(CLASS_KIND_KEY, value2);
        }
        return value2.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance(aClass.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf(aClass, javaLangTrowable, true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass(aClass, false) && PsiMethodUtil.findMainMethod(aClass) != null) {
                return 100;
            }
        }
        return 30;
    }

    public static Icon getClassIconOfKind(PsiClass aClass, int classKind) {
        boolean isAbstract = aClass.hasModifierProperty("abstract");
        return BASE_ICON.get(classKind | (isAbstract ? 256 : 0));
    }

    public static String getDescription(PsiModifierListOwner member) {
        String noun;
        if (member instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member);
        } else if (member instanceof PsiMethod) {
            noun = CodeInsightBundle.message("node.method.tooltip", new Object[0]);
        } else if (member instanceof PsiField) {
            noun = CodeInsightBundle.message("node.field.tooltip", new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass);
        switch (kind) {
            case 20: {
                noun = CodeInsightBundle.message("node.annotation.tooltip", new Object[0]);
                break;
            }
            case 40: {
                noun = CodeInsightBundle.message("node.anonymous.class.tooltip", new Object[0]);
                break;
            }
            case 50: {
                noun = CodeInsightBundle.message("node.enum.tooltip", new Object[0]);
                break;
            }
            case 80: {
                noun = CodeInsightBundle.message("node.exception.tooltip", new Object[0]);
                break;
            }
            case 10: {
                noun = CodeInsightBundle.message("node.interface.tooltip", new Object[0]);
                break;
            }
            case 90: {
                noun = CodeInsightBundle.message("node.junit.test.tooltip", new Object[0]);
                break;
            }
            case 100: {
                noun = CodeInsightBundle.message("node.runnable.class.tooltip", new Object[0]);
                break;
            }
            default: {
                noun = CodeInsightBundle.message("node.class.tooltip", new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass) {
        int level;
        PsiModifierList list;
        int flags = ElementPresentationUtil.getFlags(aClass, false);
        String adj = "";
        for (IconLayerProvider provider : Extensions.getExtensions(IconLayerProvider.EP_NAME)) {
            if (provider.getLayerIcon(aClass, false) == null) continue;
            adj = adj + " " + provider.getLayerDescription();
        }
        if ((flags & 0x100) != 0) {
            adj = adj + " " + CodeInsightBundle.message("node.abstract.flag.tooltip", new Object[0]);
        }
        if ((flags & 0x400) != 0) {
            adj = adj + " " + CodeInsightBundle.message("node.final.flag.tooltip", new Object[0]);
        }
        if ((flags & 0x200) != 0) {
            adj = adj + " " + CodeInsightBundle.message("node.static.flag.tooltip", new Object[0]);
        }
        if ((list = aClass.getModifierList()) != null && (level = PsiUtil.getAccessLevel(list)) != 4) {
            adj = adj + " " + StringUtil.capitalize(PsiBundle.visibilityPresentation(PsiUtil.getAccessModifier(level)));
        }
        return adj;
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, RowIcon baseIcon) {
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon(element.getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    static {
        BASE_ICON.put(30, CLASS_ICON);
        BASE_ICON.put(286, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(20, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(276, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(40, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(296, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(60, ASPECT_ICON);
        BASE_ICON.put(316, ASPECT_ICON);
        BASE_ICON.put(50, ENUM_ICON);
        BASE_ICON.put(306, ENUM_ICON);
        BASE_ICON.put(80, EXCEPTION_CLASS_ICON);
        BASE_ICON.put(336, AllIcons.Nodes.AbstractException);
        BASE_ICON.put(10, INTERFACE_ICON);
        BASE_ICON.put(266, INTERFACE_ICON);
        BASE_ICON.put(90, CLASS_ICON);
        BASE_ICON.put(346, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(100, CLASS_ICON);
        ElementBase.registerIconLayer(512, AllIcons.Nodes.StaticMark);
        ElementBase.registerIconLayer(1024, AllIcons.Nodes.FinalMark);
        ElementBase.registerIconLayer(8192, AllIcons.Nodes.JunitTestMark);
        ElementBase.registerIconLayer(16384, AllIcons.Nodes.RunnableMark);
    }
}

