/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import kotlin.ArraysKt;
import kotlin.IndexedValue;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!-Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001b\u0002\u0003d\u00031\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)c\u0002b\u0002\t\u00045\t\u0001DA\r\n\u0011\u000biq!\u0003\u0002\n\u0003a\u001d\u0011BA\u0005\u00021\u0011A2!\n\u0005\u0005\b!%Q\"\u0001\r\u00033\rAQ!D\u0001\u0019\f\u0015bAq\u0001\u0005\u0007\u001b\u0005AB!G\u0002\t\u000e5\t\u0001DA\r\u0004\u0011\u001di\u0011\u0001g\u0002&\u0011\u0011\u001d\u0001rB\u0007\u00021!I2\u0001#\u0004\u000e\u0003a\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils;", "", "()V", "computeMask", "", "hasModifier", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "computeMaskFromModifierList", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "maskHasModifier", "mask", "modifierToken", "maskToString", ""}, moduleName="kotlin-compiler")
public final class ModifierMaskUtils {
    public static final ModifierMaskUtils INSTANCE;
    public static final ModifierMaskUtils INSTANCE$;

    @JvmStatic
    public static final int computeMaskFromModifierList(@NotNull KtModifierList modifierList) {
        Intrinsics.checkParameterIsNotNull(modifierList, "modifierList");
        return ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, ? extends Boolean>)new Function1<KtModifierKeywordToken, Boolean>(modifierList){
            final /* synthetic */ KtModifierList $modifierList;

            public final boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.$modifierList.hasModifier(it);
            }
            {
                this.$modifierList = ktModifierList;
                super(1);
            }
        });
    }

    @JvmStatic
    public static final int computeMask(@NotNull Function1<? super KtModifierKeywordToken, ? extends Boolean> hasModifier) {
        Intrinsics.checkParameterIsNotNull(hasModifier, "hasModifier");
        int mask = 0;
        for (IndexedValue<Object> indexedValue : ArraysKt.withIndex((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY)) {
            KtModifierKeywordToken modifierKeywordToken;
            int index2 = indexedValue.component1();
            KtModifierKeywordToken ktModifierKeywordToken = modifierKeywordToken = (KtModifierKeywordToken)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "modifierKeywordToken");
            if (!hasModifier.invoke(ktModifierKeywordToken).booleanValue()) continue;
            mask |= 1 << index2;
        }
        return mask;
    }

    @JvmStatic
    public static final boolean maskHasModifier(int mask, @NotNull KtModifierKeywordToken modifierToken) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(modifierToken, "modifierToken");
        int index2 = ArraysKt.indexOf((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        boolean value2 = index2 >= 0;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "All JetModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return (mask & 1 << index2) != 0;
    }

    @JvmStatic
    @NotNull
    public static final String maskToString(int mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
            KtModifierKeywordToken modifierKeyword;
            KtModifierKeywordToken ktModifierKeywordToken = modifierKeyword = ktModifierKeywordTokenArray[i];
            Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "modifierKeyword");
            if (!ModifierMaskUtils.maskHasModifier(mask, ktModifierKeywordToken)) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first = false;
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    static {
        new ModifierMaskUtils();
    }

    private ModifierMaskUtils() {
        Unit unit;
        INSTANCE = this;
        INSTANCE$ = this;
        Object[] $receiver = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        boolean value2 = $receiver.length <= 32;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Current implementation depends on the ability to represent modifier list as bit mask";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
    }
}

