/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRemote
implements Comparable<GitRemote> {
    public static final GitRemote DOT = new GitRemote(".", Collections.singletonList("."), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList());
    public static final String ORIGIN_NAME = "origin";
    @NotNull
    private final String myName;
    @NotNull
    private final List<String> myUrls;
    @NotNull
    private final Collection<String> myPushUrls;
    @NotNull
    final List<String> myFetchRefSpecs;
    @NotNull
    private final List<String> myPushRefSpecs;

    public GitRemote(@NotNull String name, @NotNull List<String> urls, @NotNull Collection<String> pushUrls, @NotNull List<String> fetchRefSpecs, @NotNull List<String> pushRefSpecs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/repo/GitRemote", "<init>"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "git4idea/repo/GitRemote", "<init>"));
        }
        if (pushUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushUrls", "git4idea/repo/GitRemote", "<init>"));
        }
        if (fetchRefSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchRefSpecs", "git4idea/repo/GitRemote", "<init>"));
        }
        if (pushRefSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushRefSpecs", "git4idea/repo/GitRemote", "<init>"));
        }
        this.myName = name;
        this.myUrls = urls;
        this.myPushUrls = pushUrls;
        this.myFetchRefSpecs = fetchRefSpecs;
        this.myPushRefSpecs = pushRefSpecs;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRemote", "getName"));
        }
        return string;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> list = this.myUrls;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRemote", "getUrls"));
        }
        return list;
    }

    @Nullable
    public String getFirstUrl() {
        return this.myUrls.isEmpty() ? null : this.myUrls.get(0);
    }

    @NotNull
    public Collection<String> getPushUrls() {
        Collection<String> collection = this.myPushUrls;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRemote", "getPushUrls"));
        }
        return collection;
    }

    @NotNull
    public List<String> getFetchRefSpecs() {
        List<String> list = this.myFetchRefSpecs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRemote", "getFetchRefSpecs"));
        }
        return list;
    }

    @NotNull
    public List<String> getPushRefSpecs() {
        List<String> list = this.myPushRefSpecs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRemote", "getPushRefSpecs"));
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRemote gitRemote = (GitRemote)o;
        return this.myName.equals(gitRemote.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return String.format("GitRemote{myName='%s', myUrls=%s, myPushUrls=%s, myFetchRefSpec='%s', myPushRefSpec='%s'}", this.myName, this.myUrls, this.myPushUrls, this.myFetchRefSpecs, this.myPushRefSpecs);
    }

    @Override
    public int compareTo(@NotNull GitRemote o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "git4idea/repo/GitRemote", "compareTo"));
        }
        return this.getName().compareTo(o.getName());
    }
}

