/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class ExtensionPointDocumentationProvider
extends DocumentationProviderEx {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        XmlFile epDeclarationFile = (XmlFile)extensionPoint.getXmlTag().getContainingFile();
        Module epModule = ModuleUtilCore.findModuleForFile((VirtualFile)epDeclarationFile.getVirtualFile(), (Project)element.getProject());
        String epPrefix = extensionPoint.getNamePrefix();
        PsiClass epClass = ExtensionPointDocumentationProvider.getExtensionPointClass(extensionPoint);
        StringBuilder epClassText = new StringBuilder();
        if (epClass != null) {
            JavaDocInfoGenerator.generateType((StringBuilder)epClassText, (PsiType)PsiTypesUtil.getClassType((PsiClass)epClass), (PsiElement)epClass, (boolean)true);
        } else {
            epClassText.append("<unknown>");
        }
        return (epModule == null ? "" : "[" + epModule.getName() + "]") + (epPrefix == null ? "" : " " + epPrefix) + "<br/>" + "<b>" + extensionPoint.getEffectiveName() + "</b>" + " (" + epDeclarationFile.getName() + ")<br/>" + epClassText.toString();
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        PsiClass epClass = ExtensionPointDocumentationProvider.getExtensionPointClass(extensionPoint);
        if (epClass != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<em>EP Definition</em><br/>");
            String quickInfo = StringUtil.notNullize((String)this.getQuickNavigateInfo(element, originalElement));
            sb.append(quickInfo);
            sb.append("<br/>");
            sb.append("<br/>");
            sb.append("<em>EP Implementation</em>");
            sb.append(JavaDocumentationProvider.generateExternalJavadoc((PsiElement)epClass));
            return sb.toString();
        }
        return null;
    }

    @Nullable
    private static ExtensionPoint findExtensionPoint(PsiElement element) {
        DomElement domElement;
        PomTarget pomTarget;
        if (element instanceof PomTargetPsiElement && DescriptorUtil.isPluginXml(element.getContainingFile()) && (pomTarget = ((PomTargetPsiElement)element).getTarget()) instanceof DomTarget && (domElement = ((DomTarget)pomTarget).getDomElement()) instanceof ExtensionPoint) {
            return (ExtensionPoint)domElement;
        }
        return null;
    }

    @Nullable
    private static PsiClass getExtensionPointClass(ExtensionPoint extensionPoint) {
        return DomUtil.hasXml(extensionPoint.getInterface()) ? (PsiClass)extensionPoint.getInterface().getValue() : (PsiClass)extensionPoint.getBeanClass().getValue();
    }
}

