/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.ide.palette.impl.PaletteGroupHeader;
import com.intellij.ide.palette.impl.PaletteWindow;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicListUI;
import org.jetbrains.annotations.Nullable;

public class PaletteComponentList
extends JBList {
    private final Project myProject;
    private final PaletteWindow myPalette;
    private final PaletteGroup myGroup;
    private int myHoverIndex = -1;
    private int myBeforeClickSelectedRow = -1;
    private int myDropTargetIndex = -1;
    private boolean myNeedClearSelection = false;
    Integer myTempWidth;

    public PaletteComponentList(Project project, PaletteWindow palette, PaletteGroup group) {
        this.myProject = project;
        this.myPalette = palette;
        this.myGroup = group;
        this.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return PaletteComponentList.this.myGroup.getItems().length;
            }

            @Override
            public Object getElementAt(int index) {
                return PaletteComponentList.this.myGroup.getItems()[index];
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PaletteComponentList.this.setHoverIndex(PaletteComponentList.this.locationToIndex(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PaletteComponentList.this.setHoverIndex(-1);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PaletteComponentList.this.myNeedClearSelection = SwingUtilities.isLeftMouseButton(e) && PaletteComponentList.this.myBeforeClickSelectedRow >= 0 && PaletteComponentList.this.locationToIndex(e.getPoint()) == PaletteComponentList.this.myBeforeClickSelectedRow && !UIUtil.isControlKeyDown((MouseEvent)e) && !e.isShiftDown();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && PaletteComponentList.this.myBeforeClickSelectedRow >= 0 && PaletteComponentList.this.locationToIndex(e.getPoint()) == PaletteComponentList.this.myBeforeClickSelectedRow && !UIUtil.isControlKeyDown((MouseEvent)e) && !e.isShiftDown() && PaletteComponentList.this.myNeedClearSelection) {
                    PaletteComponentList.this.clearSelection();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(final Component comp, final int x, final int y) {
                PaletteComponentList.this.requestFocusInWindow();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int index = PaletteComponentList.this.locationToIndex(new Point(x, y));
                        PaletteItem[] items = PaletteComponentList.this.myGroup.getItems();
                        if (index >= 0 && index < items.length) {
                            PaletteItem item;
                            ActionGroup group;
                            if (PaletteComponentList.this.getSelectedIndex() != index) {
                                PaletteComponentList.this.addSelectionInterval(index, index);
                            }
                            if ((group = (item = items[index]).getPopupActionGroup()) != null) {
                                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", group);
                                popupMenu.getComponent().show(comp, x, y);
                            }
                        }
                    }
                });
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PaletteComponentList.this.setHoverIndex(PaletteComponentList.this.locationToIndex(e.getPoint()));
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                PaletteComponentList.this.myPalette.notifyKeyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PaletteComponentList.this.myPalette.notifyKeyEvent(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                PaletteComponentList.this.myPalette.notifyKeyEvent(e);
            }
        });
        this.setCellRenderer((ListCellRenderer)((Object)new ComponentCellRenderer()));
        this.setVisibleRowCount(0);
        this.setLayoutOrientation(2);
        this.setSelectionMode(0);
        DnDManager dndManager = DnDManager.getInstance();
        dndManager.registerSource((DnDSource)new MyDnDSource(), (JComponent)((Object)this));
        dndManager.registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)((Object)this));
        this.initActions();
    }

    private void setHoverIndex(int index) {
        if (index != this.myHoverIndex) {
            if (this.myHoverIndex >= 0) {
                this.repaint(this.getCellBounds(this.myHoverIndex, this.myHoverIndex));
            }
            this.myHoverIndex = index;
            if (this.myHoverIndex >= 0) {
                this.repaint(this.getCellBounds(this.myHoverIndex, this.myHoverIndex));
            }
        }
    }

    private void setDropTargetIndex(int index) {
        if (index != this.myDropTargetIndex) {
            this.myDropTargetIndex = index;
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI(new ComponentListUI());
        this.invalidate();
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("selectPreviousRow", new MoveFocusAction(map.get("selectPreviousRow"), false));
        map.put("selectNextRow", new MoveFocusAction(map.get("selectNextRow"), true));
        map.put("selectPreviousColumn", new MoveFocusAction(new ChangeColumnAction(map.get("selectPreviousColumn"), false), false));
        map.put("selectNextColumn", new MoveFocusAction(new ChangeColumnAction(map.get("selectNextColumn"), true), true));
    }

    public int getWidth() {
        return this.myTempWidth == null ? super.getWidth() : this.myTempWidth.intValue();
    }

    public int getPreferredHeight(int width) {
        this.myTempWidth = width;
        try {
            int n = this.getUI().getPreferredSize((JComponent)((Object)this)).height;
            return n;
        }
        finally {
            this.myTempWidth = null;
        }
    }

    public void takeFocusFrom(PaletteGroupHeader paletteGroup, int indexToSelect) {
        if (indexToSelect == -1) {
            indexToSelect = this.getModel().getSize() - 1;
        } else if (this.getModel().getSize() == 0) {
            indexToSelect = -1;
        }
        this.requestFocus();
        this.setSelectedIndex(indexToSelect);
        if (indexToSelect >= 0) {
            this.ensureIndexIsVisible(indexToSelect);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myDropTargetIndex >= 0) {
            int dropLineY;
            Rectangle rc;
            if (this.myDropTargetIndex == this.myGroup.getItems().length) {
                rc = this.getCellBounds(this.myDropTargetIndex - 1, this.myDropTargetIndex - 1);
                dropLineY = (int)rc.getMaxY() - 1;
            } else {
                rc = this.getCellBounds(this.myDropTargetIndex, this.myDropTargetIndex);
                dropLineY = rc.y;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(PlatformColors.BLUE);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawLine(rc.x, dropLineY, rc.x + rc.width, dropLineY);
            g2d.drawLine(rc.x, dropLineY - 2, rc.x, dropLineY + 2);
            g2d.drawLine(rc.x + rc.width, dropLineY - 2, rc.x + rc.width, dropLineY + 2);
        }
    }

    private class MyDnDSource
    implements DnDSource {
        private MyDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            int index = PaletteComponentList.this.locationToIndex(dragOrigin);
            return index >= 0 && PaletteComponentList.this.myGroup.getItems()[index].startDragging() != null;
        }

        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            int index = PaletteComponentList.this.locationToIndex(dragOrigin);
            if (index < 0) {
                return null;
            }
            return PaletteComponentList.this.myGroup.getItems()[index].startDragging();
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            return null;
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
            PaletteComponentList.this.myPalette.notifyDropActionChanged(gestureModifiers);
        }
    }

    private class MyDnDTarget
    implements DnDTarget {
        private MyDnDTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            PaletteComponentList.this.setHoverIndex(-1);
            if (aEvent.getAttachedObject() instanceof PaletteItem) {
                PaletteComponentList.this.setDropTargetIndex(this.locationToTargetIndex(aEvent.getPoint()));
                aEvent.setDropPossible(true);
            } else {
                PaletteComponentList.this.setDropTargetIndex(-1);
                aEvent.setDropPossible(false);
            }
            return false;
        }

        public void drop(DnDEvent aEvent) {
            int index;
            PaletteComponentList.this.setDropTargetIndex(-1);
            if (aEvent.getAttachedObject() instanceof PaletteItem && (index = this.locationToTargetIndex(aEvent.getPoint())) >= 0) {
                PaletteComponentList.this.myGroup.handleDrop(PaletteComponentList.this.myProject, (PaletteItem)aEvent.getAttachedObject(), index);
            }
        }

        public void cleanUpOnLeave() {
            PaletteComponentList.this.setDropTargetIndex(-1);
        }

        private int locationToTargetIndex(Point location) {
            int row = PaletteComponentList.this.locationToIndex(location);
            if (row < 0) {
                return -1;
            }
            Rectangle rc = PaletteComponentList.this.getCellBounds(row, row);
            return (double)location.y < rc.getCenterY() ? row : row + 1;
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }

    private class ChangeColumnAction
    extends AbstractAction {
        private final Action defaultAction;
        private final boolean selectNext;

        public ChangeColumnAction(Action defaultAction, boolean selectNext) {
            this.defaultAction = defaultAction;
            this.selectNext = selectNext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selIndexBefore = PaletteComponentList.this.getSelectedIndex();
            this.defaultAction.actionPerformed(e);
            int selIndexCurrent = PaletteComponentList.this.getSelectedIndex();
            if (this.selectNext && selIndexBefore < selIndexCurrent || !this.selectNext && selIndexBefore > selIndexCurrent) {
                return;
            }
            if (this.selectNext) {
                if (selIndexCurrent == selIndexBefore + 1) {
                    ++selIndexCurrent;
                }
                if (selIndexCurrent < PaletteComponentList.this.getModel().getSize() - 1) {
                    PaletteComponentList.this.setSelectedIndex(selIndexCurrent + 1);
                    PaletteComponentList.this.scrollRectToVisible(PaletteComponentList.this.getCellBounds(selIndexCurrent + 1, selIndexCurrent + 1));
                }
            } else if (selIndexCurrent > 0) {
                PaletteComponentList.this.setSelectedIndex(selIndexCurrent - 1);
                PaletteComponentList.this.scrollRectToVisible(PaletteComponentList.this.getCellBounds(selIndexCurrent - 1, selIndexCurrent - 1));
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final Action defaultAction;
        private final boolean focusNext;

        public MoveFocusAction(Action defaultAction, boolean focusNext) {
            this.defaultAction = defaultAction;
            this.focusNext = focusNext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component next;
            int selIndexBefore = PaletteComponentList.this.getSelectedIndex();
            this.defaultAction.actionPerformed(e);
            int selIndexCurrent = PaletteComponentList.this.getSelectedIndex();
            if (selIndexBefore != selIndexCurrent) {
                return;
            }
            if (this.focusNext && 0 == selIndexCurrent) {
                return;
            }
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = kfm.getCurrentFocusCycleRoot();
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            if (null == policy) {
                policy = kfm.getDefaultFocusTraversalPolicy();
            }
            Component component = next = this.focusNext ? policy.getComponentAfter(container, (Component)((Object)PaletteComponentList.this)) : policy.getComponentBefore(container, (Component)((Object)PaletteComponentList.this));
            if (null != next && next instanceof PaletteGroupHeader) {
                PaletteComponentList.this.clearSelection();
                next.requestFocus();
                ((PaletteGroupHeader)next).scrollRectToVisible(next.getBounds());
            }
        }
    }

    private static class ComponentCellRenderer
    extends ColoredListCellRenderer {
        private ComponentCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            PaletteItem paletteItem = (PaletteItem)value;
            this.clear();
            paletteItem.customizeCellRenderer(this, selected, hasFocus);
        }
    }

    class ComponentListUI
    extends BasicListUI {
        private ComponentListListener myListener;

        ComponentListUI() {
        }

        @Override
        protected void updateLayoutState() {
            super.updateLayoutState();
            if (this.list.getLayoutOrientation() == 2) {
                Insets insets = this.list.getInsets();
                int listWidth = this.list.getWidth() - (insets.left + insets.right);
                if (listWidth >= this.cellWidth) {
                    int columnCount = listWidth / this.cellWidth;
                    this.cellWidth = columnCount == 0 ? 1 : listWidth / columnCount;
                }
            }
        }

        @Override
        protected void installListeners() {
            this.myListener = new ComponentListListener();
            PaletteComponentList.this.addMouseListener(this.myListener);
            super.installListeners();
        }

        @Override
        protected void uninstallListeners() {
            if (this.myListener != null) {
                PaletteComponentList.this.removeMouseListener(this.myListener);
            }
            super.uninstallListeners();
        }

        private class ComponentListListener
        extends MouseAdapter {
            private ComponentListListener() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PaletteComponentList.this.myBeforeClickSelectedRow = ComponentListUI.this.list.getSelectedIndex();
            }
        }
    }
}

