/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.lang.reflect.Array;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.api.JSONEncodable;
import javajs.util.AU;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.T4;

@J2SIgnoreImport(value={Array.class})
public class PT {
    public static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};
    public static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f, 1.0E-9f};
    public static final float FLOAT_MIN_SAFE = Float.MIN_VALUE;
    private static final String escapable = "\\\\\tt\rr\nn\"\"";
    public static final float FRACTIONAL_PRECISION = 100000.0f;
    public static final float CARTESIAN_PRECISION = 10000.0f;

    public static int parseInt(String string) {
        return PT.parseIntNext(string, new int[]{0});
    }

    public static int parseIntNext(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] < 0 || nArray[0] >= n) {
            return Integer.MIN_VALUE;
        }
        return PT.parseIntChecked(string, n, nArray);
    }

    public static int parseIntChecked(String string, int n, int[] nArray) {
        char c;
        boolean bl = false;
        int n2 = 0;
        int n3 = nArray[0];
        if (n3 < 0) {
            return Integer.MIN_VALUE;
        }
        while (n3 < n && PT.isWhiteSpace(string, n3)) {
            ++n3;
        }
        boolean bl2 = false;
        if (n3 < n && string.charAt(n3) == '-') {
            bl2 = true;
            ++n3;
        }
        while (n3 < n && (c = string.charAt(n3)) >= '0' && c <= '9') {
            n2 = n2 * 10 + (c - 48);
            bl = true;
            ++n3;
        }
        if (!bl) {
            n2 = Integer.MIN_VALUE;
        } else if (bl2) {
            n2 = -n2;
        }
        nArray[0] = n3;
        return n2;
    }

    public static boolean isWhiteSpace(String string, int n) {
        char c;
        return n >= 0 && ((c = string.charAt(n)) == ' ' || c == '\t' || c == '\n');
    }

    public static float parseFloatChecked(String string, int n, int[] nArray, boolean bl) {
        float f;
        int n2;
        int n3;
        boolean bl2 = false;
        if (bl && string.indexOf(10) != string.lastIndexOf(10)) {
            return Float.NaN;
        }
        for (n3 = nArray[0]; n3 < n && PT.isWhiteSpace(string, n3); ++n3) {
        }
        boolean bl3 = false;
        if (n3 < n && string.charAt(n3) == '-') {
            ++n3;
            bl3 = true;
        }
        char c = '\u0000';
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (n3 < n && (c = string.charAt(n3)) >= '0' && c <= '9') {
            f2 = f2 * 10.0f + (float)(c - 48) * 1.0f;
            ++n3;
            bl2 = true;
        }
        boolean bl4 = false;
        int n4 = 0;
        int n5 = n2 = f2 == 0.0f ? -1 : 0;
        if (c == '.') {
            bl4 = true;
            while (++n3 < n && (c = string.charAt(n3)) >= '0' && c <= '9') {
                bl2 = true;
                if (n2 < 0) {
                    if (c == '0') {
                        --n2;
                        continue;
                    }
                    n2 = -n2;
                }
                if (n4 >= decimalScale.length) continue;
                f3 = f3 * 10.0f + (float)(c - 48) * 1.0f;
                ++n4;
            }
        }
        if (!bl2) {
            f = Float.NaN;
        } else if (f3 > 0.0f) {
            f = f3 * decimalScale[n4 - 1];
            f = n2 > 1 ? (n2 - 2 < decimalScale.length ? (f *= decimalScale[n2 - 2]) : (float)((double)f * Math.pow(10.0, 1 - n2))) : (f += f2);
        } else {
            f = f2;
        }
        boolean bl5 = false;
        if (n3 < n && (c == 'E' || c == 'e' || c == 'D')) {
            bl5 = true;
            if (++n3 >= n) {
                return Float.NaN;
            }
            c = string.charAt(n3);
            if (c == '+' && ++n3 >= n) {
                return Float.NaN;
            }
            nArray[0] = n3;
            int n6 = PT.parseIntChecked(string, n, nArray);
            if (n6 == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (n6 > 0 && n6 <= tensScale.length) {
                f *= tensScale[n6 - 1];
            } else if (n6 < 0 && -n6 <= decimalScale.length) {
                f *= decimalScale[-n6 - 1];
            } else if (n6 != 0) {
                f = (float)((double)f * Math.pow(10.0, n6));
            }
        } else {
            nArray[0] = n3;
        }
        if (bl3) {
            f = -f;
        }
        if (f == Float.POSITIVE_INFINITY) {
            f = Float.MAX_VALUE;
        }
        return !bl || (!bl5 || bl4) && PT.checkTrailingText(string, nArray[0], n) ? f : Float.NaN;
    }

    public static boolean checkTrailingText(String string, int n, int n2) {
        char c;
        while (n < n2 && (PT.isWhitespace(c = string.charAt(n)) || c == ';')) {
            ++n;
        }
        return n == n2;
    }

    public static float[] parseFloatArray(String string) {
        return PT.parseFloatArrayNext(string, new int[1], null, null, null);
    }

    public static int parseFloatArrayInfested(String[] stringArray, float[] fArray) {
        int n = fArray.length;
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i >= 0 && i < n && n3 < n2; ++i) {
            float f;
            while (Float.isNaN(f = PT.parseFloat(stringArray[n3++])) && n3 < n2) {
            }
            if (!Float.isNaN(f)) {
                n4 = i;
                fArray[n4] = f;
            }
            if (n3 == n2) break;
        }
        return n4 + 1;
    }

    public static float[] parseFloatArrayNext(String string, int[] nArray, float[] fArray, String string2, String string3) {
        int n = 0;
        int n2 = nArray[0];
        if (n2 >= 0) {
            int n3;
            if (string2 != null && (n3 = string.indexOf(string2, n2)) >= 0) {
                nArray[0] = n3 + string2.length();
            }
            string = string.substring(nArray[0]);
            int n4 = n2 = string3 == null ? -1 : string.indexOf(string3);
            if (n2 < 0) {
                n2 = string.length();
            } else {
                string = string.substring(0, n2);
            }
            nArray[0] = nArray[0] + (n2 + 1);
            String[] stringArray = PT.getTokens(string);
            if (fArray == null) {
                fArray = new float[stringArray.length];
            }
            n = PT.parseFloatArrayInfested(stringArray, fArray);
        }
        if (fArray == null) {
            return new float[0];
        }
        for (int i = n; i < fArray.length; ++i) {
            fArray[i] = Float.NaN;
        }
        return fArray;
    }

    public static float parseFloatRange(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] < 0 || nArray[0] >= n) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(string, n, nArray, false);
    }

    public static float parseFloatNext(String string, int[] nArray) {
        int n = string == null ? -1 : string.length();
        return nArray[0] < 0 || nArray[0] >= n ? Float.NaN : PT.parseFloatChecked(string, n, nArray, false);
    }

    public static float parseFloatStrict(String string) {
        int n = string.length();
        if (n == 0) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(string, n, new int[]{0}, true);
    }

    public static float parseFloat(String string) {
        return PT.parseFloatNext(string, new int[]{0});
    }

    public static int parseIntRadix(String string, int n) throws NumberFormatException {
        return Integer.parseInt(string, n);
    }

    public static String[] getTokens(String string) {
        return PT.getTokensAt(string, 0);
    }

    public static String parseToken(String string) {
        return PT.parseTokenNext(string, new int[]{0});
    }

    public static String parseTrimmed(String string) {
        return PT.parseTrimmedRange(string, 0, string.length());
    }

    public static String parseTrimmedAt(String string, int n) {
        return PT.parseTrimmedRange(string, n, string.length());
    }

    public static String parseTrimmedRange(String string, int n, int n2) {
        int n3 = string.length();
        if (n2 < n3) {
            n3 = n2;
        }
        if (n3 < n) {
            return "";
        }
        return PT.parseTrimmedChecked(string, n, n3);
    }

    public static String[] getTokensAt(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n < 0 || n > n2) {
            return null;
        }
        int n3 = PT.countTokens(string, n);
        String[] stringArray = new String[n3];
        int[] nArray = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = PT.parseTokenChecked(string, n2, nArray);
        }
        return stringArray;
    }

    public static int countChar(String string, char c) {
        int n = 0;
        int n2 = string.lastIndexOf(c) + 1;
        while (--n2 >= 0) {
            if (string.charAt(n2) != c) continue;
            ++n;
        }
        return n;
    }

    public static int countTokens(String string, int n) {
        int n2 = 0;
        if (string != null) {
            int n3 = string.length();
            while (true) {
                if (n < n3 && PT.isWhiteSpace(string, n)) {
                    ++n;
                    continue;
                }
                if (n == n3) break;
                ++n2;
                while (++n < n3 && !PT.isWhiteSpace(string, n)) {
                }
            }
        }
        return n2;
    }

    public static String parseTokenNext(String string, int[] nArray) {
        int n = string.length();
        return nArray[0] < 0 || nArray[0] >= n ? null : PT.parseTokenChecked(string, n, nArray);
    }

    public static String parseTokenRange(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        return nArray[0] < 0 || nArray[0] >= n ? null : PT.parseTokenChecked(string, n, nArray);
    }

    public static String parseTokenChecked(String string, int n, int[] nArray) {
        int n2;
        for (n2 = nArray[0]; n2 < n && PT.isWhiteSpace(string, n2); ++n2) {
        }
        int n3 = n2;
        while (n2 < n && !PT.isWhiteSpace(string, n2)) {
            ++n2;
        }
        nArray[0] = n2;
        return n3 == n2 ? null : string.substring(n3, n2);
    }

    public static String parseTrimmedChecked(String string, int n, int n2) {
        int n3;
        while (n < n2 && PT.isWhiteSpace(string, n)) {
            ++n;
        }
        for (n3 = n2 - 1; n3 >= n && PT.isWhiteSpace(string, n3); --n3) {
        }
        return n3 < n ? "" : string.substring(n, n3 + 1);
    }

    public static double dVal(String string) throws NumberFormatException {
        return Double.valueOf(string);
    }

    public static float fVal(String string) throws NumberFormatException {
        return Float.parseFloat(string);
    }

    public static int parseIntRange(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        return nArray[0] < 0 || nArray[0] >= n ? Integer.MIN_VALUE : PT.parseIntChecked(string, n, nArray);
    }

    public static void parseFloatArrayData(String[] stringArray, float[] fArray) {
        PT.parseFloatArrayDataN(stringArray, fArray, fArray.length);
    }

    public static void parseFloatArrayDataN(String[] stringArray, float[] fArray, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            fArray[n2] = n2 >= stringArray.length ? Float.NaN : PT.parseFloat(stringArray[n2]);
        }
    }

    public static String[] split(String string, String string2) {
        if (string.length() == 0) {
            return new String[0];
        }
        int n = 1;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        if (n2 < 0 || n3 == 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        int n4 = string.length() - n3;
        while (n2 >= 0 && n2 < n4) {
            n2 = string.indexOf(string2, n2 + n3);
            ++n;
        }
        String[] stringArray = new String[n];
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while ((n5 = string.indexOf(string2, n2)) >= 0 && n6 + 1 < n) {
            stringArray[n6++] = string.substring(n2, n5);
            n2 = n5 + n3;
        }
        if (string.indexOf(string2, n4) != n4) {
            n4 += n3;
        }
        stringArray[n6] = string.substring(n2, n4);
        return stringArray;
    }

    public static String getQuotedStringAt(String string, int n) {
        int[] nArray = new int[]{n};
        return PT.getQuotedStringNext(string, nArray);
    }

    public static String getQuotedStringNext(String string, int[] nArray) {
        int n = nArray[0];
        if (n < 0 || (n = string.indexOf("\"", n)) < 0) {
            return "";
        }
        int n2 = n + 1;
        int n3 = string.length();
        while (++n < n3 && string.charAt(n) != '\"') {
            if (string.charAt(n) != '\\') continue;
            ++n;
        }
        nArray[0] = n + 1;
        return string.substring(n2, n);
    }

    public static String getCSVString(String string, int[] nArray) {
        int n = nArray[1];
        if (n < 0 || (n = string.indexOf("\"", n)) < 0) {
            return null;
        }
        int n2 = nArray[0] = n;
        int n3 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        while (++n < n3 && (string.charAt(n) != '\"' || (bl = n + 1 < n3 && string.charAt(n + 1) == '\"'))) {
            if (!bl) continue;
            bl = false;
            bl2 = true;
            ++n;
        }
        if (n >= n3) {
            nArray[1] = -1;
            return null;
        }
        nArray[1] = n + 1;
        String string2 = string.substring(n2 + 1, n);
        return bl2 ? PT.rep(PT.rep(string2, "\"\"", "\u0000"), "\u0000", "\"") : string2;
    }

    public static boolean isOneOf(String string, String string2) {
        if (string2.length() == 0) {
            return false;
        }
        if (string2.charAt(0) != ';') {
            string2 = ";" + string2 + ";";
        }
        return string.indexOf(";") < 0 && string2.indexOf(';' + string + ';') >= 0;
    }

    public static String getQuotedAttribute(String string, String string2) {
        int n = string.indexOf(string2 + "=");
        return n < 0 ? null : PT.getQuotedStringAt(string, n);
    }

    public static float approx(float f, float f2) {
        return (float)Math.round(f * f2) / f2;
    }

    public static String rep(String string, String string2, String string3) {
        if (string == null || string2.length() == 0 || string.indexOf(string2) < 0) {
            return string;
        }
        boolean bl = string3.indexOf(string2) >= 0;
        do {
            string = string.replace(string2, string3);
        } while (!bl && string.indexOf(string2) >= 0);
        return string;
    }

    public static String formatF(float f, int n, int n2, boolean bl, boolean bl2) {
        return PT.formatS(DF.formatDecimal(f, n2), n, 0, bl, bl2);
    }

    public static String formatD(double d, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return PT.formatS(DF.formatDecimal((float)d, -1 - n2), n, 0, bl, bl2);
    }

    public static String formatS(String string, int n, int n2, boolean bl, boolean bl2) {
        if (string == null) {
            return "";
        }
        int n3 = string.length();
        if (n2 != Integer.MAX_VALUE && n2 > 0 && n2 < n3) {
            string = string.substring(0, n2);
        } else if (n2 < 0 && n3 + n2 >= 0) {
            string = string.substring(n3 + n2 + 1);
        }
        int n4 = n - string.length();
        if (n4 <= 0) {
            return string;
        }
        boolean bl3 = bl2 && !bl && string.charAt(0) == '-';
        char c = bl2 ? (char)'0' : ' ';
        char c2 = bl3 ? (char)'-' : c;
        SB sB = new SB();
        if (bl) {
            sB.append(string);
        }
        sB.appendC(c2);
        int n5 = n4;
        while (--n5 > 0) {
            sB.appendC(c);
        }
        if (!bl) {
            sB.append(bl3 ? c + string.substring(1) : string);
        }
        return sB.toString();
    }

    public static String replaceWithCharacter(String string, String string2, char c) {
        if (string == null) {
            return null;
        }
        int n = string2.length();
        while (--n >= 0) {
            string = string.replace(string2.charAt(n), c);
        }
        return string;
    }

    public static String replaceAllCharacters(String string, String string2, String string3) {
        int n = string2.length();
        while (--n >= 0) {
            String string4 = string2.substring(n, n + 1);
            string = PT.rep(string, string4, string3);
        }
        return string;
    }

    public static String trim(String string, String string2) {
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string2.length() == 0) {
            return string.trim();
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string2.indexOf(string.charAt(n2)) >= 0; ++n2) {
        }
        for (n = string.length() - 1; n > n2 && string2.indexOf(string.charAt(n)) >= 0; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static String trimQuotes(String string) {
        return string != null && string.length() > 1 && string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
    }

    public static boolean isNonStringPrimitive(Object object) {
        return object instanceof Number || object instanceof Boolean;
    }

    private static Object arrayGet(Object object, int n) {
        return Array.get(object, n);
    }

    public static String toJSON(String string, Object object) {
        if (object == null) {
            return PT.packageJSON(string, null);
        }
        if (PT.isNonStringPrimitive(object)) {
            return PT.packageJSON(string, object.toString());
        }
        String string2 = null;
        SB sB = null;
        while (true) {
            if (object instanceof String) {
                string2 = (String)object;
                if (string2.indexOf("{\"") == 0) break;
                string2 = PT.rep(string2, "\"", "\\\"");
                string2 = PT.rep(string2, "\n", "\\n");
                string2 = "\"" + string2 + "\"";
                break;
            }
            if (object instanceof JSONEncodable) {
                string2 = ((JSONEncodable)object).toJSON();
                if (string2 != null) break;
                string2 = "null";
                break;
            }
            sB = new SB();
            if (object instanceof Map) {
                sB.append("{ ");
                String string3 = "";
                for (String string4 : ((Map)object).keySet()) {
                    sB.append(string3).append(PT.packageJSON(string4, PT.toJSON(null, ((Map)object).get(string4))));
                    string3 = ",";
                }
                sB.append(" }");
                break;
            }
            if (object instanceof Lst) {
                sB.append("[ ");
                int n = ((Lst)object).size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sB.appendC(',');
                    }
                    sB.append(PT.toJSON(null, ((Lst)object).get(i)));
                }
                sB.append(" ]");
                break;
            }
            if (object instanceof M34) {
                int n = object instanceof M4 ? 4 : 3;
                float[] fArray = new float[n];
                M34 m34 = (M34)object;
                sB.appendC('[');
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sB.appendC(',');
                    }
                    m34.getRow(i, fArray);
                    sB.append(PT.toJSON(null, fArray));
                }
                sB.appendC(']');
                break;
            }
            string2 = PT.nonArrayString(object);
            if (string2 == null) {
                sB.append("[");
                int n = AU.getLength(object);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sB.appendC(',');
                    }
                    sB.append(PT.toJSON(null, PT.arrayGet(object, i)));
                }
                sB.append("]");
                break;
            }
            object = object.toString();
        }
        return PT.packageJSON(string, string2 == null ? sB.toString() : string2);
    }

    public static String nonArrayString(Object object) {
        try {
            Array.getLength(object);
            return null;
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    public static String byteArrayToJSON(byte[] byArray) {
        SB sB = new SB();
        sB.append("[");
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sB.appendC(',');
            }
            sB.appendI(byArray[i] & 0xFF);
        }
        sB.append("]");
        return sB.toString();
    }

    public static String packageJSON(String string, String string2) {
        return string == null ? string2 : "\"" + string + "\": " + string2;
    }

    public static String escapeUrl(String string) {
        string = PT.rep(string, "\n", "");
        string = PT.rep(string, "%", "%25");
        string = PT.rep(string, "#", "%23");
        string = PT.rep(string, "[", "%5B");
        string = PT.rep(string, "]", "%5D");
        string = PT.rep(string, " ", "%20");
        return string;
    }

    public static String esc(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        boolean bl = false;
        for (n = 0; n < escapable.length(); n += 2) {
            if (string.indexOf(escapable.charAt(n)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n < escapable.length()) {
                int n2 = -1;
                char c = escapable.charAt(n++);
                char c2 = escapable.charAt(n++);
                SB sB = new SB();
                int n3 = 0;
                while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
                    sB.append(string.substring(n3, n2)).appendC('\\').appendC(c2);
                    n3 = n2 + 1;
                }
                sB.append(string.substring(n3, string.length()));
                string = sB.toString();
            }
        }
        return "\"" + PT.escUnicode(string) + "\"";
    }

    public static String escUnicode(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) <= '\u007f') continue;
            String string2 = "0000" + Integer.toHexString(string.charAt(n));
            string = string.substring(0, n) + "\\u" + string2.substring(string2.length() - 4) + string.substring(n + 1);
        }
        return string;
    }

    public static String escF(float f) {
        String string = "" + f;
        return string;
    }

    public static String join(String[] stringArray, char c, int n) {
        if (stringArray.length < n) {
            return null;
        }
        SB sB = new SB();
        sB.append(stringArray[n++]);
        for (int i = n; i < stringArray.length; ++i) {
            sB.appendC(c).append(stringArray[i]);
        }
        return sB.toString();
    }

    public static boolean isLike(String string, String string2) {
        boolean bl = string.equals(string2);
        if (bl) {
            return true;
        }
        boolean bl2 = string2.startsWith("*");
        boolean bl3 = string2.endsWith("*");
        return !bl2 && !bl3 ? bl : (bl2 && bl3 ? string2.length() == 1 || string.contains(string2.substring(1, string2.length() - 1)) : (bl2 ? string.endsWith(string2.substring(1)) : string.startsWith(string2.substring(0, string2.length() - 1))));
    }

    public static Object getMapValueNoCase(Map<String, ?> map, String string) {
        if ("this".equals(string)) {
            return map;
        }
        Object obj = map.get(string);
        if (obj == null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(string)) continue;
                return entry.getValue();
            }
        }
        return obj;
    }

    public static String clean(String string) {
        return PT.rep(PT.replaceAllCharacters(string, " \t\n\r", " "), "  ", " ").trim();
    }

    public static String fdup(String string, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        block4: while (--n4 >= 1) {
            char c = string.charAt(n4);
            if (PT.isDigit(c)) continue;
            switch (c) {
                case '.': {
                    if (n3++ == 0) continue block4;
                    return string;
                }
                case '-': {
                    if (n4 == 1 || string.charAt(n4 - 1) == '.') continue block4;
                    return string;
                }
            }
            return string;
        }
        String string2 = string.substring(0, n + 1);
        SB sB = new SB();
        for (int i = 0; i < n2; ++i) {
            sB.append(string2);
        }
        sB.append(string.substring(n + 1));
        return sB.toString();
    }

    private static String formatString(String string, String string2, String string3, float f, double d, boolean bl) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return "";
        }
        int n3 = string2.length();
        if (string.indexOf("%") < 0 || n3 == 0 || string.indexOf(string2) < 0) {
            return string;
        }
        String string4 = "";
        int n4 = 0;
        while ((n2 = string.indexOf(37, n4)) >= 0 && (n = string.indexOf(string2, n2 + 1)) >= 0) {
            if (n4 != n2) {
                string4 = string4 + string.substring(n4, n2);
            }
            n4 = n2 + 1;
            if (n > n2 + 6) {
                string4 = string4 + '%';
                continue;
            }
            try {
                String string5;
                char c;
                boolean bl2 = false;
                if (string.charAt(n4) == '-') {
                    bl2 = true;
                    ++n4;
                }
                boolean bl3 = false;
                if (string.charAt(n4) == '0') {
                    bl3 = true;
                    ++n4;
                }
                int n5 = 0;
                while ((c = string.charAt(n4)) >= '0' && c <= '9') {
                    n5 = 10 * n5 + (c - 48);
                    ++n4;
                }
                int n6 = Integer.MAX_VALUE;
                boolean bl4 = false;
                if (string.charAt(n4) == '.') {
                    if ((c = string.charAt(++n4)) == '-') {
                        bl4 = string3 == null;
                        ++n4;
                    }
                    if ((c = string.charAt(n4)) >= '0' && c <= '9') {
                        n6 = c - 48;
                        ++n4;
                    }
                    if (bl4) {
                        n6 = -n6;
                    }
                }
                if (!(string5 = string.substring(n4, n4 + n3)).equals(string2)) {
                    n4 = n2 + 1;
                    string4 = string4 + '%';
                    continue;
                }
                n4 += n3;
                if (!Float.isNaN(f)) {
                    string4 = string4 + PT.formatF(f, n5, n6, bl2, bl3);
                } else if (string3 != null) {
                    string4 = string4 + PT.formatS(string3, n5, n6, bl2, bl3);
                } else if (!Double.isNaN(d)) {
                    string4 = string4 + PT.formatD(d, n5, n6 - 1, bl2, bl3, true);
                }
                if (!bl) continue;
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n4 = n2;
                break;
            }
        }
        string4 = string4 + string.substring(n4);
        return string4;
    }

    public static String formatStringS(String string, String string2, String string3) {
        return PT.formatString(string, string2, string3, Float.NaN, Double.NaN, false);
    }

    public static String formatStringF(String string, String string2, float f) {
        return PT.formatString(string, string2, null, f, Double.NaN, false);
    }

    public static String formatStringI(String string, String string2, int n) {
        return PT.formatString(string, string2, "" + n, Float.NaN, Double.NaN, false);
    }

    public static String sprintf(String string, String string2, Object[] objectArray) {
        if (objectArray == null) {
            return string;
        }
        int n = string2.length();
        if (n == objectArray.length) {
            try {
                block14: for (int i = 0; i < n; ++i) {
                    if (objectArray[i] == null) continue;
                    switch (string2.charAt(i)) {
                        case 's': {
                            string = PT.formatString(string, "s", (String)objectArray[i], Float.NaN, Double.NaN, true);
                            continue block14;
                        }
                        case 'f': {
                            string = PT.formatString(string, "f", null, ((Float)objectArray[i]).floatValue(), Double.NaN, true);
                            continue block14;
                        }
                        case 'i': {
                            string = PT.formatString(string, "d", "" + objectArray[i], Float.NaN, Double.NaN, true);
                            string = PT.formatString(string, "i", "" + objectArray[i], Float.NaN, Double.NaN, true);
                            continue block14;
                        }
                        case 'd': {
                            string = PT.formatString(string, "e", null, Float.NaN, (Double)objectArray[i], true);
                            continue block14;
                        }
                        case 'p': {
                            T3 t3 = (T3)objectArray[i];
                            string = PT.formatString(string, "p", null, t3.x, Double.NaN, true);
                            string = PT.formatString(string, "p", null, t3.y, Double.NaN, true);
                            string = PT.formatString(string, "p", null, t3.z, Double.NaN, true);
                            continue block14;
                        }
                        case 'q': {
                            T4 t4 = (T4)objectArray[i];
                            string = PT.formatString(string, "q", null, t4.x, Double.NaN, true);
                            string = PT.formatString(string, "q", null, t4.y, Double.NaN, true);
                            string = PT.formatString(string, "q", null, t4.z, Double.NaN, true);
                            string = PT.formatString(string, "q", null, t4.w, Double.NaN, true);
                            continue block14;
                        }
                        case 'S': {
                            String[] stringArray = (String[])objectArray[i];
                            for (int j = 0; j < stringArray.length; ++j) {
                                string = PT.formatString(string, "s", stringArray[j], Float.NaN, Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'F': {
                            float[] fArray = (float[])objectArray[i];
                            for (int j = 0; j < fArray.length; ++j) {
                                string = PT.formatString(string, "f", null, fArray[j], Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'I': {
                            int n2;
                            int[] nArray = (int[])objectArray[i];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                string = PT.formatString(string, "d", "" + nArray[n2], Float.NaN, Double.NaN, true);
                            }
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                string = PT.formatString(string, "i", "" + nArray[n2], Float.NaN, Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'D': {
                            double[] dArray = (double[])objectArray[i];
                            for (int j = 0; j < dArray.length; ++j) {
                                string = PT.formatString(string, "e", null, Float.NaN, dArray[j], true);
                            }
                            continue block14;
                        }
                    }
                }
                return PT.rep(string, "%%", "%");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("TextFormat.sprintf error " + string2 + " " + string);
        return PT.rep(string, "%", "?");
    }

    public static String formatCheck(String string) {
        if (string == null || string.indexOf(112) < 0 && string.indexOf(113) < 0) {
            return string;
        }
        string = PT.rep(string, "%%", "\u0001");
        string = PT.rep(string, "%p", "%6.2p");
        string = PT.rep(string, "%q", "%6.2q");
        String[] stringArray = PT.split(string, "%");
        SB sB = new SB();
        sB.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = "%" + stringArray[i];
            if (string2.length() >= 3) {
                int n = string2.indexOf(112);
                if (n >= 0) {
                    string2 = PT.fdup(string2, n, 3);
                }
                if ((n = string2.indexOf(113)) >= 0) {
                    string2 = PT.fdup(string2, n, 4);
                }
            }
            sB.append(string2);
        }
        return sB.toString().replace('\u0001', '%');
    }

    public static void leftJustify(SB sB, String string, String string2) {
        sB.append(string2);
        int n = string.length() - string2.length();
        if (n > 0) {
            sB.append(string.substring(0, n));
        }
    }

    public static void rightJustify(SB sB, String string, String string2) {
        int n = string.length() - string2.length();
        if (n > 0) {
            sB.append(string.substring(0, n));
        }
        sB.append(string2);
    }

    public static String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    public static boolean isWild(String string) {
        return string != null && (string.indexOf("*") >= 0 || string.indexOf("?") >= 0);
    }

    public static boolean isMatch(String string, String string2, boolean bl, boolean bl2) {
        int n;
        boolean bl3;
        boolean bl4;
        if (string.equals(string2)) {
            return true;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return false;
        }
        boolean bl5 = bl && bl2 ? string2.charAt(0) == '*' : (bl4 = false);
        if (n2 == 1 && bl4) {
            return true;
        }
        boolean bl6 = bl && string2.endsWith("*");
        boolean bl7 = bl3 = string2.indexOf(63) >= 0;
        if (!bl3) {
            if (bl4) {
                return bl6 ? n2 < 3 || string.indexOf(string2.substring(1, n2 - 1)) >= 0 : string.endsWith(string2.substring(1));
            }
            if (bl6) {
                return string.startsWith(string2.substring(0, n2 - 1));
            }
        }
        int n3 = string.length();
        String string3 = "????";
        for (n = 4; n < n3; n += 4) {
            string3 = string3 + string3;
        }
        if (bl) {
            if (bl4) {
                string2 = string3 + string2.substring(1);
                n2 += n - 1;
            }
            if (bl6) {
                string2 = string2.substring(0, n2 - 1) + string3;
                n2 += n - 1;
            }
        }
        if (n2 < n3) {
            return false;
        }
        int n4 = 0;
        while (n2 > n3) {
            if (bl2 && string2.charAt(n4) == '?') {
                ++n4;
            } else if (string2.charAt(n4 + n2 - 1) != '?') {
                return false;
            }
            --n2;
        }
        int n5 = n3;
        while (--n5 >= 0) {
            char c;
            char c2 = string2.charAt(n4 + n5);
            if (c2 == '?' || c2 == (c = string.charAt(n5)) || c2 == '\u0001' && c == '?') continue;
            return false;
        }
        return true;
    }

    public static String replaceQuotedStrings(String string, Lst<String> lst, Lst<String> lst2) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)lst.get(i);
            String string3 = (String)lst2.get(i);
            if (string3.equals(string2)) continue;
            string = PT.rep(string, "\"" + string2 + "\"", "\"" + string3 + "\"");
        }
        return string;
    }

    public static String replaceStrings(String string, Lst<String> lst, Lst<String> lst2) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)lst.get(i);
            String string3 = (String)lst2.get(i);
            if (string3.equals(string2)) continue;
            string = PT.rep(string, string2, string3);
        }
        return string;
    }

    public static boolean isDigit(char c) {
        char c2 = c;
        return '0' <= c2 && c2 <= '9';
    }

    public static boolean isUpperCase(char c) {
        char c2 = c;
        return 'A' <= c2 && c2 <= 'Z';
    }

    public static boolean isLowerCase(char c) {
        char c2 = c;
        return 'a' <= c2 && c2 <= 'z';
    }

    public static boolean isLetter(char c) {
        char c2 = c;
        return 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z';
    }

    public static boolean isLetterOrDigit(char c) {
        char c2 = c;
        return 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z' || '0' <= c2 && c2 <= '9';
    }

    public static boolean isWhitespace(char c) {
        char c2 = c;
        return c2 >= '\u001c' && c2 <= ' ' || c2 >= '\t' && c2 <= '\r';
    }

    public static void fixPtFloats(T3 t3, float f) {
        t3.x = (float)Math.round(t3.x * f) / f;
        t3.y = (float)Math.round(t3.y * f) / f;
        t3.z = (float)Math.round(t3.z * f) / f;
    }

    public static double fixDouble(double d, double d2) {
        return (double)Math.round(d * d2) / d2;
    }

    public static float parseFloatFraction(String string) {
        int n = string.indexOf("/");
        return n < 0 ? PT.parseFloat(string) : PT.parseFloat(string.substring(0, n)) / PT.parseFloat(string.substring(n + 1));
    }
}

