// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var BigInteger, mpi_byte_length, mpi_from_buffer, mpi_to_padded_octets, nbi, nbits, nbs, nbv, toMPI, _ref;

  _ref = require('bn'), nbv = _ref.nbv, nbi = _ref.nbi, BigInteger = _ref.BigInteger, nbits = _ref.nbits;

  nbs = function(s, base) {
    var r;
    if (base == null) {
      base = 10;
    }
    r = nbi();
    return r.fromString(s, base);
  };

  mpi_byte_length = function(bn) {
    return bn.toByteArray().length;
  };

  toMPI = function(bn) {
    var ba, hdr, size;
    ba = bn.toByteArray();
    size = (ba.length - 1) * 8 + nbits(ba[0]);
    hdr = new Buffer(2);
    hdr.writeUInt16BE(size, 0);
    return Buffer.concat([hdr, new Buffer(ba)]);
  };

  mpi_from_buffer = function(raw) {
    var err, hdr, i, n_bits, n_bytes;
    err = i = null;
    if (raw.length < 2) {
      err = new Error("need at least 2 bytes; got " + raw.length);
    } else {
      hdr = new Buffer(raw.slice(0, 2));
      raw = raw.slice(2);
      n_bits = hdr.readUInt16BE(0);
      n_bytes = Math.ceil(n_bits / 8);
      if (raw.length < n_bytes) {
        err = new Error("MPI said " + n_bytes + " bytes but only got " + raw.length);
      } else {
        i = nbi().fromBuffer(raw.slice(0, n_bytes));
        raw = raw.slice(n_bytes);
      }
    }
    return [err, i, raw, n_bytes + 2];
  };

  mpi_to_padded_octets = function(bn, base) {
    var ba, diff, i, n, pad;
    n = base.mpi_byte_length();
    ba = bn.toByteArray();
    diff = n - ba.length;
    pad = new Buffer((function() {
      var _i, _results;
      _results = [];
      for (i = _i = 0; 0 <= diff ? _i < diff : _i > diff; i = 0 <= diff ? ++_i : --_i) {
        _results.push(0);
      }
      return _results;
    })());
    return Buffer.concat([pad, new Buffer(ba)]);
  };

  exports.toMPI = toMPI;

  exports.nbs = nbs;

  exports.mpi_from_buffer = mpi_from_buffer;

  exports.mpi_to_padded_octets = mpi_to_padded_octets;

  BigInteger.prototype.to_mpi_buffer = function() {
    return toMPI(this);
  };

  BigInteger.prototype.mpi_byte_length = function() {
    return mpi_byte_length(this);
  };

  BigInteger.prototype.to_padded_octets = function(base) {
    return mpi_to_padded_octets(this, base);
  };

}).call(this);
