/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.SuggestionExtractor;

public class SuggestionExtractorTool {
    private void writeIgnoreTokensForLanguages() throws IOException {
        Map<Language, Set<String>> map = this.getLanguageToIgnoreTokensMapping();
        for (Map.Entry<Language, Set<String>> entry : map.entrySet()) {
            Language language = entry.getKey();
            File langDir = this.getLanguageDir(language);
            File hunspellDir = new File(langDir, "hunspell");
            if (!hunspellDir.exists()) {
                System.out.println("No directory " + hunspellDir + " found, ignoring language " + language);
                continue;
            }
            File ignoreFile = language.isVariant() ? new File(hunspellDir, "ignore-" + language.getCountries()[0] + ".txt") : new File(hunspellDir, "ignore.txt");
            Set<String> tokens = entry.getValue();
            try (FileOutputStream fos = new FileOutputStream(ignoreFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "utf-8");){
                this.writeIntro(writer, language);
                for (String token : tokens) {
                    writer.write(token);
                    writer.write("\n");
                }
            }
            System.out.println("Wrote " + tokens.size() + " words to " + ignoreFile);
        }
    }

    private Map<Language, Set<String>> getLanguageToIgnoreTokensMapping() throws IOException {
        HashMap<Language, Set<String>> langToIgnoreTokens = new HashMap<Language, Set<String>>();
        SuggestionExtractor extractor = new SuggestionExtractor();
        for (Language lang : Languages.get()) {
            HashSet<String> suggestionTokens = new HashSet<String>();
            JLanguageTool languageTool = new JLanguageTool(lang);
            Rule spellcheckRule = this.getSpellcheckRule(languageTool);
            if (spellcheckRule == null) {
                System.out.println("No spellchecker rule found for " + lang);
                continue;
            }
            List<Rule> rules = languageTool.getAllRules();
            int tokenCount = 0;
            int noErrorCount = 0;
            for (Rule rule : rules) {
                List<String> tokens = extractor.getSuggestionTokens(rule, lang);
                tokenCount += tokens.size();
                for (String token : tokens) {
                    AnalyzedSentence sentence = languageTool.getAnalyzedSentence(token);
                    RuleMatch[] matches = spellcheckRule.match(sentence);
                    if (matches.length > 0) {
                        suggestionTokens.add(token);
                        continue;
                    }
                    ++noErrorCount;
                }
            }
            System.out.println(lang + ": " + noErrorCount + " out of " + tokenCount + " words ignored because they are known to spellchecker anyway");
            Language noVariantLanguage = lang.getDefaultLanguageVariant() == null ? lang : lang.getDefaultLanguageVariant();
            Set existingTokens = (Set)langToIgnoreTokens.get(noVariantLanguage);
            if (existingTokens != null) {
                existingTokens.addAll(suggestionTokens);
                continue;
            }
            langToIgnoreTokens.put(noVariantLanguage, suggestionTokens);
        }
        return langToIgnoreTokens;
    }

    private File getLanguageDir(Language language) {
        String langCode = language.getShortName();
        File dir = new File("org/languagetool/resource", langCode);
        if (dir.exists()) {
            return dir;
        }
        return new File(langCode + "/src/main/resources/org/languagetool/resource/", langCode);
    }

    @Nullable
    private Rule getSpellcheckRule(JLanguageTool languageTool) {
        List<Rule> allActiveRules = languageTool.getAllActiveRules();
        for (Rule activeRule : allActiveRules) {
            if (!(activeRule instanceof SpellingCheckRule)) continue;
            ((SpellingCheckRule)activeRule).setConsiderIgnoreWords(false);
            return activeRule;
        }
        return null;
    }

    private void writeIntro(Writer writer, Language language) throws IOException {
        writer.write("# words to be ignored by the spellchecker (auto-generated)\n");
        this.writeArtificialTestCaseItems(writer, language);
    }

    private void writeArtificialTestCaseItems(Writer writer, Language language) throws IOException {
        if (language.getShortName().equals("en-US")) {
            writer.write("anArtificialTestWordForLanguageTool\n");
        } else if (language.getShortName().equals("de-DE")) {
            writer.write("einPseudoWortF\u00fcrLanguageToolTests\n");
        }
    }

    public static void main(String[] args) throws IOException {
        if (Languages.get().size() < 5) {
            throw new RuntimeException("Found only " + Languages.get().size() + " languages in classpath. " + "Please run this class with the classpath of 'languagetool-standalone' to have access to all languages.");
        }
        List<String> dirs = Arrays.asList(new File(".").list());
        if (!dirs.contains("en") || !dirs.contains("de")) {
            throw new RuntimeException("Please set the working directory to 'languagetool-language-modules' when running this class");
        }
        SuggestionExtractorTool extractor = new SuggestionExtractorTool();
        extractor.writeIgnoreTokensForLanguages();
    }
}

