/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import junit.framework.TestCase;
import org.junit.Assert;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public class AnalyzedSentenceTest
extends TestCase {
    public void testToString() {
        AnalyzedTokenReadings[] words = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("", "SENT_START", null)), new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma")), new AnalyzedTokenReadings(new AnalyzedToken(".", "INTERP", null))};
        words[2].addReading(new AnalyzedToken(".", "SENT_END", null));
        AnalyzedSentence sentence = new AnalyzedSentence(words);
        AnalyzedSentenceTest.assertEquals((String)"<S> word[lemma/POS].[./INTERP,</S>]", (String)sentence.toString());
    }

    public void testCopy() {
        AnalyzedTokenReadings[] words = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("", "SENT_START", null)), new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma")), new AnalyzedTokenReadings(new AnalyzedToken(".", "INTERP", null))};
        words[2].addReading(new AnalyzedToken(".", "SENT_END", null));
        AnalyzedSentence sentence = new AnalyzedSentence(words);
        AnalyzedSentence copySentence = sentence.copy(sentence);
        AnalyzedSentenceTest.assertEquals((Object)sentence, (Object)copySentence);
        words[1].immunize();
        AnalyzedSentenceTest.assertEquals((String)"<S> word[lemma/POS{!}].[./INTERP,</S>]", (String)sentence.toString());
        Assert.assertNotEquals((Object)sentence, (Object)copySentence);
    }
}

