/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.RejectedExecutionException;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.language.Demo;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.patterns.PatternRule;

public class MultiThreadedJLanguageToolTest {
    @Test
    public void testCheck() throws IOException {
        MultiThreadedJLanguageTool lt1 = new MultiThreadedJLanguageTool((Language)new Demo());
        List<String> ruleMatchIds1 = this.getRuleMatchIds((JLanguageTool)lt1);
        TestCase.assertEquals((int)9, (int)ruleMatchIds1.size());
        Assert.assertEquals((long)4L, (long)lt1.getSentenceCount());
        lt1.shutdown();
        JLanguageTool lt2 = new JLanguageTool((Language)new Demo());
        List<String> ruleMatchIds2 = this.getRuleMatchIds(lt2);
        TestCase.assertEquals(ruleMatchIds1, ruleMatchIds2);
        Assert.assertEquals((long)4L, (long)lt1.getSentenceCount());
    }

    @Test
    public void testShutdownException() throws IOException {
        MultiThreadedJLanguageTool tool = new MultiThreadedJLanguageTool((Language)new Demo());
        this.getRuleMatchIds((JLanguageTool)tool);
        tool.shutdown();
        try {
            this.getRuleMatchIds((JLanguageTool)tool);
            TestCase.fail((String)"should have been rejected as the thread pool has been shut down");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testTextAnalysis() throws IOException {
        MultiThreadedJLanguageTool lt = new MultiThreadedJLanguageTool((Language)new Demo());
        List analyzedSentences = lt.analyzeText("This is a sentence. And another one.");
        MatcherAssert.assertThat((Object)analyzedSentences.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((AnalyzedSentence)analyzedSentences.get(0)).getTokens().length, (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)((AnalyzedSentence)analyzedSentences.get(0)).getTokensWithoutWhitespace().length, (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((Object)((AnalyzedSentence)analyzedSentences.get(1)).getTokens().length, (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)((AnalyzedSentence)analyzedSentences.get(1)).getTokensWithoutWhitespace().length, (Matcher)CoreMatchers.is((Object)5));
        lt.shutdown();
    }

    @Test
    public void testConfigurableThreadPoolSize() throws IOException {
        MultiThreadedJLanguageTool lt = new MultiThreadedJLanguageTool((Language)new Demo());
        Assert.assertEquals((long)Runtime.getRuntime().availableProcessors(), (long)lt.getThreadPoolSize());
        lt.shutdown();
    }

    private List<String> getRuleMatchIds(JLanguageTool langTool) throws IOException {
        String input = "A small toast. No error here. Foo go bar. First goes last there, please!";
        List matches = langTool.check("A small toast. No error here. Foo go bar. First goes last there, please!");
        ArrayList<String> ruleMatchIds = new ArrayList<String>();
        for (RuleMatch match : matches) {
            ruleMatchIds.add(match.getRule().getId());
        }
        return ruleMatchIds;
    }

    @Test
    public void testTwoRulesOnly() throws IOException {
        MultiThreadedJLanguageTool lt = new MultiThreadedJLanguageTool((Language)new FakeLanguage(){

            @Override
            protected synchronized List<PatternRule> getPatternRules() {
                return Collections.emptyList();
            }

            @Override
            public List<Rule> getRelevantRules(ResourceBundle messages) {
                return Arrays.asList(new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this));
            }
        });
        MatcherAssert.assertThat((Object)lt.check("my test  text").size(), (Matcher)CoreMatchers.is((Object)2));
        lt.shutdown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalThreadPoolSize1() throws IOException {
        new MultiThreadedJLanguageTool((Language)new Demo(), 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalThreadPoolSize2() throws IOException {
        new MultiThreadedJLanguageTool((Language)new Demo(), null, 0);
    }
}

