/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.SameTranslationRule;

public class SameTranslationRuleTest
extends TestCase {
    public void testRule() throws IOException {
        SameTranslationRule rule = new SameTranslationRule();
        JLanguageTool srcLangTool = new JLanguageTool(TestTools.getDemoLanguage());
        JLanguageTool trgLangTool = new JLanguageTool((Language)new FakeLanguage());
        rule.setSourceLanguage(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(srcLangTool.getAnalyzedSentence("This is a test sentence."), trgLangTool.getAnalyzedSentence("C'est la vie !"));
        SameTranslationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(srcLangTool.getAnalyzedSentence("Elvis Presley"), trgLangTool.getAnalyzedSentence("Elvis Presley"));
        SameTranslationRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(srcLangTool.getAnalyzedSentence("This this is a test sentence."), trgLangTool.getAnalyzedSentence("This this is a test sentence."));
        SameTranslationRuleTest.assertEquals((int)1, (int)matches.length);
    }
}

