/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.TestTools;
import org.languagetool.XMLValidator;
import org.languagetool.rules.patterns.PatternTestTools;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tagging.disambiguation.rules.DisambiguationRuleLoader;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tools.StringTools;
import org.xml.sax.SAXException;

public class DisambiguationRuleTest
extends TestCase {
    public void testDisambiguationRulesFromXML() throws Exception {
        this.testDisambiguationRulesFromXML(null);
    }

    private void testDisambiguationRulesFromXML(Set<Language> ignoredLanguages) throws IOException, ParserConfigurationException, SAXException {
        for (Language lang : Languages.get()) {
            if (ignoredLanguages != null && ignoredLanguages.contains(lang)) continue;
            System.out.println("Running disambiguation tests for " + lang.getName() + "...");
            DisambiguationRuleLoader ruleLoader = new DisambiguationRuleLoader();
            JLanguageTool languageTool = new JLanguageTool(lang);
            if (languageTool.getLanguage().getDisambiguator() instanceof DemoDisambiguator) continue;
            String name = JLanguageTool.getDataBroker().getResourceDir() + "/" + lang.getShortName() + "/disambiguation.xml";
            this.validateRuleFile(name);
            List rules = ruleLoader.getRules(ruleLoader.getClass().getResourceAsStream(name));
            for (DisambiguationPatternRule rule : rules) {
                PatternTestTools.warnIfRegexpSyntaxNotKosher(rule.getPatternTokens(), rule.getId(), rule.getSubId(), lang);
            }
            this.testDisambiguationRulesFromXML(rules, languageTool, lang);
            System.out.println(rules.size() + " rules tested.");
        }
    }

    private void validateRuleFile(String filePath) throws IOException {
        XMLValidator validator = new XMLValidator();
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(filePath);){
            if (stream != null) {
                validator.validateWithXmlSchema(filePath, JLanguageTool.getDataBroker().getResourceDir() + "/disambiguation.xsd");
            }
        }
    }

    private static String sortForms(String wordForms) {
        if (",[,]".equals(wordForms)) {
            return wordForms;
        }
        String word = wordForms.substring(0, wordForms.indexOf(91) + 1);
        String forms = wordForms.substring(wordForms.indexOf(91) + 1, wordForms.length() - 1);
        Object[] formToSort = forms.split(",");
        Arrays.sort(formToSort);
        return word + StringTools.listToString(Arrays.asList(formToSort), (String)",") + "]";
    }

    private void testDisambiguationRulesFromXML(List<DisambiguationPatternRule> rules, JLanguageTool languageTool, Language lang) throws IOException {
        for (DisambiguationPatternRule rule : rules) {
            List examples;
            String id = rule.getId();
            if (rule.getUntouchedExamples() != null) {
                List goodSentences = rule.getUntouchedExamples();
                for (String goodSentence : goodSentences) {
                    goodSentence = goodSentence.replaceAll("[\\n\\t]+", "");
                    DisambiguationRuleTest.assertTrue(((goodSentence = DisambiguationRuleTest.cleanXML(goodSentence)).trim().length() > 0 ? 1 : 0) != 0);
                    AnalyzedSentence sent = DisambiguationRuleTest.disambiguateUntil(rules, id, languageTool.getRawAnalyzedSentence(goodSentence));
                    AnalyzedSentence sentToReplace = DisambiguationRuleTest.disambiguateUntil(rules, id, languageTool.getRawAnalyzedSentence(goodSentence));
                    DisambiguationRuleTest.assertEquals((String)("The untouched example (" + goodSentence + ") for " + lang.getName() + " rule " + rule + "] was touched!"), (String)sent.toString(), (String)rule.replace(sentToReplace).toString());
                }
            }
            if ((examples = rule.getExamples()) == null) continue;
            for (DisambiguatedExample example : examples) {
                AnalyzedTokenReadings[] r;
                String outputForms = example.getDisambiguated();
                DisambiguationRuleTest.assertTrue((String)("No input form found for: " + id), (outputForms != null ? 1 : 0) != 0);
                DisambiguationRuleTest.assertTrue((outputForms.trim().length() > 0 ? 1 : 0) != 0);
                int expectedMatchStart = example.getExample().indexOf("<marker>");
                int expectedMatchEnd = example.getExample().indexOf("</marker>") - "<marker>".length();
                if (expectedMatchStart == -1 || expectedMatchEnd == -1) {
                    DisambiguationRuleTest.fail((String)(lang + ": No position markup ('<marker>...</marker>') in disambiguated example in rule " + rule));
                }
                String inputForms = example.getAmbiguous();
                DisambiguationRuleTest.assertTrue((String)("No input form found for: " + id), (inputForms != null ? 1 : 0) != 0);
                DisambiguationRuleTest.assertTrue((inputForms.trim().length() > 0 ? 1 : 0) != 0);
                DisambiguationRuleTest.assertTrue((String)("Input and output forms for rule " + id + " are the same!"), (!outputForms.equals(inputForms) ? 1 : 0) != 0);
                AnalyzedSentence cleanInput = languageTool.getRawAnalyzedSentence(DisambiguationRuleTest.cleanXML(example.getExample()));
                AnalyzedSentence sent = DisambiguationRuleTest.disambiguateUntil(rules, id, languageTool.getRawAnalyzedSentence(DisambiguationRuleTest.cleanXML(example.getExample())));
                AnalyzedSentence disambiguatedSent = rule.replace(DisambiguationRuleTest.disambiguateUntil(rules, id, languageTool.getRawAnalyzedSentence(DisambiguationRuleTest.cleanXML(example.getExample()))));
                DisambiguationRuleTest.assertTrue((String)("Disambiguated sentence is equal to the non-disambiguated sentence for rule: " + id), (!cleanInput.equals((Object)disambiguatedSent) ? 1 : 0) != 0);
                DisambiguationRuleTest.assertTrue((String)("Disambiguated sentence is equal to the input sentence for rule: " + id + ". The sentence was: " + sent), (!sent.equals((Object)disambiguatedSent) ? 1 : 0) != 0);
                String reading = "";
                String annotations = "";
                for (AnalyzedTokenReadings readings : sent.getTokens()) {
                    if (readings.isSentenceStart() && !inputForms.contains("<S>") || readings.getStartPos() != expectedMatchStart) continue;
                    r = new AnalyzedTokenReadings[]{readings};
                    reading = new AnalyzedSentence(r).toShortString(",");
                    annotations = readings.getHistoricalAnnotations();
                    int startPos = readings.getStartPos();
                    int endPos = readings.getEndPos();
                    DisambiguationRuleTest.assertTrue((String)("Wrong marker position in the example for the rule " + id + ": got " + startPos + "-" + endPos + ", expected " + expectedMatchStart + "-" + expectedMatchEnd), (startPos == expectedMatchStart && endPos == expectedMatchEnd ? 1 : 0) != 0);
                    break;
                }
                DisambiguationRuleTest.assertEquals((String)("The input form for the rule " + id + " in the example: " + example + " is different than expected (expected " + inputForms + " but got " + DisambiguationRuleTest.sortForms(reading) + "). The token has been changed by the disambiguator: " + annotations), (String)inputForms, (String)DisambiguationRuleTest.sortForms(reading));
                for (AnalyzedTokenReadings readings : disambiguatedSent.getTokens()) {
                    if (readings.isSentenceStart() && !outputForms.contains("<S>") || readings.getStartPos() != expectedMatchStart) continue;
                    r = new AnalyzedTokenReadings[]{readings};
                    reading = new AnalyzedSentence(r).toShortString(",");
                    DisambiguationRuleTest.assertTrue((readings.getStartPos() == expectedMatchStart && readings.getEndPos() == expectedMatchEnd ? 1 : 0) != 0);
                    break;
                }
                DisambiguationRuleTest.assertEquals((String)("The output form for the rule " + id + " in the example: " + example + " is different than expected (expected " + outputForms + " but got " + DisambiguationRuleTest.sortForms(reading) + "). The token has been changed by the disambiguator: " + annotations), (String)outputForms, (String)DisambiguationRuleTest.sortForms(reading));
            }
        }
    }

    private static AnalyzedSentence disambiguateUntil(List<DisambiguationPatternRule> rules, String ruleID, AnalyzedSentence sentence) throws IOException {
        AnalyzedSentence disambiguated = sentence;
        for (DisambiguationPatternRule rule : rules) {
            if (ruleID.equals(rule.getId())) break;
            disambiguated = rule.replace(disambiguated);
        }
        return disambiguated;
    }

    private static String cleanXML(String str) {
        return str.replaceAll("<.*?>", "");
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        DisambiguationRuleTest test = new DisambiguationRuleTest();
        System.out.println("Running disambiguator rule tests...");
        if (args.length == 0) {
            test.testDisambiguationRulesFromXML(null);
        } else {
            Set<Language> ignoredLanguages = TestTools.getLanguagesExcept(args);
            test.testDisambiguationRulesFromXML(ignoredLanguages);
        }
        System.out.println("Tests successful.");
    }
}

