/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import com.google.common.base.Optional;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObject;
import com.optimaize.langdetect.text.TextObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;

public class LanguageIdentifier {
    private static final double MINIMAL_CONFIDENCE = 0.9;
    private static final List<String> ignoreLangCodes = Arrays.asList("ast", "gl");
    private static final List<String> externalLangCodes = Arrays.asList("eo");
    private final LanguageDetector languageDetector;
    private final TextObjectFactory textObjectFactory;

    public LanguageIdentifier() {
        try {
            List<LanguageProfile> profiles = this.loadProfiles(LanguageIdentifier.getLanguageCodes());
            this.languageDetector = LanguageDetectorBuilder.create((NgramExtractor)NgramExtractors.standard()).minimalConfidence(0.9).withProfiles(profiles).build();
            this.textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up language identifier", e);
        }
    }

    private static List<String> getLanguageCodes() {
        ArrayList<String> langCodes = new ArrayList<String>();
        for (Language lang : Languages.get()) {
            String langCode = lang.getShortName();
            boolean ignore = lang.isVariant() || ignoreLangCodes.contains(langCode) || externalLangCodes.contains(langCode);
            if (ignore) continue;
            if ("zh".equals(langCode)) {
                langCodes.add("zh-CN");
                langCodes.add("zh-TW");
                continue;
            }
            langCodes.add(langCode);
        }
        return langCodes;
    }

    private List<LanguageProfile> loadProfiles(List<String> langCodes) throws IOException {
        LanguageProfileReader profileReader = new LanguageProfileReader();
        List profiles = profileReader.read(langCodes);
        for (String externalLangCode : externalLangCodes) {
            String profilePath = "/" + externalLangCode + "/" + externalLangCode + ".profile";
            if (!JLanguageTool.getDataBroker().resourceExists(profilePath)) continue;
            InputStream profile = JLanguageTool.getDataBroker().getFromResourceDirAsStream(profilePath);
            Throwable throwable = null;
            try {
                profiles.add(new LanguageProfileReader().read(profile));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (profile == null) continue;
                if (throwable != null) {
                    try {
                        profile.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                profile.close();
            }
        }
        return profiles;
    }

    @Nullable
    public Language detectLanguage(String text) {
        String languageCode = this.detectLanguageCode(text);
        if (languageCode != null) {
            return Languages.getLanguageForShortName(languageCode);
        }
        return null;
    }

    @Nullable
    private String detectLanguageCode(String text) {
        TextObject textObject = this.textObjectFactory.forText((CharSequence)text);
        Optional lang = this.languageDetector.detect((CharSequence)textObject);
        if (lang.isPresent()) {
            return ((LdLocale)lang.get()).getLanguage();
        }
        return null;
    }
}

