/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;

public class CombiningTagger
implements WordTagger {
    private final WordTagger tagger1;
    private final WordTagger tagger2;
    private final boolean overwriteWithSecondTagger;

    public CombiningTagger(WordTagger tagger1, WordTagger tagger2, boolean overwriteWithSecondTagger) {
        this.tagger1 = tagger1;
        this.tagger2 = tagger2;
        this.overwriteWithSecondTagger = overwriteWithSecondTagger;
    }

    @Override
    public List<TaggedWord> tag(String word) {
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>();
        result.addAll(this.tagger2.tag(word));
        if (!this.overwriteWithSecondTagger || result.size() <= 0) {
            result.addAll(this.tagger1.tag(word));
        }
        return result;
    }
}

