/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.PACKAGE;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFutureTask<R>
implements Runnable,
Future {
    protected static final Logger Log = PACKAGE.Log;
    private ITaskListener taskListener;
    private static int COUNTER = 0;
    private final Object lockTask = new Object();
    private Throwable exception;
    private R result;
    private boolean cancelled = false;
    private boolean computed = false;
    private final int id = COUNTER++;
    private boolean active = false;
    private boolean asynch = false;

    protected AbstractFutureTask() {
    }

    protected AbstractFutureTask(ITaskListener iTaskListener) {
        this.taskListener = iTaskListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable basicGetException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    protected R basicGetResult() {
        return this.result;
    }

    protected void basicRun() {
        R r;
        try {
            r = this.compute();
        }
        catch (Throwable throwable) {
            this.setException(throwable);
            return;
        }
        if (!this.isAsynch()) {
            this.setResult(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        Object object = this.lockTask;
        synchronized (object) {
            block9: {
                block8: {
                    if (!this.cancelled) break block8;
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " can't cancel, already canceled");
                    }
                    return false;
                }
                if (!this.computed) break block9;
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " can't cancel, already computed");
                }
                return false;
            }
            if (Log.isLoggable(Level.FINEST)) {
                Log.finest(this + " cancel " + (this.active ? "active" : "inactive") + " task");
            }
            this.cancelled = true;
            this.active = false;
            this.lockTask.notifyAll();
        }
        this.taskCancelled();
        return true;
    }

    protected abstract R compute() throws Exception;

    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = TimeUnit.NANOSECONDS.convert(l, timeUnit);
        long l3 = System.nanoTime();
        Object object = this.lockTask;
        synchronized (object) {
            while (true) {
                long l4;
                if (this.cancelled) {
                    throw new CancellationException();
                }
                if (this.computed) {
                    if (this.exception == null) return this.result;
                    throw new ExecutionException(this.exception);
                }
                if (l < 0L) return null;
                if (l != 0L) {
                    l4 = System.nanoTime();
                    l2 -= l4 - l3;
                    l3 = l4;
                }
                if ((l4 = TimeUnit.MILLISECONDS.convert(l2, TimeUnit.NANOSECONDS)) <= 0L && l != 0L) {
                    throw new TimeoutException();
                }
                this.lockTask.wait(l4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITaskListener getTaskListener() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.taskListener;
        }
    }

    protected final void handleException() {
        block8: {
            try {
                try {
                    if (this.cancelled) {
                        if (Log.isLoggable(Level.FINEST)) {
                            Log.finest(this + " exception after cancel");
                        }
                        this.undo();
                        break block8;
                    }
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " exception, propagate");
                    }
                    this.taskFailed();
                }
                catch (Exception exception) {
                    Log.log(Level.SEVERE, this + " exception in exception handling", exception);
                    this.handleFinally();
                }
            }
            finally {
                this.handleFinally();
            }
        }
    }

    protected final void handleFinally() {
        try {
            if (Log.isLoggable(Level.FINEST)) {
                Log.finest(this + " finally, propagate");
            }
            this.taskFinally();
        }
        catch (Exception exception) {
            Log.log(Level.SEVERE, this + " exception in finally handling", exception);
        }
    }

    protected final void handleResult() {
        block8: {
            try {
                try {
                    if (this.cancelled) {
                        if (Log.isLoggable(Level.FINEST)) {
                            Log.finest(this + " computed after cancel, undo");
                        }
                        this.undo();
                        break block8;
                    }
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " computed, propagate");
                    }
                    this.taskFinished();
                }
                catch (Exception exception) {
                    Log.log(Level.SEVERE, this + " exception in result handling", exception);
                    this.handleFinally();
                }
            }
            finally {
                this.handleFinally();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.active;
        }
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.computed || this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailed() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lockTask;
        synchronized (object) {
            this.active = false;
            this.computed = false;
            this.exception = null;
            this.result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.active || this.cancelled || this.computed) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " will not run" + (this.cancelled ? " (canceled)" : ""));
                }
                return;
            }
            this.active = true;
        }
        this.taskStarted();
        this.basicRun();
    }

    public final void runAsync() {
        this.setAsynch(true);
        this.run();
    }

    public void setAsynch(boolean bl) {
        this.asynch = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setException(Throwable throwable) {
        Object object = this.lockTask;
        synchronized (object) {
            this.computed = true;
            this.active = false;
            this.exception = throwable;
            this.lockTask.notifyAll();
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.finest(this + " computation failed");
        }
        this.handleException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(R r) {
        Object object = this.lockTask;
        synchronized (object) {
            this.computed = true;
            this.active = false;
            this.result = r;
            this.lockTask.notifyAll();
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.finest(this + " computation ready");
        }
        this.handleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskListener(ITaskListener iTaskListener) {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.active || this.cancelled || this.computed) {
                throw new IllegalStateException("already started");
            }
            this.taskListener = iTaskListener;
        }
    }

    protected void taskCancelled() {
        if (this.taskListener != null) {
            this.taskListener.taskCancelled(this);
        }
    }

    protected void taskFailed() {
        if (this.taskListener != null) {
            this.taskListener.taskFailed(this, new ExecutionException(this.basicGetException()));
        }
    }

    protected void taskFinally() {
    }

    protected void taskFinished() {
        if (this.taskListener != null) {
            this.taskListener.taskFinished(this, this.basicGetResult());
        }
    }

    protected void taskStarted() {
        if (this.taskListener != null) {
            this.taskListener.taskStarted(this);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " - " + this.id;
    }

    protected void undo() {
    }
}

